/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class Conditions {
    public static final int AND_CONJUNCTION = 1;
    public static final int OR_CONJUNCTION = 2;
    private ArrayList conditionList = new ArrayList();
    private int conjunction;

    private Conditions(int conjunction) {
        this.conjunction = conjunction;
    }

    public static Conditions getAndedConditions() {
        return new Conditions(1);
    }

    public static Conditions getOredConditions() {
        return new Conditions(2);
    }

    public void appendCondition(String condition) {
        if (condition != null) {
            this.conditionList.add(condition);
        }
    }

    public void appendCondition(Conditions conditions) {
        if (conditions != null) {
            this.conditionList.add(conditions);
        }
    }

    public boolean isEmpty() {
        return this.conditionList == null || this.conditionList.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Conditions.print(this, s);
        if (s.length() == 0) {
            return null;
        }
        return s.toString();
    }

    private static void print(Conditions c, StringBuffer s) {
        Conditions.flatten(c);
        if (c.conditionList.size() == 0) {
            return;
        }
        Iterator iter = ((AbstractList)c.conditionList).iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object o;
            if (i != 0) {
                if (c.conjunction == 1) {
                    s.append(" AND ");
                } else {
                    s.append(" OR ");
                }
            }
            if ((o = iter.next()) instanceof String) {
                s.append((String)o);
            } else {
                Conditions c2 = (Conditions)o;
                s.append("(");
                Conditions.print(c2, s);
                s.append(")");
            }
            ++i;
        }
    }

    private static void flatten(Conditions c) {
        if (c.conditionList.size() == 0) {
            return;
        }
        int i = 0;
        Object o = null;
        while (i < c.conditionList.size()) {
            o = c.conditionList.get(i);
            if (o instanceof Conditions) {
                Conditions c2 = o;
                if (c2.conjunction == c.conjunction || c2.conditionList.size() <= 1) {
                    c.conditionList.remove(i);
                    c.conditionList.addAll(i, c2.conditionList);
                    continue;
                }
            }
            ++i;
        }
    }
}

