/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ApiManager;
import com.systinet.uddi.database.DatabaseCoreException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class Constant {
    private static Category log = Category.getCategory((String)"com.systinet.persistence.query.Constant");
    static final Constant NULL_CONSTANT = new NullConstant();
    private static BoolConstant TRUE = new BoolConstant(true);
    private static BoolConstant FALSE = new BoolConstant(false);

    static String quote(String str) {
        try {
            return ApiManager.getApiManager().getDatabase().getQuoter().quote(str, true);
        }
        catch (DatabaseCoreException dbCoreE) {
            log.error("Cannot get DB Quoter", (Throwable)((Object)dbCoreE));
            return str;
        }
    }

    abstract String toSqlString();

    abstract boolean isCompatible(Class var1);

    public abstract void setPrepStmtParam(PreparedStatement var1, int var2) throws SQLException;

    String getPrepStmtString() {
        return "?";
    }

    public String toString() {
        return "Constant=" + this.toSqlString();
    }

    public static Constant valueOf(String string) {
        if (string == null) {
            return NULL_CONSTANT;
        }
        return new StringConstant(string);
    }

    public static Constant valueOf(Date date) {
        if (date == null) {
            return NULL_CONSTANT;
        }
        return new DateConstant(date);
    }

    public static Constant valueOf(char charVal) {
        return new CharConstant(charVal);
    }

    public static Constant valueOf(Character charObj) {
        if (charObj == null) {
            return NULL_CONSTANT;
        }
        return Constant.valueOf(charObj.charValue());
    }

    public static Constant valueOf(boolean boolVal) {
        return boolVal ? TRUE : FALSE;
    }

    public static Constant valueOf(Boolean boolObj) {
        if (boolObj == null) {
            return NULL_CONSTANT;
        }
        return Constant.valueOf((boolean)boolObj);
    }

    public static Constant valueOf(byte byteVal) {
        return new LongConstant(byteVal);
    }

    public static Constant valueOf(Byte byteObj) {
        if (byteObj == null) {
            return NULL_CONSTANT;
        }
        return Constant.valueOf((byte)byteObj);
    }

    public static Constant valueOf(short shortVal) {
        return new LongConstant(shortVal);
    }

    public static Constant valueOf(Short shortObj) {
        return Constant.valueOf((short)shortObj);
    }

    public static Constant valueOf(int intVal) {
        return new LongConstant(intVal);
    }

    public static Constant valueOf(Integer intObj) {
        if (intObj == null) {
            return NULL_CONSTANT;
        }
        return Constant.valueOf((int)intObj);
    }

    public static Constant valueOf(long longVal) {
        return new LongConstant(longVal);
    }

    public static Constant valueOf(Long longVal) {
        if (longVal == null) {
            return NULL_CONSTANT;
        }
        return Constant.valueOf((long)longVal);
    }

    public static Constant valueOf(float floatVal) {
        return new DoubleConstant(floatVal);
    }

    public static Constant valueOf(Float floatObj) {
        if (floatObj == null) {
            return NULL_CONSTANT;
        }
        return Constant.valueOf(floatObj.floatValue());
    }

    public static Constant valueOf(double doubleVal) {
        return new DoubleConstant(doubleVal);
    }

    public static Constant valueOf(Double doubleObj) {
        if (doubleObj == null) {
            return NULL_CONSTANT;
        }
        return Constant.valueOf((double)doubleObj);
    }

    private static class DoubleConstant
    extends Constant {
        private double value;
        static /* synthetic */ Class class$java$lang$Float;
        static /* synthetic */ Class class$java$lang$Double;

        public DoubleConstant(double value) {
            this.value = value;
        }

        public String toSqlString() {
            return String.valueOf(this.value);
        }

        public boolean isCompatible(Class withClass) {
            return withClass == Float.TYPE || withClass == (class$java$lang$Float == null ? (class$java$lang$Float = DoubleConstant.class$("java.lang.Float")) : class$java$lang$Float) || withClass == Double.TYPE || withClass == (class$java$lang$Double == null ? (class$java$lang$Double = DoubleConstant.class$("java.lang.Double")) : class$java$lang$Double);
        }

        public void setPrepStmtParam(PreparedStatement pstmt, int paramIndex) throws SQLException {
            pstmt.setDouble(paramIndex, this.value);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class LongConstant
    extends Constant {
        private long value;
        static /* synthetic */ Class class$java$lang$Long;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$lang$Short;
        static /* synthetic */ Class class$java$lang$Byte;

        public LongConstant(long value) {
            this.value = value;
        }

        public String toSqlString() {
            return String.valueOf(this.value);
        }

        public boolean isCompatible(Class withClass) {
            return withClass == Long.TYPE || withClass == (class$java$lang$Long == null ? (class$java$lang$Long = LongConstant.class$("java.lang.Long")) : class$java$lang$Long) || withClass == Integer.TYPE || withClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = LongConstant.class$("java.lang.Integer")) : class$java$lang$Integer) || withClass == Short.TYPE || withClass == (class$java$lang$Short == null ? (class$java$lang$Short = LongConstant.class$("java.lang.Short")) : class$java$lang$Short) || withClass == Byte.TYPE || withClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = LongConstant.class$("java.lang.Byte")) : class$java$lang$Byte);
        }

        public void setPrepStmtParam(PreparedStatement pstmt, int paramIndex) throws SQLException {
            pstmt.setLong(paramIndex, this.value);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class BoolConstant
    extends Constant {
        private boolean value;
        static /* synthetic */ Class class$java$lang$Boolean;

        BoolConstant(boolean value) {
            this.value = value;
        }

        String toSqlString() {
            return this.value ? "1" : "0";
        }

        boolean isCompatible(Class withClass) {
            return withClass == Boolean.TYPE || withClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BoolConstant.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        }

        public void setPrepStmtParam(PreparedStatement pstmt, int paramIndex) throws SQLException {
            pstmt.setBoolean(paramIndex, this.value);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class CharConstant
    extends Constant {
        private char value;
        static /* synthetic */ Class class$java$lang$Character;

        CharConstant(char value) {
            this.value = value;
        }

        String toSqlString() {
            if (this.value == '\'') {
                return Constant.quote("'");
            }
            return "'" + this.value + "'";
        }

        boolean isCompatible(Class withClass) {
            return withClass == Character.TYPE || withClass == (class$java$lang$Character == null ? (class$java$lang$Character = CharConstant.class$("java.lang.Character")) : class$java$lang$Character);
        }

        public void setPrepStmtParam(PreparedStatement pstmt, int paramIndex) throws SQLException {
            pstmt.setString(paramIndex, String.valueOf(this.value));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class DateConstant
    extends Constant {
        private Date value;
        private static DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        static /* synthetic */ Class class$java$util$Date;

        DateConstant(Date value) {
            this.value = value;
        }

        String toSqlString() {
            return "'" + formatter.format(this.value) + "'";
        }

        boolean isCompatible(Class withClass) {
            return withClass == (class$java$util$Date == null ? (class$java$util$Date = DateConstant.class$("java.util.Date")) : class$java$util$Date);
        }

        public void setPrepStmtParam(PreparedStatement pstmt, int paramIndex) throws SQLException {
            long time = this.value.getTime();
            pstmt.setTimestamp(paramIndex, new Timestamp(time));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class StringConstant
    extends Constant {
        private String value;
        static /* synthetic */ Class class$java$lang$String;

        StringConstant(String value) {
            this.value = value;
        }

        public String toSqlString() {
            return Constant.quote(this.value);
        }

        boolean isCompatible(Class withClass) {
            return withClass == (class$java$lang$String == null ? (class$java$lang$String = StringConstant.class$("java.lang.String")) : class$java$lang$String);
        }

        public void setPrepStmtParam(PreparedStatement pstmt, int paramIndex) throws SQLException {
            pstmt.setString(paramIndex, this.value);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class NullConstant
    extends Constant {
        private NullConstant() {
        }

        String toSqlString() {
            throw new UnsupportedOperationException("Null constant does not support this");
        }

        boolean isCompatible(Class withClass) {
            throw new UnsupportedOperationException("Null constant does not support this");
        }

        public void setPrepStmtParam(PreparedStatement pstmt, int paramIndex) throws SQLException {
            throw new UnsupportedOperationException("Null constant does not support this");
        }
    }
}

