/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence;

import com.idoox.debug.Category;
import com.systinet.persistence.ClassParser;
import com.systinet.persistence.DatabaseSchemaHelper;
import com.systinet.persistence.KeywordChecker;
import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceSqlException;
import com.systinet.persistence.query.PersistentField;
import com.systinet.persistence.query.PersistentFieldCollection;
import com.systinet.persistence.tablemodel.Column;
import com.systinet.persistence.tablemodel.Table;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.Database;
import com.systinet.uddi.database.DatabaseCoreException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TableCreator {
    private static Category log = Category.getCategory((String)"com.systinet.persistence.TableCreator");
    private List tables = null;

    public void parseClasses(Class[] classes) throws PersistenceException {
        this.tables = null;
        HashSet<Table> tblsForClases = new HashSet<Table>();
        int i = 0;
        while (i < classes.length) {
            tblsForClases.add(ClassParser.parse(classes[i]));
            ++i;
        }
        this.tables = this.orderTables(tblsForClases);
    }

    public void setTables(Table[] tables) throws PersistenceException {
        List<Table> tblsCol = Arrays.asList(tables);
        this.tables = this.orderTables(tblsCol);
    }

    private List orderTables(Collection tables) throws PersistenceException {
        this.checkDuplicateNames(tables);
        this.checkNamesInTables(tables);
        return this.findTablesOrder(tables);
    }

    private void checkDuplicateNames(Collection tables) throws PersistenceException {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Iterator tblIter = tables.iterator();
        while (tblIter.hasNext()) {
            Table curTbl = (Table)tblIter.next();
            String curTblName = curTbl.getName();
            if (names.add(curTblName)) continue;
            throw new PersistenceException("Duplicate table name '" + curTblName + "'");
        }
    }

    private void checkNamesInTables(Collection tables) throws PersistenceException {
        Iterator tblIter = tables.iterator();
        while (tblIter.hasNext()) {
            Table ctbl = (Table)tblIter.next();
            this.checkDbName(ctbl.getName());
            Iterator colIter = ctbl.columns().iterator();
            while (colIter.hasNext()) {
                Column ccol = (Column)colIter.next();
                this.checkDbName(ccol.getName());
            }
        }
    }

    private void checkDbName(String name) throws PersistenceException {
        if (KeywordChecker.isKeyword(name)) {
            throw new PersistenceException("Name '" + name + "' is reserved word is some db");
        }
    }

    private List findTablesOrder(Collection tables) throws PersistenceException {
        ArrayList<Table> order = new ArrayList<Table>(tables.size());
        HashSet<TableWrapper> graphRoots = this.createGraph(tables);
        while (!graphRoots.isEmpty()) {
            HashSet<TableWrapper> newRoots = new HashSet<TableWrapper>();
            Iterator rootIter = graphRoots.iterator();
            while (rootIter.hasNext()) {
                TableWrapper curTbl = (TableWrapper)rootIter.next();
                Iterator refsIter = curTbl.referencingTables.iterator();
                while (refsIter.hasNext()) {
                    TableWrapper curRefTable = (TableWrapper)refsIter.next();
                    curRefTable.referencedTables.removeAll(graphRoots);
                    if (!curRefTable.referencedTables.isEmpty()) continue;
                    newRoots.add(curRefTable);
                }
                order.add(curTbl.thisTable);
            }
            graphRoots = newRoots;
        }
        if (order.size() != tables.size()) {
            throw new PersistenceException("Tables contain circular references");
        }
        return order;
    }

    private Set createGraph(Collection tables) throws PersistenceException {
        TreeMap<String, TableWrapper> nameToTable = new TreeMap<String, TableWrapper>(String.CASE_INSENSITIVE_ORDER);
        Iterator tblIter = tables.iterator();
        while (tblIter.hasNext()) {
            Table curTbl = (Table)tblIter.next();
            nameToTable.put(curTbl.getName(), new TableWrapper(curTbl));
        }
        Iterator tblIter2 = nameToTable.values().iterator();
        while (tblIter2.hasNext()) {
            TableWrapper curTbl = (TableWrapper)tblIter2.next();
            List curTblCols = curTbl.thisTable.columns();
            int i = 0;
            int limit = curTblCols.size();
            while (i < limit) {
                Column curCol = (Column)curTblCols.get(i);
                if (curCol.isForeignKey()) {
                    String refTableName = curCol.foreingKeyReferences();
                    TableWrapper refTable = (TableWrapper)nameToTable.get(refTableName);
                    if (refTable == null) {
                        throw new PersistenceException(curTbl.thisTable.getName() + " references unknown table " + refTableName);
                    }
                    curTbl.referencedTables.add(refTable);
                    refTable.referencingTables.add(curTbl);
                }
                ++i;
            }
        }
        HashSet<TableWrapper> result = new HashSet<TableWrapper>(tables.size() * 4 / 3 + 1);
        Iterator tblIter3 = nameToTable.values().iterator();
        while (tblIter3.hasNext()) {
            TableWrapper curTbl = (TableWrapper)tblIter3.next();
            if (!curTbl.referencedTables.isEmpty()) continue;
            result.add(curTbl);
        }
        return result;
    }

    public void createTables(Database database) throws SQLException, PersistenceException, DatabaseCoreException {
        this.createTablesInternal(database);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set createTablesInternal(Database database) throws SQLException, PersistenceException, DatabaseCoreException {
        HashSet<String> hashSet;
        ConnectionMonitor conn;
        block10: {
            if (database == null) {
                throw new NullPointerException("'database' must not be null");
            }
            conn = null;
            Statement stmt = null;
            try {
                conn = database.getNoTxConnection();
                stmt = conn.createStatement();
                DatabaseSchemaHelper dbsh = DatabaseSchemaHelper.getInstance();
                HashSet<String> createdTables = new HashSet<String>(this.tables.size() * 4 / 3 + 1);
                int i = 0;
                int limit = this.tables.size();
                while (i < limit) {
                    Table curTable = (Table)this.tables.get(i);
                    if (!dbsh.existsTableInDb(curTable.getName(), conn)) {
                        String[] sqlCreateTableCmds = dbsh.createCreateTableCommands(curTable);
                        int j = 0;
                        while (j < sqlCreateTableCmds.length) {
                            String sqlCreateTableCmd = sqlCreateTableCmds[j];
                            log.debug(sqlCreateTableCmd);
                            try {
                                stmt.execute(sqlCreateTableCmd);
                            }
                            catch (SQLException sqle) {
                                if (!dbsh.existsTableInDb(curTable.getName(), conn)) throw sqle;
                                log.debug("Table created by another running instance.", (Throwable)sqle);
                            }
                            ++j;
                        }
                        createdTables.add(curTable.getName());
                    }
                    ++i;
                }
                if (!createdTables.isEmpty()) {
                    log.info("Tables created in database: " + createdTables);
                }
                hashSet = createdTables;
                Object var14_13 = null;
                if (conn == null) return hashSet;
                if (stmt == null) break block10;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (conn == null) throw throwable;
                if (stmt != null) {
                    conn.close(stmt);
                }
                database.releaseNoTxConnection(conn);
                throw throwable;
            }
            conn.close(stmt);
        }
        database.releaseNoTxConnection(conn);
        return hashSet;
    }

    public void createTableWithIndexes(Database database, PersistentFieldCollection[] indexes) throws SQLException, DatabaseCoreException, PersistenceException {
        int i = 0;
        while (i < indexes.length) {
            PersistentFieldCollection cindex = indexes[i];
            if (cindex == null) {
                throw new NullPointerException("some index is null");
            }
            if (cindex.isEmpty() || !cindex.fieldsFromOneClass()) {
                throw new IllegalArgumentException("some index empty or field from more classes");
            }
            ++i;
        }
        Set created = this.createTablesInternal(database);
        int i2 = 0;
        while (i2 < indexes.length) {
            PersistentFieldCollection cindex = indexes[i2];
            Class clazz = cindex.getClassOfFields();
            String tableName = ClassParser.getTableNameFor(clazz);
            if (created.contains(tableName)) {
                this.createIndex(this.createIndexName(cindex), cindex, database);
            }
            ++i2;
        }
    }

    private String createIndexName(PersistentFieldCollection index) {
        StringBuffer sb = new StringBuffer();
        sb.append("ix_");
        String tableName = ClassParser.getTableNameFor(index.getClassOfFields());
        sb.append(tableName);
        Iterator i = index.iterator();
        while (i.hasNext()) {
            PersistentField cpf = (PersistentField)i.next();
            sb.append('_');
            sb.append(cpf.name());
        }
        if (sb.length() <= 18) {
            return sb.toString();
        }
        int maxTableNameIndex = Math.min(tableName.length(), 8);
        String rs = "ix_" + tableName.substring(0, maxTableNameIndex) + Math.abs(sb.toString().hashCode());
        return rs.substring(0, 18);
    }

    private void createIndex(String indexName, PersistentFieldCollection fields, Database database) throws PersistenceException {
        block12: {
            if (indexName == null) {
                throw new NullPointerException("indexName is null");
            }
            if (indexName.length() == 0) {
                throw new IllegalArgumentException("indexName is empty");
            }
            if (fields == null) {
                throw new NullPointerException("fields must not be null");
            }
            if (fields.isEmpty()) {
                throw new IllegalArgumentException("fields is empty");
            }
            if (!fields.fieldsFromOneClass()) {
                throw new IllegalArgumentException("Must contain field from one class");
            }
            try {
                ConnectionMonitor conn;
                block13: {
                    conn = null;
                    Statement stmt = null;
                    try {
                        conn = database.getNoTxConnection();
                        stmt = conn.createStatement();
                        String tblName = ClassParser.getTableNameFor(fields.getClassOfFields());
                        String sql = "CREATE INDEX " + indexName + " ON " + tblName + "(" + fields.toSqlList() + ")";
                        log.debug(sql);
                        stmt.execute(sql);
                        Object var9_10 = null;
                        if (conn == null) break block12;
                        if (stmt == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (conn != null) {
                            if (stmt != null) {
                                conn.close(stmt);
                            }
                            database.releaseNoTxConnection(conn);
                        }
                        throw throwable;
                    }
                    conn.close(stmt);
                }
                database.releaseNoTxConnection(conn);
                {
                }
            }
            catch (DatabaseCoreException e) {
                throw new PersistenceDbCoreException(e);
            }
            catch (SQLException e) {
                throw new PersistenceSqlException(e);
            }
        }
    }

    public void dropTables(Database database) throws SQLException, DatabaseCoreException, PersistenceException {
        block10: {
            ConnectionMonitor conn;
            block11: {
                if (database == null) {
                    throw new NullPointerException("'database' must not be null");
                }
                conn = null;
                Statement stmt = null;
                try {
                    conn = database.getNoTxConnection();
                    stmt = conn.createStatement();
                    DatabaseSchemaHelper dbsh = DatabaseSchemaHelper.getInstance();
                    int i = this.tables.size() - 1;
                    while (i >= 0) {
                        Table curTable = (Table)this.tables.get(i);
                        String ctName = curTable.getName();
                        if (dbsh.existsTableInDb(ctName, conn)) {
                            String[] sqlDropTableCmds = dbsh.createDropTableCommands(curTable);
                            String sqlDropTableCmd = null;
                            try {
                                int j = 0;
                                while (j < sqlDropTableCmds.length) {
                                    sqlDropTableCmd = sqlDropTableCmds[j];
                                    log.debug(sqlDropTableCmd);
                                    stmt.execute(sqlDropTableCmd);
                                    ++j;
                                }
                            }
                            catch (SQLException sqle) {
                                log.error("Cannot drop " + ctName + ". Error while executing DDL: " + sqlDropTableCmd, (Throwable)sqle);
                            }
                        }
                        --i;
                    }
                    Object var12_12 = null;
                    if (conn == null) break block10;
                    if (stmt == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (conn != null) {
                        if (stmt != null) {
                            conn.close(stmt);
                        }
                        database.releaseNoTxConnection(conn);
                    }
                    throw throwable;
                }
                conn.close(stmt);
            }
            database.releaseNoTxConnection(conn);
            {
            }
        }
    }

    private static class TableWrapper {
        Set referencedTables;
        Set referencingTables;
        Table thisTable;

        TableWrapper(Table thisTable) {
            this.thisTable = thisTable;
            this.referencedTables = new HashSet();
            this.referencingTables = new HashSet();
        }

        public String toString() {
            return this.thisTable + " ->" + this.referencedTables;
        }
    }
}

