/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence;

import com.systinet.persistence.FieldSetterManager;
import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.tablemodel.Column;
import com.systinet.persistence.tablemodel.Table;
import com.systinet.uddi.database.AbstractManager;
import com.systinet.uddi.database.ApiManager;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.DatabaseApi;
import com.systinet.uddi.database.DatabaseConfigHelper;
import com.systinet.uddi.database.DatabaseCoreException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseSchemaHelper
extends DatabaseApi {
    private static DatabaseSchemaHelper instance = null;
    private static String[] typeTableArray = new String[]{"TABLE"};
    private static final String NL = System.getProperty("line.separator");
    private static final String INDENT = "   ";
    private volatile boolean typesRegistered = false;
    private Map javaToSqlMap = null;
    static /* synthetic */ Class class$com$systinet$persistence$tablemodel$Identity;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static final synchronized DatabaseSchemaHelper getInstance() throws PersistenceException {
        try {
            if (instance == null) {
                DatabaseSchemaHelperManager.managerInstance.init();
            }
            return instance;
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException("Get DatabaseSchemaHelper failed: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean existsTableInDb(String tableName, ConnectionMonitor cm) throws DatabaseCoreException, SQLException {
        boolean bl;
        if (tableName == null || tableName.length() == 0) {
            throw new NullPointerException("'tableName' is null or empty");
        }
        DatabaseMetaData metaData = cm.getMetaData();
        tableName = DatabaseSchemaHelper.escapeTableName(tableName, metaData.getSearchStringEscape());
        tableName = this.processSearchTableName(tableName);
        ResultSet tableRs = null;
        try {
            tableRs = cm.getMetaData().getTables(null, null, tableName, typeTableArray);
            bl = tableRs.next();
            Object var7_6 = null;
            if (tableRs == null) return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (tableRs == null) throw throwable;
            tableRs.close();
            throw throwable;
        }
        tableRs.close();
        return bl;
    }

    protected String processSearchTableName(String originalName) {
        return originalName;
    }

    public static String escapeTableName(String name, String metacharEscape) {
        int nameLen = name.length();
        StringBuffer sb = new StringBuffer(nameLen * 2);
        int i = 0;
        while (i < nameLen) {
            char ch = name.charAt(i);
            if (ch == '_' || ch == '%') {
                sb.append(metacharEscape);
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    protected String createCreateTableCommand(Table table) {
        if (table == null) {
            throw new NullPointerException("Param 'table' must not be null");
        }
        boolean composedPK = table.hasComposedPrimaryKey();
        StringBuffer b = new StringBuffer();
        b.append(this.getCreateTableStr());
        b.append(' ');
        b.append(table.getName());
        b.append(" (" + NL);
        List columns = table.columns();
        int i = 0;
        int limit = columns.size();
        while (i < limit) {
            Column curCol = (Column)columns.get(i);
            b.append(INDENT);
            b.append(this.createColumnExpression(curCol, composedPK));
            if (i < limit - 1) {
                b.append(",");
            }
            b.append(NL);
            ++i;
        }
        b.append(this.getConstraintInsertions(table));
        b.append(')');
        String insertAfter = this.getInsertAfterCreateTable();
        if (insertAfter != null && insertAfter.length() > 0) {
            b.append(' ');
            b.append(insertAfter);
        }
        b.append(NL);
        return b.toString();
    }

    protected String[] createCreateTableCommands(Table table) {
        return new String[]{this.createCreateTableCommand(table)};
    }

    protected String getConstraintInsertions(Table table) {
        if (table.hasComposedPrimaryKey()) {
            StringBuffer sb = new StringBuffer();
            sb.append(", PRIMARY KEY (");
            List pk = table.getPrimaryKey();
            int i = 0;
            int limit = pk.size();
            while (i < limit) {
                Column cPkCol = (Column)pk.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(cPkCol.getName());
                ++i;
            }
            sb.append(')');
            return sb.toString();
        }
        return "";
    }

    protected String getCreateTableStr() {
        return "CREATE TABLE";
    }

    protected String getInsertAfterCreateTable() {
        return "";
    }

    protected String createColumnExpression(Column column, boolean composedPrimaryKey) {
        String fkConstraint;
        StringBuffer b = new StringBuffer();
        b.append(column.getName());
        b.append(" ");
        b.append(this.getSqlTypeStr(column.getJavaType()));
        if (column.isPrimaryKey()) {
            if (composedPrimaryKey) {
                b.append(" NOT NULL ");
            } else if (column.getJavaType().equals(class$com$systinet$persistence$tablemodel$Identity == null ? (class$com$systinet$persistence$tablemodel$Identity = DatabaseSchemaHelper.class$("com.systinet.persistence.tablemodel.Identity")) : class$com$systinet$persistence$tablemodel$Identity)) {
                b.append(" PRIMARY KEY ");
            } else {
                b.append(" NOT NULL PRIMARY KEY ");
            }
        }
        if (column.isForeignKey() && (fkConstraint = this.createForeingKeyConstaint(column)) != null) {
            b.append(fkConstraint);
        }
        return b.toString();
    }

    protected String createForeingKeyConstaint(Column column) {
        return " REFERENCES " + column.foreingKeyReferences();
    }

    protected String createDropTableCommand(String tableName) {
        if (tableName == null || tableName.length() == 0) {
            throw new NullPointerException("'tableName' is null or empty");
        }
        return "DROP TABLE " + tableName;
    }

    protected String[] createDropTableCommands(Table table) {
        return new String[]{this.createDropTableCommand(table.getName())};
    }

    final String getSqlTypeStr(Class javaType) {
        String sqlType;
        if (!this.typesRegistered) {
            this.registerTypes();
        }
        return (sqlType = (String)this.javaToSqlMap.get(javaType)) == null ? this.getSqlForOtherTypes() : sqlType;
    }

    private synchronized void registerTypes() {
        if (this.typesRegistered) {
            return;
        }
        this.javaToSqlMap = new HashMap();
        this.registerPrimitiveTypes();
        this.registerTypeMapping(class$java$lang$String == null ? (class$java$lang$String = DatabaseSchemaHelper.class$("java.lang.String")) : class$java$lang$String, "VARCHAR(" + this.getUsedStringLength() + ")");
        this.registerTypeMapping(class$java$util$Date == null ? (class$java$util$Date = DatabaseSchemaHelper.class$("java.util.Date")) : class$java$util$Date, "TIMESTAMP");
        this.registerNonPrimitiveTypes();
        this.typesRegistered = true;
    }

    private void registerPrimitiveTypes() {
        String forChar = this.getSqlForChar();
        this.registerTypeMapping(class$java$lang$Character == null ? (class$java$lang$Character = DatabaseSchemaHelper.class$("java.lang.Character")) : class$java$lang$Character, forChar);
        this.registerTypeMapping(Character.TYPE, forChar);
        String forBoolean = this.getSqlForBoolean();
        this.registerTypeMapping(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DatabaseSchemaHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean, forBoolean);
        this.registerTypeMapping(Boolean.TYPE, forBoolean);
        String forByte = this.getSqlForByte();
        this.registerTypeMapping(class$java$lang$Byte == null ? (class$java$lang$Byte = DatabaseSchemaHelper.class$("java.lang.Byte")) : class$java$lang$Byte, forByte);
        this.registerTypeMapping(Byte.TYPE, forByte);
        String forShort = this.getSqlForShort();
        this.registerTypeMapping(class$java$lang$Short == null ? (class$java$lang$Short = DatabaseSchemaHelper.class$("java.lang.Short")) : class$java$lang$Short, forShort);
        this.registerTypeMapping(Short.TYPE, forShort);
        String forInt = this.getSqlForInt();
        this.registerTypeMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = DatabaseSchemaHelper.class$("java.lang.Integer")) : class$java$lang$Integer, forInt);
        this.registerTypeMapping(Integer.TYPE, forInt);
        String forLong = this.getSqlForLong();
        this.registerTypeMapping(class$java$lang$Long == null ? (class$java$lang$Long = DatabaseSchemaHelper.class$("java.lang.Long")) : class$java$lang$Long, forLong);
        this.registerTypeMapping(Long.TYPE, forLong);
        String forFloat = this.getSqlForFloat();
        this.registerTypeMapping(class$java$lang$Float == null ? (class$java$lang$Float = DatabaseSchemaHelper.class$("java.lang.Float")) : class$java$lang$Float, forFloat);
        this.registerTypeMapping(Float.TYPE, forFloat);
        String forDouble = this.getSqlForDouble();
        this.registerTypeMapping(class$java$lang$Double == null ? (class$java$lang$Double = DatabaseSchemaHelper.class$("java.lang.Double")) : class$java$lang$Double, forDouble);
        this.registerTypeMapping(Double.TYPE, forDouble);
    }

    protected String getSqlForChar() {
        return "CHAR(1)";
    }

    protected String getSqlForBoolean() {
        return "BIT";
    }

    protected String getSqlForByte() {
        return "TINYINT";
    }

    protected String getSqlForShort() {
        return "SMALLINT";
    }

    protected String getSqlForInt() {
        return "INTEGER";
    }

    protected String getSqlForLong() {
        return "BIGINT";
    }

    protected String getSqlForFloat() {
        return "REAL";
    }

    protected String getSqlForDouble() {
        return "DOUBLE";
    }

    protected int getUsedStringLength() {
        return 512;
    }

    protected void registerNonPrimitiveTypes() {
    }

    protected final void registerTypeMapping(Class javaType, String sqlType) {
        this.javaToSqlMap.put(javaType, sqlType);
    }

    protected String getSqlForOtherTypes() {
        return "BLOB";
    }

    protected FieldSetterManager.FieldSetter getDefaultSetter() {
        return FieldSetterManager.BLOB_FIELD_SETTER;
    }

    protected FieldSetterManager.FieldSetter getDefaultSetter(ClassLoader loader) {
        return new FieldSetterManager.BinaryFieldSetterWithLoader(loader);
    }

    protected FieldSetterManager.FieldSetter findSetter(Class javaType, Integer sqlType) {
        return FieldSetterManager.DEFAULT_FIELD_SETTER_MANAGER.findSetter(javaType, sqlType);
    }

    protected boolean supportsSelectForUpdate() {
        return true;
    }

    protected boolean supportMsSqlHintForUpdate() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DatabaseSchemaHelperManager
    implements AbstractManager {
        static DatabaseSchemaHelperManager managerInstance = new DatabaseSchemaHelperManager();
        private boolean registered = false;
        static /* synthetic */ Class class$com$systinet$persistence$DatabaseSchemaHelper;

        private DatabaseSchemaHelperManager() {
        }

        public void init() throws DatabaseCoreException {
            Class clazz = class$com$systinet$persistence$DatabaseSchemaHelper == null ? (class$com$systinet$persistence$DatabaseSchemaHelper = DatabaseSchemaHelperManager.class$("com.systinet.persistence.DatabaseSchemaHelper")) : class$com$systinet$persistence$DatabaseSchemaHelper;
            synchronized (clazz) {
                ApiManager apiManager = ApiManager.getApiManager();
                DatabaseConfigHelper databaseConfigHelper = apiManager.getDatabaseConfigHelper();
                if (!this.registered) {
                    databaseConfigHelper.register(this);
                    this.registered = true;
                }
                instance = (DatabaseSchemaHelper)ApiManager.getApiManager().getDatabaseDependantInstance((DatabaseSchemaHelperManager.class$com$systinet$persistence$DatabaseSchemaHelper == null ? (DatabaseSchemaHelperManager.class$com$systinet$persistence$DatabaseSchemaHelper = DatabaseSchemaHelperManager.class$("com.systinet.persistence.DatabaseSchemaHelper")) : DatabaseSchemaHelperManager.class$com$systinet$persistence$DatabaseSchemaHelper).getName());
                if (instance == null) {
                    instance = new DatabaseSchemaHelper();
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

