/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database.hsql;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ConfigurableDriver;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.systinet.wasp.Wasp;

public class Driver
extends ConfigurableDriver {
    private static final String jdbcDriverClassName = "org.hsqldb.jdbcDriver";
    private static final String jdbcDriverName = "jdbc:hsqldb";
    private static Object jdbcDriver = null;
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.hsql.Driver");
    private static final String HSQL_DATABASE_FILE_PROPERTY = "hsql.database.file";
    public static final String REMOTE_HSQL_URL_START = "hsql://";
    private static final String HSQL_DUMMY_QUERY = "CALL 1";

    public synchronized void init(String hostName, int port, String initDbName, String user, String password) throws DatabaseCoreException {
        String instanceName;
        Map initArgs;
        super.init(hostName, port, initDbName, user, password);
        try {
            if (jdbcDriver == null) {
                jdbcDriver = Class.forName(jdbcDriverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseCoreException(12001, DatabaseCoreBundle.getString("ERROR_12001_JdbcDriverNotFound_P2", new String[]{"Hsql", jdbcDriverClassName}), e);
        }
        String propertyDbFile = System.getProperty(HSQL_DATABASE_FILE_PROPERTY);
        if (propertyDbFile != null) {
            this.dbName = propertyDbFile;
        } else if (!this.dbName.startsWith(REMOTE_HSQL_URL_START) && (initArgs = Wasp.getInitialArguments()) != null && (instanceName = (String)initArgs.get("wasp.instance.name")) != null) {
            this.dbName = this.dbName + '-' + instanceName;
        }
        if (!this.dbName.startsWith(REMOTE_HSQL_URL_START)) {
            File dbFile = new File(this.dbName);
            if (!dbFile.isAbsolute()) {
                String waspLocation = Wasp.getWaspLocation();
                if (waspLocation == null) {
                    waspLocation = System.getProperty("wasp.location");
                }
                if (waspLocation != null) {
                    if (waspLocation.startsWith("file:")) {
                        waspLocation = waspLocation.substring("file:".length());
                    }
                    this.dbName = waspLocation + File.separatorChar + this.dbName;
                }
            }
            log.debug("Using HSQL database: " + this.dbName);
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        String connectionAddress = "jdbc:hsqldb:" + this.dbName;
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", this.user);
        if (this.password != null) {
            ((Hashtable)properties).put("password", this.password);
        }
        ((Hashtable)properties).put("charSet", "UTF8");
        Connection conn = DriverManager.getConnection(connectionAddress, properties);
        return conn;
    }

    public String getDummyQuery() {
        return HSQL_DUMMY_QUERY;
    }
}

