/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence;

import com.systinet.persistence.RetryPolicy;

public final class RetryPolicyFactory {
    private static RetryPolicy NO_RETRY = new NoRetryPolicy();
    private static final RetryPolicy DEFAULT_POLICY = new TimeoutListRetryPolicy(3, new long[]{0L, 1000L});

    private RetryPolicyFactory() {
    }

    public static RetryPolicy getNoRetryPolicy() {
        return NO_RETRY;
    }

    public static RetryPolicy getConstantTimeoutPolicy(int maxAttempts, long timeout) {
        return new ConstantTimeoutRetryPolicy(maxAttempts, timeout);
    }

    public static RetryPolicy getTimeoutListPolicy(int maxAttempts, long[] timeouts) {
        return new TimeoutListRetryPolicy(maxAttempts, timeouts);
    }

    public static RetryPolicy getDefaultPolicy() {
        return DEFAULT_POLICY;
    }

    private static class TimeoutListRetryPolicy
    implements RetryPolicy {
        private int maxAttempts;
        private long[] timeouts;

        TimeoutListRetryPolicy(int maxAttempts, long[] timeouts) {
            if (timeouts == null) {
                throw new NullPointerException("timeouts must not be null");
            }
            if (timeouts.length == 0) {
                throw new IllegalArgumentException("List of timeouts is empty");
            }
            this.maxAttempts = maxAttempts;
            this.timeouts = timeouts;
            if (timeouts.length >= maxAttempts) {
                throw new IllegalArgumentException("Too many timeouts specified");
            }
            int i = 0;
            while (i < timeouts.length) {
                if (timeouts[i] < 0L) {
                    throw new IllegalArgumentException("Some timeout < 0");
                }
                ++i;
            }
        }

        public long getRetryTimeout(int failureNumber, Exception unused) {
            if (failureNumber < 1) {
                throw new IllegalArgumentException("failureNumber is < 1");
            }
            if (failureNumber >= this.maxAttempts) {
                return -1L;
            }
            if (failureNumber < this.timeouts.length) {
                return this.timeouts[failureNumber - 1];
            }
            return this.timeouts[this.timeouts.length - 1];
        }
    }

    private static class ConstantTimeoutRetryPolicy
    implements RetryPolicy {
        private long timeOut;
        private int maxAttempts;

        ConstantTimeoutRetryPolicy(int maxAttempts, long timeOut) {
            this.timeOut = timeOut;
            this.maxAttempts = maxAttempts;
        }

        public long getRetryTimeout(int failureNumber, Exception unused) {
            if (failureNumber < 1) {
                throw new IllegalArgumentException("failureNumber is < 1");
            }
            if (failureNumber < this.maxAttempts) {
                return this.timeOut;
            }
            return -1L;
        }
    }

    private static class NoRetryPolicy
    implements RetryPolicy {
        private NoRetryPolicy() {
        }

        public long getRetryTimeout(int failureNumber, Exception unused) {
            return -1L;
        }
    }
}

