/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.config.ConfigHelper;
import com.systinet.uddi.config.ConfigReloadEvent;
import com.systinet.uddi.config.ConfigurationException;
import com.systinet.uddi.database.AbstractManager;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.config.DatabaseConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.idoox.config.Configurable;
import org.idoox.config.IConfigurator;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventListener;
import org.systinet.monitoring.EventManager;

public class DatabaseConfigHelper {
    private Map backendNameMap;
    private Map databaseDependantBackendMap;
    private String dbtype;
    private DatabaseConfig.Database db;
    private Vector listeners = new Vector();
    private String configName;
    private Configurable configurable;
    private static Map instances = new HashMap();
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.DatabaseConfigHelper");
    static /* synthetic */ Class class$com$systinet$uddi$database$config$DatabaseConfig;
    static /* synthetic */ Class class$com$systinet$uddi$database$config$DatabaseConfig$DatabaseMappings;
    static /* synthetic */ Class class$com$systinet$uddi$database$config$DatabaseConfig$BackendMapping;

    public static synchronized DatabaseConfigHelper getInstance(Configurable configurable) throws DatabaseCoreException {
        String configName = configurable.getName();
        DatabaseConfigHelper instance = (DatabaseConfigHelper)instances.get(configName);
        if (instance == null) {
            instance = new DatabaseConfigHelper(configurable);
            instances.put(configName, instance);
        }
        return instance;
    }

    private DatabaseConfigHelper(Configurable configurable) throws DatabaseCoreException {
        this.configName = configurable.getName();
        this.loadConfiguration(configurable);
        DatabaseEventListener listener = new DatabaseEventListener();
        EventManager.addListener((String)"CFGCHANGE", (EventListener)listener);
    }

    private synchronized void loadConfiguration(Configurable configurable) throws DatabaseCoreException {
        this.backendNameMap = new HashMap();
        this.configurable = configurable;
        DatabaseConfig config = (DatabaseConfig)configurable.narrow(class$com$systinet$uddi$database$config$DatabaseConfig == null ? (class$com$systinet$uddi$database$config$DatabaseConfig = DatabaseConfigHelper.class$("com.systinet.uddi.database.config.DatabaseConfig")) : class$com$systinet$uddi$database$config$DatabaseConfig);
        if (config == null) {
            throw new DatabaseCoreException(12041, DatabaseCoreBundle.getString("ERROR_12041_NoConfiguration"));
        }
        this.db = config.getDatabase();
        if (this.db == null) {
            throw new DatabaseCoreException(12042, DatabaseCoreBundle.getString("ERROR_12042_MissingElement_P1", "database"));
        }
        if (this.db.getDriverProperty() == null) {
            throw new DatabaseCoreException(12042, DatabaseCoreBundle.getString("ERROR_12042_MissingElement_P1", "database/driverProperty"));
        }
        this.dbtype = this.db.getDriverProperty().getType();
        if (this.dbtype == null) {
            throw new DatabaseCoreException(12042, DatabaseCoreBundle.getString("ERROR_12042_MissingElement_P1", "database/driverProperty/type"));
        }
        IConfigurator[] configurators = new IConfigurator[]{};
        try {
            configurators = ConfigHelper.getConfigurators();
        }
        catch (ConfigurationException e) {
            log.error("ConfigurationException:", (Throwable)((Object)e));
            throw new DatabaseCoreException(e.getErrorCode(), e.getMessage());
        }
        int c = 0;
        while (c < configurators.length) {
            Configurable[] backendMappings = configurators[c].getTopEntries("backendMapping");
            int i = 0;
            while (i < backendMappings.length) {
                this.addBackendMapping(backendMappings[i]);
                ++i;
            }
            ++c;
        }
        HashMap dbProfiles = new HashMap();
        int c2 = 0;
        while (c2 < configurators.length) {
            Configurable[] databaseMappings = configurators[c2].getTopEntries("databaseMappings");
            int i = 0;
            while (i < databaseMappings.length) {
                this.addDatabaseMappings(databaseMappings[i], dbProfiles);
                ++i;
            }
            ++c2;
        }
        this.databaseDependantBackendMap = (Map)dbProfiles.get(this.dbtype);
        if (this.databaseDependantBackendMap == null) {
            this.databaseDependantBackendMap = new HashMap();
        }
    }

    private void addDatabaseMappings(Configurable databaseMappingsConfig, Map dbProfiles) throws DatabaseCoreException {
        DatabaseConfig.DatabaseMappings dbmappings = (DatabaseConfig.DatabaseMappings)databaseMappingsConfig.narrow(class$com$systinet$uddi$database$config$DatabaseConfig$DatabaseMappings == null ? (class$com$systinet$uddi$database$config$DatabaseConfig$DatabaseMappings = DatabaseConfigHelper.class$("com.systinet.uddi.database.config.DatabaseConfig$DatabaseMappings")) : class$com$systinet$uddi$database$config$DatabaseConfig$DatabaseMappings);
        if (dbmappings == null) {
            throw new DatabaseCoreException(12042, DatabaseCoreBundle.getString("ERROR_12042_MissingElement_P1", "databaseMappings"));
        }
        DatabaseConfig.DatabaseMapping[] mappingArray = dbmappings.getDatabaseMapping();
        if (mappingArray == null) {
            throw new DatabaseCoreException(12042, DatabaseCoreBundle.getString("ERROR_12042_MissingElement_P1", "databaseMappings/databaseMapping"));
        }
        int i = 0;
        while (i < mappingArray.length) {
            this.addDatabaseMapping(mappingArray[i], dbProfiles);
            ++i;
        }
    }

    private void addDatabaseMapping(DatabaseConfig.DatabaseMapping databaseMapping, Map dbProfiles) throws DatabaseCoreException {
        String type = databaseMapping.getType();
        if (type == null) {
            throw new DatabaseCoreException(12042, DatabaseCoreBundle.getString("ERROR_12042_MissingElement_P1", "databaseMappings/databaseMapping/@type"));
        }
        HashMap<String, String> dbProfile = (HashMap<String, String>)dbProfiles.get(type);
        if (dbProfile == null) {
            dbProfile = new HashMap<String, String>();
            dbProfiles.put(type, dbProfile);
        }
        DatabaseConfig.InterfaceMapping[] mappings = databaseMapping.getInterfaceMapping();
        int i = 0;
        while (mappings != null && i < mappings.length) {
            String previousObject = dbProfile.put(mappings[i].getInterfaceName(), mappings[i].getClassName());
            if (previousObject != null) {
                log.warn(DatabaseCoreBundle.getString("WARN_MappingAlreadyExists_P2", new String[]{mappings[i].getInterfaceName(), type}));
            }
            ++i;
        }
    }

    private void addBackendMapping(Configurable backendMappingConfig) throws DatabaseCoreException {
        DatabaseConfig.BackendMapping backendMappings = (DatabaseConfig.BackendMapping)backendMappingConfig.narrow(class$com$systinet$uddi$database$config$DatabaseConfig$BackendMapping == null ? (class$com$systinet$uddi$database$config$DatabaseConfig$BackendMapping = DatabaseConfigHelper.class$("com.systinet.uddi.database.config.DatabaseConfig$BackendMapping")) : class$com$systinet$uddi$database$config$DatabaseConfig$BackendMapping);
        if (backendMappings == null) {
            throw new DatabaseCoreException(12041, DatabaseCoreBundle.getString("ERROR_12041_NoConfiguration"));
        }
        DatabaseConfig.InterfaceMapping[] mappings = backendMappings.getInterfaceMapping();
        if (mappings != null) {
            int i = 0;
            while (i < mappings.length) {
                String previousMapping = this.backendNameMap.put(mappings[i].getInterfaceName(), mappings[i].getClassName());
                if (previousMapping != null) {
                    log.warn(DatabaseCoreBundle.getString("WARN_MappingAlreadyExists_P1", mappings[i].getInterfaceName()));
                }
                ++i;
            }
        }
    }

    public String getBackendName(String interfaceClassName) {
        return (String)this.backendNameMap.get(interfaceClassName);
    }

    public String getDatabaseDependantBackendMap(String interfaceClassName) {
        return (String)this.databaseDependantBackendMap.get(interfaceClassName);
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public DatabaseConfig.Database getDatabase() {
        return this.db;
    }

    public Configurable getConfigurable() {
        return this.configurable;
    }

    public synchronized void register(AbstractManager abstractManager) {
        this.listeners.add(abstractManager);
    }

    private synchronized void fireConfigChanged() throws DatabaseCoreException {
        int i = 0;
        while (i < this.listeners.size()) {
            ((AbstractManager)this.listeners.get(i)).init();
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DatabaseEventListener
    implements EventListener {
        public void handle(Event event) {
            try {
                if (event.getType().equals("CFGCHANGE") && ((ConfigReloadEvent)event).isConfigReloaded(DatabaseConfigHelper.this.configName)) {
                    Configurable configurable = ConfigHelper.getConfigurable(DatabaseConfigHelper.this.configName);
                    DatabaseConfigHelper.this.loadConfiguration(configurable);
                    DatabaseConfigHelper.this.fireConfigChanged();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }

        public void init(Object o) {
        }

        public void destroy() {
        }
    }
}

