/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.config.ConfigHelper;
import com.systinet.uddi.config.ConfigurationException;
import com.systinet.uddi.database.AbstractManager;
import com.systinet.uddi.database.Database;
import com.systinet.uddi.database.DatabaseApi;
import com.systinet.uddi.database.DatabaseConfigHelper;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import java.util.HashMap;
import java.util.Map;
import org.idoox.config.Configurable;

public class ApiManager {
    private static Map apiManagers = new HashMap();
    private static String defaultConfigName = null;
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.ApiManager");
    private Database database;
    private DatabaseConfigHelper databaseConfigHelper;
    private Map databaseApiMap = new HashMap();
    private boolean initialized = false;
    private int errorCode;
    private String errorMessage;

    public static synchronized boolean anyApiManagerUsed() {
        return !apiManagers.isEmpty();
    }

    public static ApiManager getApiManager() throws DatabaseCoreException {
        if (defaultConfigName == null) {
            defaultConfigName = "database";
        }
        return ApiManager.getApiManager(defaultConfigName);
    }

    public static synchronized ApiManager getApiManager(String configName) throws DatabaseCoreException {
        ApiManager instance;
        if (defaultConfigName == null) {
            defaultConfigName = configName;
        }
        if ((instance = (ApiManager)apiManagers.get(configName)) == null) {
            instance = new ApiManager(configName);
            apiManagers.put(configName, instance);
        }
        return instance;
    }

    public static synchronized void setConfigName(String configName) {
        defaultConfigName = configName;
    }

    private ApiManager(String configName) throws DatabaseCoreException {
        this.database = new Database(this);
        try {
            Configurable configurable = ConfigHelper.getConfigurable(configName);
            this.databaseConfigHelper = DatabaseConfigHelper.getInstance(configurable);
        }
        catch (ConfigurationException e) {
            this.errorCode = e.getErrorCode();
            this.errorMessage = e.getMessage();
            DatabaseCoreException dce = new DatabaseCoreException(this.errorCode, this.errorMessage + " Check loading of the database configuration (database.xml) and its content.", (Throwable)((Object)e));
            log.error("db_core: ", (Throwable)((Object)dce));
            throw dce;
        }
        try {
            this.database.init();
        }
        catch (DatabaseCoreException e) {
            log.warn("Can not connect database", (Throwable)((Object)e));
        }
        this.initialized = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized DatabaseApi getApiInstance(String interfaceClassName) throws DatabaseCoreException {
        DatabaseApi databaseApi;
        if (!this.initialized) {
            throw new DatabaseCoreException(this.errorCode, this.errorMessage);
        }
        String implClassName = this.databaseConfigHelper.getBackendName(interfaceClassName);
        if (implClassName == null) {
            implClassName = interfaceClassName;
        }
        if ((databaseApi = (DatabaseApi)this.databaseApiMap.get(implClassName)) == null) {
            log.debug("New instance of " + interfaceClassName + " : " + implClassName);
            try {
                databaseApi = (DatabaseApi)Class.forName(implClassName).newInstance();
                this.databaseApiMap.put(implClassName, databaseApi);
                databaseApi.init(this);
                if (!(databaseApi instanceof AbstractManager)) return databaseApi;
                this.databaseConfigHelper.register((AbstractManager)((Object)databaseApi));
                ((AbstractManager)((Object)databaseApi)).init();
                return databaseApi;
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseCoreException(12051, DatabaseCoreBundle.getString("ERROR_12051_ComponentNotFound_P1", implClassName), e);
            }
            catch (InstantiationException e) {
                throw new DatabaseCoreException(12052, DatabaseCoreBundle.getString("ERROR_12052_ComponentInstantiation_P1", implClassName), e);
            }
            catch (IllegalAccessException e) {
                throw new DatabaseCoreException(12053, DatabaseCoreBundle.getString("ERROR_12053_ComponentIllegalAccess_P1", implClassName), e);
            }
        } else {
            log.debug("Instance of " + implClassName + " already exists.");
        }
        return databaseApi;
    }

    public DatabaseApi getDatabaseDependantInstance(String interfaceClassName) throws DatabaseCoreException {
        if (!this.initialized) {
            throw new DatabaseCoreException(this.errorCode, this.errorMessage);
        }
        String implClassName = this.databaseConfigHelper.getDatabaseDependantBackendMap(interfaceClassName);
        if (implClassName == null) {
            implClassName = interfaceClassName;
        }
        try {
            DatabaseApi databaseApi = (DatabaseApi)Class.forName(implClassName).newInstance();
            databaseApi.init(this);
            return databaseApi;
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseCoreException(12051, DatabaseCoreBundle.getString("ERROR_12051_ComponentNotFound_P1", implClassName), e);
        }
        catch (InstantiationException e) {
            throw new DatabaseCoreException(12052, DatabaseCoreBundle.getString("ERROR_12052_ComponentInstantiation_P1", implClassName), e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseCoreException(12053, DatabaseCoreBundle.getString("ERROR_12053_ComponentIllegalAccess_P1", implClassName), e);
        }
    }

    public DatabaseConfigHelper getDatabaseConfigHelper() throws DatabaseCoreException {
        return this.databaseConfigHelper;
    }

    public Database getDatabase() {
        return this.database;
    }
}

