/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dexer;

import com.android.dex.Dex;
import com.android.dex.DexException;
import com.android.dex.util.FileUtils;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.direct.ClassPathOpener;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.command.DxConsole;
import com.android.dx.command.UsageException;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.cf.CodeStatistics;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.DexMerger;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Main {
    private static final String DEX_EXTENSION = ".dex";
    private static final String DEX_PREFIX = "classes";
    private static final String IN_RE_CORE_CLASSES = "Ill-advised or mistaken usage of a core class (java.* or javax.*)\nwhen not building a core library.\n\nThis is often due to inadvertently including a core library file\nin your application's project, when using an IDE (such as\nEclipse). If you are sure you're not intentionally defining a\ncore class, then this is the most likely explanation of what's\ngoing on.\n\nHowever, you might actually be trying to define a class in a core\nnamespace, the source of which you may have taken, for example,\nfrom a non-Android virtual machine project. This will most\nassuredly not work. At a minimum, it jeopardizes the\ncompatibility of your app with future versions of the platform.\nIt is also often of questionable legality.\n\nIf you really intend to build a core library -- which is only\nappropriate as part of creating a full virtual machine\ndistribution, as opposed to compiling an application -- then use\nthe \"--core-library\" option to suppress this error message.\n\nIf you go ahead and use \"--core-library\" but are in fact\nbuilding an application, then be forewarned that your application\nwill still fail to build or run, at some point. Please be\nprepared for angry customers who find, for example, that your\napplication ceases to function once they upgrade their operating\nsystem. You will be to blame for this problem.\n\nIf you are legitimately using some code that happens to be in a\ncore package, then the easiest safe alternative you have is to\nrepackage that code. That is, move the classes in question into\nyour own package namespace. This means that they will never be in\nconflict with core system classes. JarJar is a tool that may help\nyou in this endeavor. If you find that you cannot do this, then\nthat is an indication that the path you are on will ultimately\nlead to pain, suffering, grief, and lamentation.\n";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String[] JAVAX_CORE = new String[]{"accessibility", "crypto", "imageio", "management", "naming", "net", "print", "rmi", "security", "sip", "sound", "sql", "swing", "transaction", "xml"};
    private static int errors = 0;
    private static Arguments args;
    private static DexFile outputDex;
    private static TreeMap<String, byte[]> outputResources;
    private static final List<byte[]> libraryDexBuffers;
    private static ExecutorService threadPool;
    private static boolean anyFilesProcessed;
    private static long minimumFileAge;
    private static Set<String> classesInMainDex;
    private static List<byte[]> dexOutputArrays;
    private static OutputStreamWriter humanOutWriter;

    private Main() {
    }

    public static void main(String[] argArray) throws IOException {
        Arguments arguments = new Arguments();
        arguments.parse(argArray);
        int result = Main.run(arguments);
        if (result != 0) {
            System.exit(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(Arguments arguments) throws IOException {
        errors = 0;
        libraryDexBuffers.clear();
        args = arguments;
        Main.args.makeOptionsObjects();
        OutputStream humanOutRaw = null;
        if (Main.args.humanOutName != null) {
            humanOutRaw = Main.openOutput(Main.args.humanOutName);
            humanOutWriter = new OutputStreamWriter(humanOutRaw);
        }
        try {
            if (Main.args.multiDex) {
                int n = Main.runMultiDex();
                return n;
            }
            int n = Main.runMonoDex();
            return n;
        }
        finally {
            Main.closeOutput(humanOutRaw);
        }
    }

    public static String getTooManyIdsErrorMessage() {
        if (Main.args.multiDex) {
            return "The list of classes given in --main-dex-list is too big and does not fit in the main dex.";
        }
        return "You may try using --multi-dex option.";
    }

    private static int runMonoDex() throws IOException {
        File incrementalOutFile = null;
        if (Main.args.incremental) {
            if (Main.args.outName == null) {
                System.err.println("error: no incremental output name specified");
                return -1;
            }
            incrementalOutFile = new File(Main.args.outName);
            if (incrementalOutFile.exists()) {
                minimumFileAge = incrementalOutFile.lastModified();
            }
        }
        if (!Main.processAllFiles()) {
            return 1;
        }
        if (Main.args.incremental && !anyFilesProcessed) {
            return 0;
        }
        byte[] outArray = null;
        if (!outputDex.isEmpty() && (outArray = Main.writeDex()) == null) {
            return 2;
        }
        if (Main.args.incremental) {
            outArray = Main.mergeIncremental(outArray, incrementalOutFile);
        }
        outArray = Main.mergeLibraryDexBuffers(outArray);
        if (Main.args.jarOutput) {
            outputDex = null;
            if (outArray != null) {
                outputResources.put("classes.dex", outArray);
            }
            if (!Main.createJar(Main.args.outName)) {
                return 3;
            }
        } else if (outArray != null && Main.args.outName != null) {
            OutputStream out = Main.openOutput(Main.args.outName);
            out.write(outArray);
            Main.closeOutput(out);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runMultiDex() throws IOException {
        assert (!Main.args.incremental);
        assert (Main.args.numThreads == 1);
        if (Main.args.mainDexListFile != null) {
            classesInMainDex = Main.loadMainDexListFile(Main.args.mainDexListFile);
        }
        if (!Main.processAllFiles()) {
            return 1;
        }
        if (!libraryDexBuffers.isEmpty()) {
            throw new DexException("Library dex files are not supported in multi-dex mode");
        }
        if (outputDex != null) {
            dexOutputArrays.add(Main.writeDex());
            outputDex = null;
        }
        if (Main.args.jarOutput) {
            for (int i = 0; i < dexOutputArrays.size(); ++i) {
                outputResources.put(Main.getDexFileName(i), dexOutputArrays.get(i));
            }
            if (!Main.createJar(Main.args.outName)) {
                return 3;
            }
        } else if (Main.args.outName != null) {
            File outDir = new File(Main.args.outName);
            assert (outDir.isDirectory());
            for (int i = 0; i < dexOutputArrays.size(); ++i) {
                FileOutputStream out = new FileOutputStream(new File(outDir, Main.getDexFileName(i)));
                try {
                    ((OutputStream)out).write(dexOutputArrays.get(i));
                    continue;
                }
                finally {
                    Main.closeOutput(out);
                }
            }
        }
        return 0;
    }

    private static String getDexFileName(int i) {
        if (i == 0) {
            return "classes.dex";
        }
        return DEX_PREFIX + (i + 1) + DEX_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> loadMainDexListFile(String mainDexListFile) throws IOException {
        HashSet<String> mainDexList = new HashSet<String>();
        BufferedReader bfr = null;
        try {
            String line;
            FileReader fr = new FileReader(mainDexListFile);
            bfr = new BufferedReader(fr);
            while (null != (line = bfr.readLine())) {
                mainDexList.add(Main.fixPath(line));
            }
        }
        finally {
            if (bfr != null) {
                bfr.close();
            }
        }
        return mainDexList;
    }

    private static byte[] mergeIncremental(byte[] update2, File base) throws IOException {
        Dex dexA = null;
        Dex dexB = null;
        if (update2 != null) {
            dexA = new Dex(update2);
        }
        if (base.exists()) {
            dexB = new Dex(base);
        }
        if (dexA == null && dexB == null) {
            return null;
        }
        Dex result = dexA == null ? dexB : (dexB == null ? dexA : new DexMerger(dexA, dexB, CollisionPolicy.KEEP_FIRST).merge());
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        result.writeTo(bytesOut);
        return bytesOut.toByteArray();
    }

    private static byte[] mergeLibraryDexBuffers(byte[] outArray) throws IOException {
        for (byte[] libraryDex : libraryDexBuffers) {
            if (outArray == null) {
                outArray = libraryDex;
                continue;
            }
            Dex a = new Dex(outArray);
            Dex b = new Dex(libraryDex);
            Dex ab = new DexMerger(a, b, CollisionPolicy.FAIL).merge();
            outArray = ab.getBytes();
        }
        return outArray;
    }

    private static boolean processAllFiles() {
        Main.createDexFile();
        if (Main.args.jarOutput) {
            outputResources = new TreeMap();
        }
        anyFilesProcessed = false;
        String[] fileNames = Main.args.fileNames;
        if (Main.args.numThreads > 1) {
            threadPool = Executors.newFixedThreadPool(Main.args.numThreads);
        }
        try {
            if (Main.args.mainDexListFile != null) {
                int i;
                ClassPathOpener.FileNameFilter mainPassFilter = Main.args.strictNameCheck ? new MainDexListFilter() : new BestEffortMainDexListFilter();
                for (i = 0; i < fileNames.length; ++i) {
                    if (!Main.processOne(fileNames[i], mainPassFilter)) continue;
                    anyFilesProcessed = true;
                }
                if (dexOutputArrays.size() > 1) {
                    throw new DexException("Too many classes in --main-dex-list, main dex capacity exceeded");
                }
                if (Main.args.minimalMainDex) {
                    Main.createDexFile();
                }
                for (i = 0; i < fileNames.length; ++i) {
                    if (!Main.processOne(fileNames[i], new NotFilter(mainPassFilter))) continue;
                    anyFilesProcessed = true;
                }
            } else {
                for (int i = 0; i < fileNames.length; ++i) {
                    if (!Main.processOne(fileNames[i], ClassPathOpener.acceptAll)) continue;
                    anyFilesProcessed = true;
                }
            }
        }
        catch (StopProcessing ex) {
            // empty catch block
        }
        if (Main.args.numThreads > 1) {
            try {
                threadPool.shutdown();
                threadPool.awaitTermination(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Timed out waiting for threads.");
            }
        }
        if (errors != 0) {
            DxConsole.err.println(errors + " error" + (errors == 1 ? "" : "s") + "; aborting");
            return false;
        }
        if (Main.args.incremental && !anyFilesProcessed) {
            return true;
        }
        if (!anyFilesProcessed && !Main.args.emptyOk) {
            DxConsole.err.println("no classfiles specified");
            return false;
        }
        if (Main.args.optimize && Main.args.statistics) {
            CodeStatistics.dumpStatistics(DxConsole.out);
        }
        return true;
    }

    private static void createDexFile() {
        if (outputDex != null) {
            dexOutputArrays.add(Main.writeDex());
        }
        outputDex = new DexFile(Main.args.dexOptions);
        if (Main.args.dumpWidth != 0) {
            outputDex.setDumpWidth(Main.args.dumpWidth);
        }
    }

    private static boolean processOne(String pathname, ClassPathOpener.FileNameFilter filter2) {
        ClassPathOpener opener = new ClassPathOpener(pathname, false, filter2, new ClassPathOpener.Consumer(){

            @Override
            public boolean processFileBytes(String name2, long lastModified, byte[] bytes2) {
                if (args.numThreads > 1) {
                    threadPool.execute(new ParallelProcessor(name2, lastModified, bytes2));
                    return false;
                }
                return Main.processFileBytes(name2, lastModified, bytes2);
            }

            @Override
            public void onException(Exception ex) {
                if (ex instanceof StopProcessing) {
                    throw (StopProcessing)ex;
                }
                if (ex instanceof SimException) {
                    DxConsole.err.println("\nEXCEPTION FROM SIMULATION:");
                    DxConsole.err.println(ex.getMessage() + "\n");
                    DxConsole.err.println(((SimException)ex).getContext());
                } else {
                    DxConsole.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
                    ex.printStackTrace(DxConsole.err);
                }
                errors++;
            }

            @Override
            public void onProcessArchiveStart(File file2) {
                if (args.verbose) {
                    DxConsole.out.println("processing archive " + file2 + "...");
                }
            }
        });
        return opener.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processFileBytes(String name2, long lastModified, byte[] bytes2) {
        boolean keepResources;
        boolean isClass = name2.endsWith(".class");
        boolean isClassesDex = name2.equals("classes.dex");
        boolean bl = keepResources = outputResources != null;
        if (!(isClass || isClassesDex || keepResources)) {
            if (Main.args.verbose) {
                DxConsole.out.println("ignored resource " + name2);
            }
            return false;
        }
        if (Main.args.verbose) {
            DxConsole.out.println("processing " + name2 + "...");
        }
        String fixedName = Main.fixPath(name2);
        if (isClass) {
            if (keepResources && Main.args.keepClassesInJar) {
                TreeMap<String, byte[]> treeMap = outputResources;
                synchronized (treeMap) {
                    outputResources.put(fixedName, bytes2);
                }
            }
            if (lastModified < minimumFileAge) {
                return true;
            }
            return Main.processClass(fixedName, bytes2);
        }
        if (isClassesDex) {
            List<byte[]> list = libraryDexBuffers;
            synchronized (list) {
                libraryDexBuffers.add(bytes2);
            }
            return true;
        }
        TreeMap<String, byte[]> treeMap = outputResources;
        synchronized (treeMap) {
            outputResources.put(fixedName, bytes2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processClass(String name2, byte[] bytes2) {
        if (!Main.args.coreLibrary) {
            Main.checkClassName(name2);
        }
        DirectClassFile cf = new DirectClassFile(bytes2, name2, Main.args.cfOptions.strictNameCheck);
        cf.setAttributeFactory(StdAttributeFactory.THE_ONE);
        cf.getMagic();
        int numMethodIds = outputDex.getMethodIds().items().size();
        int numFieldIds = outputDex.getFieldIds().items().size();
        int numTypeIds = outputDex.getTypeIds().items().size();
        int constantPoolSize = cf.getConstantPool().size();
        if (Main.args.multiDex && (numMethodIds + constantPoolSize > args.maxNumberOfIdxPerDex || numFieldIds + constantPoolSize > args.maxNumberOfIdxPerDex || numTypeIds + constantPoolSize + 7 > args.maxNumberOfIdxPerDex)) {
            Main.createDexFile();
        }
        try {
            ClassDefItem clazz = CfTranslator.translate(cf, bytes2, Main.args.cfOptions, Main.args.dexOptions, outputDex);
            DexFile dexFile = outputDex;
            synchronized (dexFile) {
                outputDex.add(clazz);
            }
            return true;
        }
        catch (ParseException ex) {
            DxConsole.err.println("\ntrouble processing:");
            if (Main.args.debug) {
                ex.printStackTrace(DxConsole.err);
            } else {
                ex.printContext(DxConsole.err);
            }
            ++errors;
            return false;
        }
    }

    private static void checkClassName(String name2) {
        boolean bogus = false;
        if (name2.startsWith("java/")) {
            bogus = true;
        } else if (name2.startsWith("javax/")) {
            int slashAt = name2.indexOf(47, 6);
            if (slashAt == -1) {
                bogus = true;
            } else {
                String pkg = name2.substring(6, slashAt);
                boolean bl = bogus = Arrays.binarySearch(JAVAX_CORE, pkg) >= 0;
            }
        }
        if (!bogus) {
            return;
        }
        DxConsole.err.println("\ntrouble processing \"" + name2 + "\":\n\n" + IN_RE_CORE_CLASSES);
        ++errors;
        throw new StopProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] writeDex() {
        byte[] outArray = null;
        try {
            try {
                if (Main.args.methodToDump != null) {
                    outputDex.toDex(null, false);
                    Main.dumpMethod(outputDex, Main.args.methodToDump, humanOutWriter);
                } else {
                    outArray = outputDex.toDex(humanOutWriter, Main.args.verboseDump);
                }
                if (Main.args.statistics) {
                    DxConsole.out.println(outputDex.getStatistics().toHuman());
                }
            }
            finally {
                if (humanOutWriter != null) {
                    humanOutWriter.flush();
                }
            }
        }
        catch (Exception ex) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                ex.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return null;
        }
        return outArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createJar(String fileName) {
        try {
            Manifest manifest = Main.makeManifest();
            OutputStream out = Main.openOutput(fileName);
            JarOutputStream jarOut = new JarOutputStream(out, manifest);
            try {
                for (Map.Entry<String, byte[]> e2 : outputResources.entrySet()) {
                    String name2 = e2.getKey();
                    byte[] contents = e2.getValue();
                    JarEntry entry = new JarEntry(name2);
                    int length = contents.length;
                    if (Main.args.verbose) {
                        DxConsole.out.println("writing " + name2 + "; size " + length + "...");
                    }
                    entry.setSize(length);
                    jarOut.putNextEntry(entry);
                    jarOut.write(contents);
                    jarOut.closeEntry();
                }
            }
            finally {
                jarOut.finish();
                jarOut.flush();
                Main.closeOutput(out);
            }
        }
        catch (Exception ex) {
            if (Main.args.debug) {
                DxConsole.err.println("\ntrouble writing output:");
                ex.printStackTrace(DxConsole.err);
            } else {
                DxConsole.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return false;
        }
        return true;
    }

    private static Manifest makeManifest() throws IOException {
        Attributes attribs;
        Manifest manifest;
        byte[] manifestBytes = outputResources.get(MANIFEST_NAME);
        if (manifestBytes == null) {
            manifest = new Manifest();
            attribs = manifest.getMainAttributes();
            attribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        } else {
            manifest = new Manifest(new ByteArrayInputStream(manifestBytes));
            attribs = manifest.getMainAttributes();
            outputResources.remove(MANIFEST_NAME);
        }
        String createdBy = attribs.getValue(CREATED_BY);
        createdBy = createdBy == null ? "" : createdBy + " + ";
        createdBy = createdBy + "dx 1.8";
        attribs.put(CREATED_BY, createdBy);
        attribs.putValue("Dex-Location", "classes.dex");
        return manifest;
    }

    private static OutputStream openOutput(String name2) throws IOException {
        if (name2.equals("-") || name2.startsWith("-.")) {
            return System.out;
        }
        return new FileOutputStream(name2);
    }

    private static void closeOutput(OutputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        stream.flush();
        if (stream != System.out) {
            stream.close();
        }
    }

    private static String fixPath(String path2) {
        int index2;
        if (File.separatorChar == '\\') {
            path2 = path2.replace('\\', '/');
        }
        if ((index2 = path2.lastIndexOf("/./")) != -1) {
            return path2.substring(index2 + 3);
        }
        if (path2.startsWith("./")) {
            return path2.substring(2);
        }
        return path2;
    }

    private static void dumpMethod(DexFile dex, String fqName, OutputStreamWriter out) {
        boolean wildcard = fqName.endsWith("*");
        int lastDot = fqName.lastIndexOf(46);
        if (lastDot <= 0 || lastDot == fqName.length() - 1) {
            DxConsole.err.println("bogus fully-qualified method name: " + fqName);
            return;
        }
        String className = fqName.substring(0, lastDot).replace('.', '/');
        String methodName = fqName.substring(lastDot + 1);
        ClassDefItem clazz = dex.getClassOrNull(className);
        if (clazz == null) {
            DxConsole.err.println("no such class: " + className);
            return;
        }
        if (wildcard) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        ArrayList<EncodedMethod> allMeths = clazz.getMethods();
        TreeMap<CstNat, EncodedMethod> meths = new TreeMap<CstNat, EncodedMethod>();
        for (EncodedMethod meth : allMeths) {
            String methName = meth.getName().getString();
            if ((!wildcard || !methName.startsWith(methodName)) && (wildcard || !methName.equals(methodName))) continue;
            meths.put(meth.getRef().getNat(), meth);
        }
        if (meths.size() == 0) {
            DxConsole.err.println("no such method: " + fqName);
            return;
        }
        PrintWriter pw = new PrintWriter(out);
        for (EncodedMethod meth : meths.values()) {
            meth.debugPrint(pw, Main.args.verboseDump);
            CstString sourceFile = clazz.getSourceFile();
            if (sourceFile != null) {
                pw.println("  source file: " + sourceFile.toQuoted());
            }
            Annotations methodAnnotations = clazz.getMethodAnnotations(meth.getRef());
            AnnotationsList parameterAnnotations = clazz.getParameterAnnotations(meth.getRef());
            if (methodAnnotations != null) {
                pw.println("  method annotations:");
                for (Annotation a : methodAnnotations.getAnnotations()) {
                    pw.println("    " + a);
                }
            }
            if (parameterAnnotations == null) continue;
            pw.println("  parameter annotations:");
            int sz = parameterAnnotations.size();
            for (int i = 0; i < sz; ++i) {
                pw.println("    parameter " + i);
                Annotations annotations = parameterAnnotations.get(i);
                for (Annotation a : annotations.getAnnotations()) {
                    pw.println("      " + a);
                }
            }
        }
        pw.flush();
    }

    static {
        libraryDexBuffers = new ArrayList<byte[]>();
        minimumFileAge = 0L;
        classesInMainDex = null;
        dexOutputArrays = new ArrayList<byte[]>();
        humanOutWriter = null;
    }

    private static class ParallelProcessor
    implements Runnable {
        String path;
        long lastModified;
        byte[] bytes;

        private ParallelProcessor(String path2, long lastModified, byte[] bytes2) {
            this.path = path2;
            this.lastModified = lastModified;
            this.bytes = bytes2;
        }

        @Override
        public void run() {
            if (Main.processFileBytes(this.path, this.lastModified, this.bytes)) {
                anyFilesProcessed = true;
            }
        }
    }

    public static class Arguments {
        private static final String MINIMAL_MAIN_DEX_OPTION = "--minimal-main-dex";
        private static final String MAIN_DEX_LIST_OPTION = "--main-dex-list";
        private static final String MULTI_DEX_OPTION = "--multi-dex";
        private static final String NUM_THREADS_OPTION = "--num-threads";
        private static final String INCREMENTAL_OPTION = "--incremental";
        public boolean debug = false;
        public boolean verbose = false;
        public boolean verboseDump = false;
        public boolean coreLibrary = false;
        public String methodToDump = null;
        public int dumpWidth = 0;
        public String outName = null;
        public String humanOutName = null;
        public boolean strictNameCheck = true;
        public boolean emptyOk = false;
        public boolean jarOutput = false;
        public boolean keepClassesInJar = false;
        public int targetApiLevel = 13;
        public int positionInfo = 2;
        public boolean localInfo = true;
        public boolean incremental = false;
        public boolean forceJumbo = false;
        public String[] fileNames;
        public boolean optimize = true;
        public String optimizeListFile = null;
        public String dontOptimizeListFile = null;
        public boolean statistics;
        public CfOptions cfOptions;
        public DexOptions dexOptions;
        public int numThreads = 1;
        public boolean multiDex = false;
        public String mainDexListFile = null;
        public boolean minimalMainDex = false;
        private int maxNumberOfIdxPerDex = 65536;

        public void parse(String[] args) {
            ArgumentsParser parser = new ArgumentsParser(args);
            boolean outputIsDirectory = false;
            boolean outputIsDirectDex = false;
            while (parser.getNext()) {
                if (parser.isArg("--debug")) {
                    this.debug = true;
                    continue;
                }
                if (parser.isArg("--verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (parser.isArg("--verbose-dump")) {
                    this.verboseDump = true;
                    continue;
                }
                if (parser.isArg("--no-files")) {
                    this.emptyOk = true;
                    continue;
                }
                if (parser.isArg("--no-optimize")) {
                    this.optimize = false;
                    continue;
                }
                if (parser.isArg("--no-strict")) {
                    this.strictNameCheck = false;
                    continue;
                }
                if (parser.isArg("--core-library")) {
                    this.coreLibrary = true;
                    continue;
                }
                if (parser.isArg("--statistics")) {
                    this.statistics = true;
                    continue;
                }
                if (parser.isArg("--optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.optimizeListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--no-optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        System.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.dontOptimizeListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--keep-classes")) {
                    this.keepClassesInJar = true;
                    continue;
                }
                if (parser.isArg("--output=")) {
                    this.outName = parser.getLastValue();
                    if (new File(this.outName).isDirectory()) {
                        this.jarOutput = false;
                        outputIsDirectory = true;
                        continue;
                    }
                    if (FileUtils.hasArchiveSuffix(this.outName)) {
                        this.jarOutput = true;
                        continue;
                    }
                    if (this.outName.endsWith(Main.DEX_EXTENSION) || this.outName.equals("-")) {
                        this.jarOutput = false;
                        outputIsDirectDex = true;
                        continue;
                    }
                    System.err.println("unknown output extension: " + this.outName);
                    throw new UsageException();
                }
                if (parser.isArg("--dump-to=")) {
                    this.humanOutName = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--dump-width=")) {
                    this.dumpWidth = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg("--dump-method=")) {
                    this.methodToDump = parser.getLastValue();
                    this.jarOutput = false;
                    continue;
                }
                if (parser.isArg("--positions=")) {
                    String pstr = parser.getLastValue().intern();
                    if (pstr == "none") {
                        this.positionInfo = 1;
                        continue;
                    }
                    if (pstr == "important") {
                        this.positionInfo = 3;
                        continue;
                    }
                    if (pstr == "lines") {
                        this.positionInfo = 2;
                        continue;
                    }
                    System.err.println("unknown positions option: " + pstr);
                    throw new UsageException();
                }
                if (parser.isArg("--no-locals")) {
                    this.localInfo = false;
                    continue;
                }
                if (parser.isArg("--num-threads=")) {
                    this.numThreads = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg(INCREMENTAL_OPTION)) {
                    this.incremental = true;
                    continue;
                }
                if (parser.isArg("--force-jumbo")) {
                    this.forceJumbo = true;
                    continue;
                }
                if (parser.isArg(MULTI_DEX_OPTION)) {
                    this.multiDex = true;
                    continue;
                }
                if (parser.isArg("--main-dex-list=")) {
                    this.mainDexListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg(MINIMAL_MAIN_DEX_OPTION)) {
                    this.minimalMainDex = true;
                    continue;
                }
                if (parser.isArg("--set-max-idx-number=")) {
                    this.maxNumberOfIdxPerDex = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                System.err.println("unknown option: " + parser.getCurrent());
                throw new UsageException();
            }
            this.fileNames = parser.getRemaining();
            if (this.fileNames.length == 0) {
                if (!this.emptyOk) {
                    System.err.println("no input files specified");
                    throw new UsageException();
                }
            } else if (this.emptyOk) {
                System.out.println("ignoring input files");
            }
            if (this.humanOutName == null && this.methodToDump != null) {
                this.humanOutName = "-";
            }
            if (this.mainDexListFile != null && !this.multiDex) {
                System.err.println("--main-dex-list is only supported in combination with --multi-dex");
                throw new UsageException();
            }
            if (this.minimalMainDex && (this.mainDexListFile == null || !this.multiDex)) {
                System.err.println("--minimal-main-dex is only supported in combination with --multi-dex and --main-dex-list");
                throw new UsageException();
            }
            if (this.multiDex && this.numThreads != 1) {
                System.out.println("--num-threadsis ignored when used with --multi-dex");
            }
            if (this.multiDex && this.incremental) {
                System.err.println("--incremental is not supported with --multi-dex");
                throw new UsageException();
            }
            if (this.multiDex && outputIsDirectDex) {
                System.err.println("Unsupported output \"" + this.outName + "\". " + MULTI_DEX_OPTION + " supports only archive or directory output");
                throw new UsageException();
            }
            if (outputIsDirectory && !this.multiDex) {
                this.outName = new File(this.outName, "classes.dex").getPath();
            }
            this.makeOptionsObjects();
        }

        private void makeOptionsObjects() {
            this.cfOptions = new CfOptions();
            this.cfOptions.positionInfo = this.positionInfo;
            this.cfOptions.localInfo = this.localInfo;
            this.cfOptions.strictNameCheck = this.strictNameCheck;
            this.cfOptions.optimize = this.optimize;
            this.cfOptions.optimizeListFile = this.optimizeListFile;
            this.cfOptions.dontOptimizeListFile = this.dontOptimizeListFile;
            this.cfOptions.statistics = this.statistics;
            this.cfOptions.warn = DxConsole.err;
            this.dexOptions = new DexOptions();
            this.dexOptions.targetApiLevel = this.targetApiLevel;
            this.dexOptions.forceJumbo = this.forceJumbo;
        }

        private static class ArgumentsParser {
            private final String[] arguments;
            private int index;
            private String current;
            private String lastValue;

            public ArgumentsParser(String[] arguments) {
                this.arguments = arguments;
                this.index = 0;
            }

            public String getCurrent() {
                return this.current;
            }

            public String getLastValue() {
                return this.lastValue;
            }

            public boolean getNext() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                if (this.current.equals("--") || !this.current.startsWith("--")) {
                    return false;
                }
                ++this.index;
                return true;
            }

            private boolean getNextValue() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                ++this.index;
                return true;
            }

            public String[] getRemaining() {
                int n = this.arguments.length - this.index;
                String[] remaining = new String[n];
                if (n > 0) {
                    System.arraycopy(this.arguments, this.index, remaining, 0, n);
                }
                return remaining;
            }

            public boolean isArg(String prefix) {
                int n = prefix.length();
                if (n > 0 && prefix.charAt(n - 1) == '=') {
                    if (this.current.startsWith(prefix)) {
                        this.lastValue = this.current.substring(n);
                        return true;
                    }
                    if (this.current.equals(prefix = prefix.substring(0, n - 1))) {
                        if (this.getNextValue()) {
                            this.lastValue = this.current;
                            return true;
                        }
                        System.err.println("Missing value after parameter " + prefix);
                        throw new UsageException();
                    }
                    return false;
                }
                return this.current.equals(prefix);
            }
        }
    }

    private static class StopProcessing
    extends RuntimeException {
        private StopProcessing() {
        }
    }

    private static class BestEffortMainDexListFilter
    implements ClassPathOpener.FileNameFilter {
        Map<String, List<String>> map = new HashMap<String, List<String>>();

        public BestEffortMainDexListFilter() {
            for (String pathOfClass : classesInMainDex) {
                String normalized = Main.fixPath(pathOfClass);
                String simple = BestEffortMainDexListFilter.getSimpleName(normalized);
                List<String> fullPath = this.map.get(simple);
                if (fullPath == null) {
                    fullPath = new ArrayList<String>(1);
                    this.map.put(simple, fullPath);
                }
                fullPath.add(normalized);
            }
        }

        @Override
        public boolean accept(String path2) {
            if (path2.endsWith(".class")) {
                String normalized = Main.fixPath(path2);
                String simple = BestEffortMainDexListFilter.getSimpleName(normalized);
                List<String> fullPaths = this.map.get(simple);
                if (fullPaths != null) {
                    for (String fullPath : fullPaths) {
                        if (!normalized.endsWith(fullPath)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private static String getSimpleName(String path2) {
            int index2 = path2.lastIndexOf(47);
            if (index2 >= 0) {
                return path2.substring(index2 + 1);
            }
            return path2;
        }
    }

    private static class MainDexListFilter
    implements ClassPathOpener.FileNameFilter {
        private MainDexListFilter() {
        }

        @Override
        public boolean accept(String fullPath) {
            if (fullPath.endsWith(".class")) {
                String path2 = Main.fixPath(fullPath);
                return classesInMainDex.contains(path2);
            }
            return true;
        }
    }

    private static class NotFilter
    implements ClassPathOpener.FileNameFilter {
        private final ClassPathOpener.FileNameFilter filter;

        private NotFilter(ClassPathOpener.FileNameFilter filter2) {
            this.filter = filter2;
        }

        @Override
        public boolean accept(String path2) {
            return !this.filter.accept(path2);
        }
    }
}

