/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.cf;

import com.android.dx.dex.code.DalvCode;
import com.android.dx.rop.code.RopMethod;
import java.io.PrintStream;

public final class CodeStatistics {
    private static final boolean DEBUG = false;
    public static int runningDeltaRegisters = 0;
    public static int runningDeltaInsns = 0;
    public static int runningTotalInsns = 0;
    public static int dexRunningDeltaRegisters = 0;
    public static int dexRunningDeltaInsns = 0;
    public static int dexRunningTotalInsns = 0;
    public static int runningOriginalBytes = 0;

    private CodeStatistics() {
    }

    public static void updateOriginalByteCount(int count2) {
        runningOriginalBytes += count2;
    }

    public static void updateDexStatistics(DalvCode nonOptCode, DalvCode code) {
        dexRunningDeltaInsns += code.getInsns().codeSize() - nonOptCode.getInsns().codeSize();
        dexRunningDeltaRegisters += code.getInsns().getRegistersSize() - nonOptCode.getInsns().getRegistersSize();
        dexRunningTotalInsns += code.getInsns().codeSize();
    }

    public static void updateRopStatistics(RopMethod nonOptRmeth, RopMethod rmeth) {
        int oldCountInsns = nonOptRmeth.getBlocks().getEffectiveInstructionCount();
        int oldCountRegs = nonOptRmeth.getBlocks().getRegCount();
        int newCountInsns = rmeth.getBlocks().getEffectiveInstructionCount();
        runningDeltaInsns += newCountInsns - oldCountInsns;
        runningDeltaRegisters += rmeth.getBlocks().getRegCount() - oldCountRegs;
        runningTotalInsns += newCountInsns;
    }

    public static void dumpStatistics(PrintStream out) {
        out.printf("Optimizer Delta Rop Insns: %d total: %d (%.2f%%) Delta Registers: %d\n", runningDeltaInsns, runningTotalInsns, 100.0 * (double)((float)runningDeltaInsns / (float)(runningTotalInsns + Math.abs(runningDeltaInsns))), runningDeltaRegisters);
        out.printf("Optimizer Delta Dex Insns: Insns: %d total: %d (%.2f%%) Delta Registers: %d\n", dexRunningDeltaInsns, dexRunningTotalInsns, 100.0 * (double)((float)dexRunningDeltaInsns / (float)(dexRunningTotalInsns + Math.abs(dexRunningDeltaInsns))), dexRunningDeltaRegisters);
        out.printf("Original bytecode byte count: %d\n", runningOriginalBytes);
    }
}

