/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Obj;

public class Range
extends ASeq
implements IReduce,
Counted {
    final int end;
    final int n;

    public Range(int start, int end) {
        this.end = end;
        this.n = start;
    }

    public Range(IPersistentMap meta, int start, int end) {
        super(meta);
        this.end = end;
        this.n = start;
    }

    public Obj withMeta(IPersistentMap meta) {
        if (meta == this.meta()) {
            return this;
        }
        return new Range(this.meta(), this.end, this.n);
    }

    public Object first() {
        return this.n;
    }

    public ISeq next() {
        if (this.n < this.end - 1) {
            return new Range(this._meta, this.n + 1, this.end);
        }
        return null;
    }

    public Object reduce(IFn f) {
        Object ret = this.n;
        for (int x = this.n + 1; x < this.end; ++x) {
            ret = f.invoke(ret, x);
        }
        return ret;
    }

    public Object reduce(IFn f, Object start) {
        Object ret = f.invoke(start, this.n);
        for (int x = this.n + 1; x < this.end; ++x) {
            ret = f.invoke(ret, x);
        }
        return ret;
    }

    public int count() {
        return this.end - this.n;
    }
}

