/*
 * Decompiled with CFR 0.152.
 */
package bpsm.edn.protocols;

import bpsm.edn.EdnException;
import bpsm.edn.protocols.Function;
import bpsm.edn.protocols.Protocol;
import java.util.HashMap;
import java.util.Map;

public class Protocols {
    static final String SINGLE_USE_MSG = "This builder can only be used to build a single Protocol.";
    static final String NO_MODIFY_MSG = "This builder is single-use and may not be modified after the Protocol has been built.";

    public static Protocol.Builder builder(final String name) {
        return new Protocol.Builder(){
            Function nullFn = null;
            Map<Class, Function> m = new HashMap<Class, Function>();
            boolean usedUp = false;

            public Protocol.Builder put(Class selfClass, Function fn) {
                if (this.usedUp) {
                    throw new IllegalStateException(Protocols.NO_MODIFY_MSG);
                }
                if (selfClass == null) {
                    this.nullFn = fn;
                } else {
                    this.m.put(selfClass, fn);
                }
                return this;
            }

            public Protocol build() {
                if (this.usedUp) {
                    throw new IllegalStateException(Protocols.SINGLE_USE_MSG);
                }
                this.usedUp = true;
                return new Protocol(){
                    final Map<Class, Function> cache;
                    {
                        this.cache = new HashMap<Class, Function>(m);
                    }

                    public synchronized Function lookup(Class selfClass) {
                        if (selfClass == null) {
                            return nullFn;
                        }
                        Function fn = this.cache.get(selfClass);
                        if (fn != null) {
                            return fn;
                        }
                        Class k = null;
                        for (Class c : m.keySet()) {
                            if (!c.isAssignableFrom(selfClass)) continue;
                            if (k == null) {
                                k = c;
                                continue;
                            }
                            throw new EdnException(Protocols.ambiguity(this, selfClass, k, c));
                        }
                        fn = m.get(k);
                        this.cache.put(selfClass, fn);
                        return fn;
                    }

                    public String toString() {
                        return "Protocol '" + name;
                    }

                    public String name() {
                        return name;
                    }
                };
            }
        };
    }

    static String ambiguity(Protocol p, Class selfClass, Class k, Class c) {
        return p + " can't decide on an implementation for " + selfClass + " both " + k + " and " + c + " seem to match. " + "Bind an implementation to " + selfClass + ", specifically, " + " to resolve this ambiguity.";
    }
}

