/*
 * Decompiled with CFR 0.152.
 */
package bpsm.edn.parser;

import bpsm.edn.EdnException;
import bpsm.edn.Keyword;
import bpsm.edn.Symbol;
import bpsm.edn.Tag;
import bpsm.edn.parser.Parser;
import bpsm.edn.parser.TagHandler;
import bpsm.edn.parser.Token;
import bpsm.edn.util.CharClassify;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;

class Scanner
implements Closeable {
    static final Symbol NIL_SYMBOL = Symbol.newSymbol(null, "nil");
    static final Symbol TRUE_SYMBOL = Symbol.newSymbol(null, "true");
    static final Symbol FALSE_SYMBOL = Symbol.newSymbol(null, "false");
    static final Symbol SLASH_SYMBOL = Symbol.newSymbol(null, "/");
    static final char END = '\u0000';
    static final int BUFFER_CAPACITY = 4096;
    private final TagHandler longHandler;
    private final TagHandler bigDecimalHandler;
    private final TagHandler bigIntegerHandler;
    private final TagHandler doubleHandler;
    private Readable readable;
    private CharBuffer head = null;
    private CharBuffer tail = null;
    private char curr = '\u0000';
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);

    private int readIntoBuffer(CharBuffer buff) throws IOException {
        buff.clear();
        int n = 0;
        while (n == 0) {
            n = this.readable.read(buff);
        }
        buff.flip();
        assert (buff.position() == 0);
        assert (buff.limit() == n || buff.limit() == 0 && n < 0);
        return n;
    }

    private void initBuffers() throws IOException {
        assert (this.head == null && this.tail == null);
        this.head = CharBuffer.allocate(4096);
        this.tail = CharBuffer.allocate(4096);
        if (this.readIntoBuffer(this.head) < 0) {
            this.tail.position(0);
            this.tail.limit(0);
        } else {
            this.readIntoBuffer(this.tail);
        }
    }

    private void advanceBuffers() throws IOException {
        if (this.head.limit() == 0) {
            return;
        }
        if (this.tail.limit() == 0) {
            this.head = this.tail;
            return;
        }
        CharBuffer temp = this.head;
        this.head = this.tail;
        this.tail = temp;
        this.readIntoBuffer(this.tail);
    }

    private char nextChar() throws IOException {
        if (this.head == null) {
            this.initBuffers();
        }
        if (this.head.position() == this.head.limit()) {
            this.advanceBuffers();
        }
        if (this.head.limit() == 0) {
            this.curr = '\u0000';
            return '\u0000';
        }
        this.curr = this.head.get();
        return this.curr;
    }

    private char curr() throws IOException {
        return this.curr;
    }

    private char peek() {
        if (this.head.position() < this.head.limit()) {
            return this.head.get(this.head.position());
        }
        if (this.tail.limit() > 0) {
            return this.tail.get(0);
        }
        return '\u0000';
    }

    Scanner(Parser.Config cfg, Readable readable) throws IOException {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg must not be null");
        }
        if (readable == null) {
            throw new IllegalArgumentException("readable must not be null");
        }
        this.longHandler = cfg.getTagHandler(Parser.Config.LONG_TAG);
        this.bigIntegerHandler = cfg.getTagHandler(Parser.Config.BIG_INTEGER_TAG);
        this.doubleHandler = cfg.getTagHandler(Parser.Config.DOUBLE_TAG);
        this.bigDecimalHandler = cfg.getTagHandler(Parser.Config.BIG_DECIMAL_TAG);
        this.readable = readable;
        this.initBuffers();
        this.nextChar();
    }

    public void close() throws IOException {
        if (this.readable instanceof Closeable) {
            ((Closeable)((Object)this.readable)).close();
        }
    }

    public Object nextToken() throws IOException {
        try {
            return this.nextToken0();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private Object nextToken0() throws IOException {
        this.skipWhitespaceAndComments();
        switch (this.curr()) {
            case '\u0000': {
                return Token.END_OF_INPUT;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': {
                return this.readSymbol();
            }
            case 'f': {
                Symbol sym = this.readSymbol();
                return FALSE_SYMBOL.equals(sym) ? Boolean.valueOf(false) : sym;
            }
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': {
                return this.readSymbol();
            }
            case 'n': {
                Symbol sym = this.readSymbol();
                return NIL_SYMBOL.equals(sym) ? Token.NIL : sym;
            }
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': {
                return this.readSymbol();
            }
            case 't': {
                Symbol sym = this.readSymbol();
                return TRUE_SYMBOL.equals(sym) ? Boolean.valueOf(true) : sym;
            }
            case '!': 
            case '*': 
            case '.': 
            case '/': 
            case '?': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                return this.readSymbol();
            }
            case '+': 
            case '-': {
                if (CharClassify.isDigit(this.peek())) {
                    return this.readNumber();
                }
                return this.readSymbol();
            }
            case ':': {
                return this.readKeyword();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.readNumber();
            }
            case '{': {
                this.nextChar();
                return Token.BEGIN_MAP;
            }
            case '}': {
                this.nextChar();
                return Token.END_MAP_OR_SET;
            }
            case '[': {
                this.nextChar();
                return Token.BEGIN_VECTOR;
            }
            case ']': {
                this.nextChar();
                return Token.END_VECTOR;
            }
            case '(': {
                this.nextChar();
                return Token.BEGIN_LIST;
            }
            case ')': {
                this.nextChar();
                return Token.END_LIST;
            }
            case '#': {
                switch (this.peek()) {
                    case '{': {
                        this.nextChar();
                        this.nextChar();
                        return Token.BEGIN_SET;
                    }
                    case '_': {
                        this.nextChar();
                        this.nextChar();
                        return Token.DISCARD;
                    }
                }
                return this.readTag();
            }
            case '\"': {
                return this.readStringLiteral();
            }
            case '\\': {
                return Character.valueOf(this.readCharacterLiteral());
            }
        }
        throw new EdnException(String.format("Unexpected character '%c', \\u%04x", Character.valueOf(this.curr()), (int)this.curr()));
    }

    private void skipWhitespaceAndComments() throws IOException {
        this.skipWhitespace();
        while (this.curr() == ';') {
            this.skipComment();
            this.skipWhitespace();
        }
    }

    private void skipWhitespace() throws IOException {
        while (CharClassify.isWhitespace(this.curr()) && this.curr() != '\u0000') {
            this.nextChar();
        }
    }

    private void skipComment() throws IOException {
        assert (this.curr() == ';');
        do {
            this.nextChar();
        } while (!Scanner.isEndOfLine(this.curr()) && this.curr() != '\u0000');
    }

    private static final boolean isEndOfLine(char c) {
        return c == '\n' || c == '\r';
    }

    private char readCharacterLiteral() throws IOException {
        assert (this.curr() == '\\');
        this.nextChar();
        if (CharClassify.isWhitespace(this.curr())) {
            throw new EdnException("A backslash introducing character literal must not be immediately followed by whitespace.");
        }
        StringBuilder b = new StringBuilder();
        do {
            b.append(this.curr());
        } while (!CharClassify.separatesTokens(this.nextChar()));
        String s = b.toString();
        if (s.length() == 1) {
            return s.charAt(0);
        }
        return Scanner.charForName(s);
    }

    private static char charForName(String name) {
        switch (name.charAt(0)) {
            case 'n': {
                if ("newline".equals(name)) {
                    return '\n';
                }
            }
            case 's': {
                if ("space".equals(name)) {
                    return ' ';
                }
            }
            case 't': {
                if ("tab".equals(name)) {
                    return '\t';
                }
            }
            case 'b': {
                if ("backspace".equals(name)) {
                    return '\b';
                }
            }
            case 'f': {
                if ("formfeed".equals(name)) {
                    return '\f';
                }
            }
            case 'r': {
                if (!"return".equals(name)) break;
                return '\r';
            }
        }
        throw new EdnException("The character \\" + name + " was not recognized.");
    }

    private String readStringLiteral() throws IOException {
        assert (this.curr() == '\"');
        this.nextChar();
        StringBuffer b = new StringBuffer();
        while (this.curr() != '\"' && this.curr() != '\u0000') {
            block14: {
                block13: {
                    if (this.curr() != '\\') break block13;
                    this.nextChar();
                    switch (this.curr()) {
                        case 'b': {
                            b.append('\b');
                            break block14;
                        }
                        case 't': {
                            b.append('\t');
                            break block14;
                        }
                        case 'n': {
                            b.append('\n');
                            break block14;
                        }
                        case 'f': {
                            b.append('\f');
                            break block14;
                        }
                        case 'r': {
                            b.append('\r');
                            break block14;
                        }
                        case '\"': {
                            b.append('\"');
                            break block14;
                        }
                        case '\'': {
                            b.append('\'');
                            break block14;
                        }
                        case '\\': {
                            b.append('\\');
                            break block14;
                        }
                        default: {
                            throw new EdnException("Unsupported '" + this.curr() + "' escape in string");
                        }
                    }
                }
                b.append(this.curr());
            }
            this.nextChar();
        }
        if (this.curr() != '\"') {
            throw new EdnException("Unclosed string literal");
        }
        this.nextChar();
        return b.toString();
    }

    private Object readNumber() throws IOException {
        assert (CharClassify.startsNumber(this.curr()));
        StringBuffer digits = new StringBuffer();
        if (this.curr() != '+') {
            digits.append(this.curr());
        }
        while (CharClassify.isDigit(this.nextChar())) {
            digits.append(this.curr());
        }
        if (this.curr() == '.' || this.curr() == 'e' || this.curr() == 'E' || this.curr() == 'M') {
            return this.parseFloat(digits);
        }
        return this.parseInteger(digits);
    }

    private Object parseFloat(StringBuffer digits) throws IOException {
        boolean decimal;
        if (this.curr() == '.') {
            do {
                digits.append(this.curr());
            } while (CharClassify.isDigit(this.nextChar()));
        }
        if (this.curr() == 'e' || this.curr() == 'E') {
            digits.append(this.curr());
            this.nextChar();
            if (this.curr() != '-' && this.curr() != '+' && !CharClassify.isDigit(this.curr())) {
                throw new EdnException("Not a number: '" + digits + this.curr() + "'.");
            }
            do {
                digits.append(this.curr());
            } while (CharClassify.isDigit(this.nextChar()));
        }
        if (this.curr() == 'M') {
            decimal = true;
            this.nextChar();
        } else {
            decimal = false;
        }
        if (!CharClassify.separatesTokens(this.curr())) {
            throw new EdnException("Not a number: '" + digits + this.curr() + "'.");
        }
        if (decimal) {
            BigDecimal d = new BigDecimal(digits.toString());
            return this.bigDecimalHandler.transform(Parser.Config.BIG_DECIMAL_TAG, d);
        }
        double d = Double.parseDouble(digits.toString());
        return this.doubleHandler.transform(Parser.Config.DOUBLE_TAG, d);
    }

    private Object parseInteger(CharSequence digits) throws IOException {
        boolean bigint;
        if (this.curr() == 'N') {
            bigint = true;
            this.nextChar();
        } else {
            bigint = false;
        }
        if (!CharClassify.separatesTokens(this.curr())) {
            throw new EdnException("Not a number: '" + digits + this.curr() + "'.");
        }
        BigInteger n = new BigInteger(digits.toString());
        if (bigint || MIN_LONG.compareTo(n) > 0 || n.compareTo(MAX_LONG) > 0) {
            return this.bigIntegerHandler.transform(Parser.Config.BIG_INTEGER_TAG, n);
        }
        return this.longHandler.transform(Parser.Config.LONG_TAG, n.longValue());
    }

    private Keyword readKeyword() throws IOException {
        assert (this.curr() == ':');
        this.nextChar();
        Symbol sym = this.readSymbol();
        if (SLASH_SYMBOL.equals(sym)) {
            throw new EdnException("':/' is not a valid keyword.");
        }
        return Keyword.newKeyword(sym);
    }

    private Tag readTag() throws IOException {
        assert (this.curr() == '#');
        this.nextChar();
        return Tag.newTag(this.readSymbol());
    }

    private Symbol readSymbol() throws IOException {
        assert (CharClassify.symbolStart(this.curr()));
        StringBuilder b = new StringBuilder();
        int n = 0;
        int p = Integer.MIN_VALUE;
        do {
            if (this.curr() == '/') {
                ++n;
                p = b.length();
            }
            b.append(this.curr());
            this.nextChar();
        } while (!CharClassify.separatesTokens(this.curr()));
        this.validateUseOfSlash(b, n, p);
        return this.makeSymbol(b, n, p);
    }

    private Symbol makeSymbol(StringBuilder b, int slashCount, int slashPos) {
        if (slashCount == 0) {
            return Symbol.newSymbol(null, b.toString());
        }
        assert (slashCount == 1);
        if (slashPos == 0) {
            assert (b.length() == 1 && b.charAt(0) == '/');
            return Symbol.newSymbol(null, b.toString());
        }
        return Symbol.newSymbol(b.substring(0, slashPos), b.substring(slashPos + 1));
    }

    private void validateUseOfSlash(CharSequence s, int slashCount, int lastSlashPos) {
        if (slashCount > 1) {
            throw new EdnException("The name '" + s + "' must not contain more than one '/'.");
        }
        if (lastSlashPos == 0 && s.length() > 1) {
            throw new EdnException("The name '" + s + "' must not start with '/'.");
        }
        if (s.length() > 1 && lastSlashPos == s.length() - 1) {
            throw new EdnException("The name '" + s + "' must not end with '/'.");
        }
    }
}

