/*
 * Decompiled with CFR 0.152.
 */
package bpsm.edn.parser;

import bpsm.edn.EdnIOException;
import bpsm.edn.Tag;
import bpsm.edn.parser.CollectionBuilder;
import bpsm.edn.parser.DefaultListFactory;
import bpsm.edn.parser.DefaultMapFactory;
import bpsm.edn.parser.DefaultSetFactory;
import bpsm.edn.parser.DefaultVectorFactory;
import bpsm.edn.parser.Parser;
import bpsm.edn.parser.ParserImpl;
import bpsm.edn.parser.Scanner;
import bpsm.edn.parser.TagHandler;
import bpsm.edn.parser.UuidHandler;
import bpsm.edn.parser.inst.InstantToDate;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parsers {
    static final CollectionBuilder.Factory DEFAULT_LIST_FACTORY = new DefaultListFactory();
    static final CollectionBuilder.Factory DEFAULT_VECTOR_FACTORY = new DefaultVectorFactory();
    static final CollectionBuilder.Factory DEFAULT_SET_FACTORY = new DefaultSetFactory();
    static final CollectionBuilder.Factory DEFAULT_MAP_FACTORY = new DefaultMapFactory();
    static final TagHandler INSTANT_TO_DATE = new InstantToDate();
    static final TagHandler UUID_HANDLER = new UuidHandler();
    static final TagHandler IDENTITY = new TagHandler(){

        public Object transform(Tag tag, Object value) {
            return value;
        }
    };
    static Parser.Config DEFAULT_CONFIGURATION = Parsers.newParserConfigBuilder().build();

    public static Parser newParser(Parser.Config cfg, Readable readable) {
        try {
            return Parsers.newParser(cfg, new Scanner(cfg, readable));
        }
        catch (IOException e) {
            throw new EdnIOException(e);
        }
    }

    public static Parser newParser(Parser.Config cfg, CharSequence input) {
        try {
            return Parsers.newParser(cfg, new Scanner(cfg, CharBuffer.wrap(input)));
        }
        catch (IOException e) {
            throw new EdnIOException(e);
        }
    }

    static Parser newParser(Parser.Config cfg, Scanner scanner) throws IOException {
        return new ParserImpl(cfg, scanner);
    }

    public static Parser.Config.Builder newParserConfigBuilder() {
        return new Parser.Config.Builder(){
            boolean used = false;
            CollectionBuilder.Factory listFactory = DEFAULT_LIST_FACTORY;
            CollectionBuilder.Factory vectorFactory = DEFAULT_VECTOR_FACTORY;
            CollectionBuilder.Factory setFactory = DEFAULT_SET_FACTORY;
            CollectionBuilder.Factory mapFactory = DEFAULT_MAP_FACTORY;
            Map<Tag, TagHandler> tagHandlers = Parsers.defaultTagHandlers();

            public Parser.Config.Builder setListFactory(CollectionBuilder.Factory listFactory) {
                this.checkState();
                this.listFactory = listFactory;
                return this;
            }

            public Parser.Config.Builder setVectorFactory(CollectionBuilder.Factory vectorFactory) {
                this.checkState();
                this.vectorFactory = vectorFactory;
                return this;
            }

            public Parser.Config.Builder setSetFactory(CollectionBuilder.Factory setFactory) {
                this.checkState();
                this.setFactory = setFactory;
                return this;
            }

            public Parser.Config.Builder setMapFactory(CollectionBuilder.Factory mapFactory) {
                this.checkState();
                this.mapFactory = mapFactory;
                return this;
            }

            public Parser.Config.Builder putTagHandler(Tag tag, TagHandler handler) {
                this.checkState();
                this.tagHandlers.put(tag, handler);
                return this;
            }

            public Parser.Config build() {
                this.checkState();
                this.used = true;
                return new Parser.Config(){

                    public CollectionBuilder.Factory getListFactory() {
                        return listFactory;
                    }

                    public CollectionBuilder.Factory getVectorFactory() {
                        return vectorFactory;
                    }

                    public CollectionBuilder.Factory getSetFactory() {
                        return setFactory;
                    }

                    public CollectionBuilder.Factory getMapFactory() {
                        return mapFactory;
                    }

                    public TagHandler getTagHandler(Tag tag) {
                        return tagHandlers.get(tag);
                    }
                };
            }

            private void checkState() {
                if (this.used) {
                    throw new IllegalStateException("Builder is single-use. Not usable after build()");
                }
            }
        };
    }

    static Map<Tag, TagHandler> defaultTagHandlers() {
        HashMap<Tag, TagHandler> m = new HashMap<Tag, TagHandler>();
        m.put(Parser.Config.EDN_UUID, UUID_HANDLER);
        m.put(Parser.Config.EDN_INSTANT, INSTANT_TO_DATE);
        m.put(Parser.Config.BIG_DECIMAL_TAG, IDENTITY);
        m.put(Parser.Config.DOUBLE_TAG, IDENTITY);
        m.put(Parser.Config.BIG_INTEGER_TAG, IDENTITY);
        m.put(Parser.Config.LONG_TAG, IDENTITY);
        return m;
    }

    public static Parser.Config defaultConfiguration() {
        return DEFAULT_CONFIGURATION;
    }
}

