/*
 * Decompiled with CFR 0.152.
 */
package mikera.cljutils;

import clojure.lang.IPersistentCollection;
import clojure.lang.ISeq;
import clojure.lang.Numbers;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Sequential;
import java.util.Collection;
import java.util.Iterator;

public final class FastSeq
implements ISeq,
Sequential,
Collection<Object> {
    public Object _first;
    public FastSeq _next;
    public Object x;

    public FastSeq() {
        this(null, null);
    }

    public FastSeq(Object o) {
        this(o, null);
    }

    public FastSeq(Object o, FastSeq next) {
        this._first = o;
        this._next = next;
    }

    public int count() {
        int result = 0;
        FastSeq head = this._next;
        while (head != null) {
            head = head._next;
            ++result;
        }
        return result;
    }

    public IPersistentCollection empty() {
        return null;
    }

    public boolean equiv(Object o) {
        ISeq oseq = RT.seq((Object)o);
        FastSeq head = this;
        while (head != null) {
            if (oseq == null) {
                return false;
            }
            if (!Numbers.equiv((Object)head._first, (Object)oseq.first())) {
                return false;
            }
            head = head._next;
            oseq = oseq.next();
        }
        return o == null;
    }

    public ISeq seq() {
        return this;
    }

    public Object first() {
        return this._first;
    }

    public ISeq next() {
        return this._next;
    }

    public ISeq more() {
        return this._next == null ? PersistentList.EMPTY : this._next;
    }

    public ISeq cons(Object o) {
        return new FastSeq(o, this);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        FastSeq head = this;
        while (head != null) {
            if (o.equals(head._first)) {
                return true;
            }
            head = head._next;
        }
        return false;
    }

    @Override
    public Iterator<Object> iterator() {
        return new FastSeqIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.count()];
        int i = 0;
        for (Object o : this) {
            arr[i++] = o;
        }
        return arr;
    }

    @Override
    public Object[] toArray(Object[] a) {
        int i = 0;
        for (Object o : this) {
            a[i++] = o;
        }
        return a;
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<? extends Object> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public class FastSeqIterator
    implements Iterator<Object> {
        FastSeq head;

        public FastSeqIterator() {
            this.head = FastSeq.this;
        }

        @Override
        public boolean hasNext() {
            return this.head != null;
        }

        @Override
        public Object next() {
            Object result = this.head._first;
            this.head = this.head._next;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

