/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.light;

import com.sun.scenario.effect.light.Light;
import java.awt.Color;

public class DistantLight
extends Light {
    private float azimuth;
    private float elevation;

    public DistantLight() {
        this(0.0f, 0.0f, Color.WHITE);
    }

    public DistantLight(float azimuth, float elevation, Color color) {
        super(Light.Type.DISTANT, color);
        this.azimuth = azimuth;
        this.elevation = elevation;
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(float azimuth) {
        float old = this.azimuth;
        this.azimuth = azimuth;
        this.firePropertyChange("azimuth", Float.valueOf(old), Float.valueOf(azimuth));
    }

    public float getElevation() {
        return this.elevation;
    }

    public void setElevation(float elevation) {
        float old = this.elevation;
        this.elevation = elevation;
        this.firePropertyChange("elevation", Float.valueOf(old), Float.valueOf(elevation));
    }

    @Override
    public float[] getNormalizedLightPosition() {
        float z;
        float y;
        double a = Math.toRadians(this.azimuth);
        double e = Math.toRadians(this.elevation);
        float x = (float)(Math.cos(a) * Math.cos(e));
        float len = (float)Math.sqrt(x * x + (y = (float)(Math.sin(a) * Math.cos(e))) * y + (z = (float)Math.sin(e)) * z);
        if (len == 0.0f) {
            len = 1.0f;
        }
        float[] pos = new float[]{x / len, y / len, z / len};
        return pos;
    }
}

