/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Source;
import com.sun.scenario.effect.impl.state.PerspectiveTransformState;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public class PerspectiveTransform
extends CoreEffect {
    private float[][] tx = new float[3][3];
    private float xmin;
    private float ymin;
    private float xmax;
    private float ymax;
    private float ulx;
    private float uly;
    private float urx;
    private float ury;
    private float lrx;
    private float lry;
    private float llx;
    private float lly;
    private Rectangle2D lastInputBounds;
    private final PerspectiveTransformState state = new PerspectiveTransformState();

    public PerspectiveTransform() {
        this(new Source(true));
    }

    public PerspectiveTransform(Effect input) {
        super(input);
        this.setQuadMapping(0.0f, 0.0f, 100.0f, 0.0f, 100.0f, 100.0f, 0.0f, 100.0f);
        this.updatePeerKey("PerspectiveTransform");
    }

    @Override
    Object getState() {
        return this.state;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    private void setUnitQuadMapping(float ulx, float uly, float urx, float ury, float lrx, float lry, float llx, float lly) {
        float dx3 = ulx - urx + lrx - llx;
        float dy3 = uly - ury + lry - lly;
        this.tx = new float[3][3];
        this.tx[2][2] = 1.0f;
        if (dx3 == 0.0f && dy3 == 0.0f) {
            this.tx[0][0] = urx - ulx;
            this.tx[0][1] = lrx - urx;
            this.tx[0][2] = ulx;
            this.tx[1][0] = ury - uly;
            this.tx[1][1] = lry - ury;
            this.tx[1][2] = uly;
            this.tx[2][0] = 0.0f;
            this.tx[2][1] = 0.0f;
        } else {
            float dx1 = urx - lrx;
            float dy1 = ury - lry;
            float dx2 = llx - lrx;
            float dy2 = lly - lry;
            float invdet = 1.0f / (dx1 * dy2 - dx2 * dy1);
            this.tx[2][0] = (dx3 * dy2 - dx2 * dy3) * invdet;
            this.tx[2][1] = (dx1 * dy3 - dx3 * dy1) * invdet;
            this.tx[0][0] = urx - ulx + this.tx[2][0] * urx;
            this.tx[0][1] = llx - ulx + this.tx[2][1] * llx;
            this.tx[0][2] = ulx;
            this.tx[1][0] = ury - uly + this.tx[2][0] * ury;
            this.tx[1][1] = lly - uly + this.tx[2][1] * lly;
            this.tx[1][2] = uly;
        }
    }

    private void setSquareToQuadMapping(float sqx, float sqy, float sqw, float sqh) {
        this.setUnitQuadMapping((this.ulx - sqx) / sqw, (this.uly - sqy) / sqh, (this.urx - sqx) / sqw, (this.ury - sqy) / sqh, (this.lrx - sqx) / sqw, (this.lry - sqy) / sqh, (this.llx - sqx) / sqw, (this.lly - sqy) / sqh);
    }

    public void setQuadMapping(float ulx, float uly, float urx, float ury, float lrx, float lry, float llx, float lly) {
        this.ulx = ulx;
        this.uly = uly;
        this.urx = urx;
        this.ury = ury;
        this.lrx = lrx;
        this.lry = lry;
        this.llx = llx;
        this.lly = lly;
        this.firePropertyChange("quadMapping", null, Float.valueOf(lly));
        this.lastInputBounds = null;
    }

    private void update(Rectangle2D r) {
        int i;
        this.setSquareToQuadMapping((float)r.getX(), (float)r.getY(), (float)r.getWidth(), (float)r.getHeight());
        this.state.updateTx(this.tx);
        float[] corners = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        for (i = 0; i < corners.length; i += 2) {
            float x = corners[i];
            float y = corners[i + 1];
            float px = x * this.tx[0][0] + y * this.tx[0][1] + this.tx[0][2];
            float py = x * this.tx[1][0] + y * this.tx[1][1] + this.tx[1][2];
            float pw = x * this.tx[2][0] + y * this.tx[2][1] + this.tx[2][2];
            corners[i] = px / pw;
            corners[i + 1] = py / pw;
        }
        this.xmin = this.xmax = corners[0];
        this.ymin = this.ymax = corners[1];
        for (i = 2; i < corners.length; i += 2) {
            this.xmin = Math.min(this.xmin, corners[i]);
            this.xmax = Math.max(this.xmax, corners[i]);
            this.ymin = Math.min(this.ymin, corners[i + 1]);
            this.ymax = Math.max(this.ymax, corners[i + 1]);
        }
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D r = this.getInputs().get(0).getBounds();
        if (this.lastInputBounds == null || !r.equals(this.lastInputBounds)) {
            this.update(r);
            this.lastInputBounds = new Rectangle2D.Float();
            this.lastInputBounds.setRect(r);
        }
        float bxmin = (float)Math.floor(r.getX() + (double)this.xmin * r.getWidth());
        float bymin = (float)Math.floor(r.getY() + (double)this.ymin * r.getHeight());
        float bxmax = (float)Math.ceil(r.getX() + (double)this.xmax * r.getWidth());
        float bymax = (float)Math.ceil(r.getY() + (double)this.ymax * r.getHeight());
        r.setFrameFromDiagonal(bxmin, bymin, bxmax, bymax);
        return r;
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        return this.filterInputs(config, 0).getImage();
    }
}

