/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Effect;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class Identity
extends Effect {
    private BufferedImage src;
    private Point2D.Float loc = new Point2D.Float();
    private final Map<GraphicsConfiguration, Image> cache = new HashMap<GraphicsConfiguration, Image>();

    public Identity(BufferedImage src) {
        this.src = src;
    }

    public final BufferedImage getSource() {
        return this.src;
    }

    public void setSource(BufferedImage src) {
        BufferedImage old = this.src;
        this.src = src;
        this.clearCache();
        this.firePropertyChange("source", old, src);
    }

    public final Point2D getLocation() {
        return this.loc;
    }

    public void setLocation(Point2D pt) {
        if (pt == null) {
            throw new IllegalArgumentException("Location must be non-null");
        }
        Point2D.Float old = this.loc;
        this.loc.setLocation(pt);
        this.firePropertyChange("location", old, pt);
    }

    @Override
    public boolean isInDeviceSpace() {
        return false;
    }

    @Override
    public int needsSourceContent() {
        return 0;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.src == null) {
            return new Rectangle();
        }
        float srcx = this.loc.x;
        float srcy = this.loc.y;
        Rectangle2D r = this.getSourceContent().getUntransformedBounds();
        if (r != null) {
            srcx = (float)((double)srcx + r.getX());
            srcy = (float)((double)srcy + r.getY());
        }
        return new Rectangle2D.Float(srcx, srcy, this.src.getWidth(), this.src.getHeight());
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        if (this.src == null) {
            return null;
        }
        Image img = this.cache.get(config);
        if (img == null) {
            img = Effect.createCompatibleImage(config, this.src.getWidth(), this.src.getHeight());
            Graphics2D g2 = (Graphics2D)img.getGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.drawImage((Image)this.src, 0, 0, null);
            g2.dispose();
            this.cache.put(config, img);
        }
        return img;
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        return Effect.AccelType.NONE;
    }

    private void clearCache() {
        this.cache.clear();
    }
}

