/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Effect;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class Flood
extends Effect {
    private Paint paint;

    public Flood(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Paint must be non-null");
        }
        this.paint = paint;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Paint must be non-null");
        }
        Paint old = this.paint;
        this.paint = paint;
        this.firePropertyChange("paint", old, paint);
    }

    @Override
    public int needsSourceContent() {
        return 0;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D.Float r = new Rectangle2D.Float();
        ((Rectangle2D)r).setRect(this.getSourceContent().getUntransformedBounds());
        return r;
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        Rectangle2D fullBounds = this.getBounds();
        Rectangle tmp = fullBounds.getBounds();
        int w = tmp.width;
        int h = tmp.height;
        Image dst = Flood.getCompatibleImage(config, w, h);
        Graphics2D gdst = (Graphics2D)dst.getGraphics();
        gdst.setComposite(AlphaComposite.Src);
        gdst.setPaint(this.paint);
        gdst.fillRect(0, 0, w, h);
        gdst.dispose();
        return dst;
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        return Effect.AccelType.NONE;
    }
}

