/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public class Blend
extends CoreEffect {
    private Mode mode;
    private float opacity;

    public Blend(Mode mode, Effect bottomInput, Effect topInput) {
        super(bottomInput, topInput);
        this.setMode(mode);
        this.setOpacity(1.0f);
    }

    public final Effect getBottomInput() {
        return this.getInputs().get(0);
    }

    public void setBottomInput(Effect bottomInput) {
        this.setInput(0, bottomInput);
    }

    public final Effect getTopInput() {
        return this.getInputs().get(1);
    }

    public void setTopInput(Effect topInput) {
        this.setInput(1, topInput);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode must be non-null");
        }
        Mode old = this.mode;
        this.mode = mode;
        this.updatePeerKey("Blend_" + mode.name());
        this.firePropertyChange("mode", (Object)old, (Object)mode);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Opacity must be in the range [0,1]");
        }
        float old = this.opacity;
        this.opacity = opacity;
        this.firePropertyChange("opacity", Float.valueOf(old), Float.valueOf(opacity));
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D r = null;
        for (Effect input : this.getInputs()) {
            Rectangle2D effectBounds = input.getTransformedBounds();
            if (r == null) {
                r = new Rectangle2D.Float();
                r.setRect(effectBounds);
                continue;
            }
            r.add(effectBounds);
        }
        return r;
    }

    @Override
    public boolean isInDeviceSpace() {
        return true;
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        return this.filterInputs(config, true, 0, 1).getImage();
    }

    public static enum Mode {
        SRC_OVER,
        SRC_IN,
        SRC_OUT,
        SRC_ATOP,
        ADD,
        MULTIPLY,
        SCREEN,
        OVERLAY,
        DARKEN,
        LIGHTEN,
        COLOR_DODGE,
        COLOR_BURN,
        HARD_LIGHT,
        SOFT_LIGHT,
        DIFFERENCE,
        EXCLUSION,
        RED,
        GREEN,
        BLUE;

    }
}

