/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import com.sun.gluegen.runtime.DynamicLinker;
import com.sun.gluegen.runtime.MacOSXDynamicLinkerImpl;
import com.sun.gluegen.runtime.NativeLibLoader;
import com.sun.gluegen.runtime.UnixDynamicLinkerImpl;
import com.sun.gluegen.runtime.WindowsDynamicLinkerImpl;
import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class NativeLibrary {
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int MACOSX = 3;
    private static boolean DEBUG;
    private static int platform;
    private static DynamicLinker dynLink;
    private static String[] prefixes;
    private static String[] suffixes;
    private long libraryHandle;
    private String libraryPath;
    private static boolean initializedFindLibraryMethod;
    private static Method findLibraryMethod;
    private static volatile boolean loadedDynLinkNativeLib;

    private NativeLibrary(long libraryHandle, String libraryPath) {
        this.libraryHandle = libraryHandle;
        this.libraryPath = libraryPath;
    }

    public static NativeLibrary open(String libName, ClassLoader loader) {
        return NativeLibrary.open(libName, libName, libName, true, loader, true);
    }

    public static NativeLibrary open(String libName, ClassLoader loader, boolean global) {
        return NativeLibrary.open(libName, libName, libName, true, loader, global);
    }

    public static NativeLibrary open(String windowsLibName, String unixLibName, String macOSXLibName, boolean searchSystemPathFirst, ClassLoader loader) {
        return NativeLibrary.open(windowsLibName, unixLibName, macOSXLibName, searchSystemPathFirst, loader, true);
    }

    public static NativeLibrary open(String windowsLibName, String unixLibName, String macOSXLibName, boolean searchSystemPathFirst, ClassLoader loader, boolean global) {
        List possiblePaths = NativeLibrary.enumerateLibraryPaths(windowsLibName, unixLibName, macOSXLibName, searchSystemPathFirst, loader);
        for (String path : possiblePaths) {
            if (DEBUG) {
                System.out.println("Trying to load " + path);
            }
            NativeLibrary.ensureNativeLibLoaded();
            long res = global ? dynLink.openLibraryGlobal(path, DEBUG) : dynLink.openLibraryLocal(path, DEBUG);
            if (res == 0L) continue;
            if (DEBUG) {
                System.out.println("Successfully loaded " + path + ": res = 0x" + Long.toHexString(res));
            }
            return new NativeLibrary(res, path);
        }
        if (DEBUG) {
            System.out.println("Did not succeed in loading (" + windowsLibName + ", " + unixLibName + ", " + macOSXLibName + ")");
        }
        return null;
    }

    public long lookupFunction(String functionName) {
        if (this.libraryHandle == 0L) {
            throw new RuntimeException("Library is not open");
        }
        return dynLink.lookupSymbol(this.libraryHandle, functionName);
    }

    public long getLibraryHandle() {
        return this.libraryHandle;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public void close() {
        if (this.libraryHandle == 0L) {
            throw new RuntimeException("Library already closed");
        }
        long handle = this.libraryHandle;
        this.libraryHandle = 0L;
        dynLink.closeLibrary(handle);
    }

    private static List enumerateLibraryPaths(String windowsLibName, String unixLibName, String macOSXLibName, boolean searchSystemPathFirst, ClassLoader loader) {
        String javaLibraryPath;
        ArrayList<String> paths = new ArrayList<String>();
        String libName = NativeLibrary.selectName(windowsLibName, unixLibName, macOSXLibName);
        if (libName == null) {
            return paths;
        }
        File file = new File(libName);
        if (file.isAbsolute()) {
            paths.add(libName);
            return paths;
        }
        String[] baseNames = NativeLibrary.buildNames(libName);
        if (searchSystemPathFirst) {
            for (int i = 0; i < baseNames.length; ++i) {
                paths.add(baseNames[i]);
            }
        }
        String clPath = NativeLibrary.getPathFromClassLoader(libName, loader);
        if (DEBUG) {
            System.out.println("Class loader path to " + libName + ": " + clPath);
        }
        if (clPath != null) {
            paths.add(clPath);
        }
        if ((javaLibraryPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.library.path");
            }
        })) != null) {
            StringTokenizer tokenizer = new StringTokenizer(javaLibraryPath, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                NativeLibrary.addPaths(tokenizer.nextToken(), baseNames, paths);
            }
        }
        String userDir = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("user.dir");
            }
        });
        NativeLibrary.addPaths(userDir, baseNames, paths);
        if (platform == 3) {
            NativeLibrary.addPaths("/Library/Frameworks/" + libName + ".Framework", baseNames, paths);
            NativeLibrary.addPaths("/System/Library/Frameworks/" + libName + ".Framework", baseNames, paths);
        }
        if (!searchSystemPathFirst) {
            for (int i = 0; i < baseNames.length; ++i) {
                paths.add(baseNames[i]);
            }
        }
        return paths;
    }

    private static String selectName(String windowsLibName, String unixLibName, String macOSXLibName) {
        switch (platform) {
            case 1: {
                return windowsLibName;
            }
            case 2: {
                return unixLibName;
            }
            case 3: {
                return macOSXLibName;
            }
        }
        throw new InternalError();
    }

    private static String[] buildNames(String libName) {
        int i;
        if (libName.startsWith(prefixes[0])) {
            if (libName.endsWith(suffixes[0])) {
                return new String[]{libName};
            }
            int idx = libName.indexOf(suffixes[0]);
            boolean ok = true;
            if (idx >= 0) {
                for (i = idx + suffixes[0].length(); i < libName.length(); ++i) {
                    char c = libName.charAt(i);
                    if (c == '.' || c >= '0' && c <= '9') continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    return new String[]{libName};
                }
            }
        }
        String[] res = new String[prefixes.length * suffixes.length];
        int idx = 0;
        for (i = 0; i < prefixes.length; ++i) {
            for (int j = 0; j < suffixes.length; ++j) {
                res[idx++] = prefixes[i] + libName + suffixes[j];
            }
        }
        return res;
    }

    private static void addPaths(String path, String[] baseNames, List paths) {
        for (int j = 0; j < baseNames.length; ++j) {
            paths.add(path + File.separator + baseNames[j]);
        }
    }

    private static String getPathFromClassLoader(final String libName, final ClassLoader loader) {
        block5: {
            if (loader == null) {
                return null;
            }
            if (!initializedFindLibraryMethod) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            findLibraryMethod = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                            findLibraryMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        initializedFindLibraryMethod = true;
                        return null;
                    }
                });
            }
            if (findLibraryMethod != null) {
                try {
                    return (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return findLibraryMethod.invoke((Object)loader, libName);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (!DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void ensureNativeLibLoaded() {
        if (loadedDynLinkNativeLib) return;
        Class<NativeLibrary> clazz = NativeLibrary.class;
        synchronized (NativeLibrary.class) {
            if (loadedDynLinkNativeLib) return;
            loadedDynLinkNativeLib = true;
            NativeLibLoader.loadGlueGenRT();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String osName = System.getProperty("os.name").toLowerCase();
                if (osName.startsWith("wind")) {
                    platform = 1;
                } else if (osName.startsWith("mac os x")) {
                    platform = 3;
                } else {
                    platform = 2;
                }
                DEBUG = System.getProperty("gluegen.debug.NativeLibrary") != null;
                return null;
            }
        });
        switch (platform) {
            case 1: {
                dynLink = new WindowsDynamicLinkerImpl();
                prefixes = new String[]{""};
                suffixes = new String[]{".dll"};
                break;
            }
            case 2: {
                dynLink = new UnixDynamicLinkerImpl();
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".so"};
                break;
            }
            case 3: {
                dynLink = new MacOSXDynamicLinkerImpl();
                prefixes = new String[]{"lib", ""};
                suffixes = new String[]{".dylib", ".jnilib", ""};
                break;
            }
            default: {
                throw new InternalError("Platform not initialized properly");
            }
        }
        initializedFindLibraryMethod = false;
        findLibraryMethod = null;
    }
}

