/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public class BufferFactoryInternal {
    private static final long addressFieldOffset;
    private static final Constructor directByteBufferConstructor;

    public static long getDirectBufferAddress(Buffer buf) {
        return buf == null ? 0L : Unsafe.getUnsafe().getLong(buf, addressFieldOffset);
    }

    public static ByteBuffer newDirectByteBuffer(long address, int capacity) {
        try {
            if (address == 0L) {
                return null;
            }
            return (ByteBuffer)directByteBufferConstructor.newInstance(new Long(address), new Integer(capacity));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long newCString(String str) {
        byte[] strBytes = str.getBytes();
        long strBlock = Unsafe.getUnsafe().allocateMemory(strBytes.length + 1);
        for (int i = 0; i < strBytes.length; ++i) {
            Unsafe.getUnsafe().putByte(strBlock + (long)i, strBytes[i]);
        }
        Unsafe.getUnsafe().putByte(strBlock + (long)strBytes.length, (byte)0);
        return strBlock;
    }

    public static void freeCString(long cStr) {
        Unsafe.getUnsafe().freeMemory(cStr);
    }

    public static String newJavaString(long cStr) {
        if (cStr == 0L) {
            return null;
        }
        int numChars = 0;
        while (Unsafe.getUnsafe().getByte(cStr + (long)numChars) != 0) {
            ++numChars;
        }
        byte[] bytes = new byte[numChars];
        for (int i = 0; i < numChars; ++i) {
            bytes[i] = Unsafe.getUnsafe().getByte(cStr + (long)i);
        }
        return new String(bytes);
    }

    public static int arrayBaseOffset(Object array) {
        return Unsafe.getUnsafe().arrayBaseOffset(array.getClass());
    }

    public static int arrayIndexScale(Object array) {
        return Unsafe.getUnsafe().arrayIndexScale(array.getClass());
    }

    static {
        try {
            Field f = Buffer.class.getDeclaredField("address");
            addressFieldOffset = Unsafe.getUnsafe().objectFieldOffset(f);
            Class<?> directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
            directByteBufferConstructor = directByteBufferClass.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            directByteBufferConstructor.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

