/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import com.sun.gluegen.runtime.PointerBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferFactory {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;
    private static final boolean isLittleEndian;

    public static boolean isLittleEndian() {
        return isLittleEndian;
    }

    public static ByteBuffer newDirectByteBuffer(int size) {
        return BufferFactory.nativeOrder(ByteBuffer.allocateDirect(size));
    }

    public static ByteBuffer nativeOrder(ByteBuffer buf) {
        return buf.order(ByteOrder.nativeOrder());
    }

    public static boolean isDirect(Object buf) {
        if (buf == null) {
            return true;
        }
        if (buf instanceof ByteBuffer) {
            return ((ByteBuffer)buf).isDirect();
        }
        if (buf instanceof FloatBuffer) {
            return ((FloatBuffer)buf).isDirect();
        }
        if (buf instanceof DoubleBuffer) {
            return ((DoubleBuffer)buf).isDirect();
        }
        if (buf instanceof CharBuffer) {
            return ((CharBuffer)buf).isDirect();
        }
        if (buf instanceof ShortBuffer) {
            return ((ShortBuffer)buf).isDirect();
        }
        if (buf instanceof IntBuffer) {
            return ((IntBuffer)buf).isDirect();
        }
        if (buf instanceof LongBuffer) {
            return ((LongBuffer)buf).isDirect();
        }
        if (buf instanceof PointerBuffer) {
            return ((PointerBuffer)buf).isDirect();
        }
        throw new RuntimeException("Unexpected buffer type " + buf.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Object buf) {
        if (buf == null) {
            return 0;
        }
        if (buf instanceof Buffer) {
            int pos = ((Buffer)buf).position();
            if (buf instanceof ByteBuffer) {
                return pos;
            }
            if (buf instanceof FloatBuffer) {
                return pos * 4;
            }
            if (buf instanceof IntBuffer) {
                return pos * 4;
            }
            if (buf instanceof ShortBuffer) {
                return pos * 2;
            }
            if (buf instanceof DoubleBuffer) {
                return pos * 8;
            }
            if (buf instanceof LongBuffer) {
                return pos * 8;
            }
            if (buf instanceof CharBuffer) {
                return pos * 2;
            }
        } else if (buf instanceof PointerBuffer) {
            return ((PointerBuffer)buf).position() * 8;
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + buf.getClass().getName());
    }

    public static Object getArray(Object buf) {
        if (buf == null) {
            return null;
        }
        if (buf instanceof ByteBuffer) {
            return ((ByteBuffer)buf).array();
        }
        if (buf instanceof FloatBuffer) {
            return ((FloatBuffer)buf).array();
        }
        if (buf instanceof IntBuffer) {
            return ((IntBuffer)buf).array();
        }
        if (buf instanceof ShortBuffer) {
            return ((ShortBuffer)buf).array();
        }
        if (buf instanceof DoubleBuffer) {
            return ((DoubleBuffer)buf).array();
        }
        if (buf instanceof LongBuffer) {
            return ((LongBuffer)buf).array();
        }
        if (buf instanceof CharBuffer) {
            return ((CharBuffer)buf).array();
        }
        if (buf instanceof PointerBuffer) {
            return ((PointerBuffer)buf).array();
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + buf.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Object buf) {
        if (buf == null) {
            return 0;
        }
        if (buf instanceof Buffer) {
            int pos = ((Buffer)buf).position();
            if (buf instanceof ByteBuffer) {
                return ((ByteBuffer)buf).arrayOffset() + pos;
            }
            if (buf instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof IntBuffer) {
                return 4 * (((IntBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof LongBuffer) {
                return 8 * (((LongBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof CharBuffer) {
                return 2 * (((CharBuffer)buf).arrayOffset() + pos);
            }
        } else if (buf instanceof PointerBuffer) {
            return 8 * (((PointerBuffer)buf).arrayOffset() + ((PointerBuffer)buf).position());
        }
        throw new RuntimeException("Unknown buffer type " + buf.getClass().getName());
    }

    public static void rangeCheck(byte[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(char[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(short[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(int[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(long[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(float[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(double[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(Buffer buffer, int minElementsRemaining) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < minElementsRemaining) {
            throw new IndexOutOfBoundsException("Required " + minElementsRemaining + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Object buffer, int minBytesRemaining) {
        if (buffer == null) {
            return;
        }
        int bytesRemaining = 0;
        if (buffer instanceof Buffer) {
            int elementsRemaining = ((Buffer)buffer).remaining();
            if (buffer instanceof ByteBuffer) {
                bytesRemaining = elementsRemaining;
            } else if (buffer instanceof FloatBuffer) {
                bytesRemaining = elementsRemaining * 4;
            } else if (buffer instanceof IntBuffer) {
                bytesRemaining = elementsRemaining * 4;
            } else if (buffer instanceof ShortBuffer) {
                bytesRemaining = elementsRemaining * 2;
            } else if (buffer instanceof DoubleBuffer) {
                bytesRemaining = elementsRemaining * 8;
            } else if (buffer instanceof LongBuffer) {
                bytesRemaining = elementsRemaining * 8;
            } else if (buffer instanceof CharBuffer) {
                bytesRemaining = elementsRemaining * 2;
            }
        } else if (buffer instanceof PointerBuffer) {
            bytesRemaining = ((PointerBuffer)buffer).remaining() * 8;
        }
        if (bytesRemaining < minBytesRemaining) {
            throw new IndexOutOfBoundsException("Required " + minBytesRemaining + " remaining bytes in buffer, only had " + bytesRemaining);
        }
    }

    static {
        ByteBuffer tst_b = BufferFactory.newDirectByteBuffer(4);
        IntBuffer tst_i = tst_b.asIntBuffer();
        ShortBuffer tst_s = tst_b.asShortBuffer();
        tst_i.put(0, 168496141);
        isLittleEndian = 3085 == tst_s.get(0);
    }
}

