/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram.types;

import com.sun.gluegen.cgram.types.Type;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TypeDictionary {
    private HashMap map = new HashMap();
    private HashMap reverseMap = new HashMap();
    private boolean reverseMapOutOfDate = false;

    public Type put(String name, Type type) {
        this.reverseMapOutOfDate = true;
        return this.map.put(name, type);
    }

    public Type get(String name) {
        return (Type)this.map.get(name);
    }

    public Set get(Type type) {
        if (this.reverseMapOutOfDate) {
            this.rebuildReverseMap();
            this.reverseMapOutOfDate = false;
        }
        return Collections.unmodifiableSet((Set)this.reverseMap.get(type));
    }

    public Type remove(String name) {
        this.reverseMapOutOfDate = true;
        return (Type)this.map.remove(name);
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Type value) {
        return this.map.containsValue(value);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Collection values() {
        return this.map.values();
    }

    private void rebuildReverseMap() {
        this.reverseMap.clear();
        for (String name : this.map.keySet()) {
            Type type = (Type)this.map.get(name);
            if (type == null) {
                throw new IllegalStateException("Internal error; TypedefDictionary contains null Type for name \"" + name + "\"");
            }
            HashSet<String> allNamesForType = (HashSet<String>)this.reverseMap.get(type);
            if (allNamesForType == null) {
                allNamesForType = new HashSet<String>();
                this.reverseMap.put(type, allNamesForType);
            }
            allNamesForType.add(name);
        }
    }

    public void dumpDictionary(PrintStream out, String description) {
        out.println("------------------------------------------------------------------------------");
        out.println("TypeDictionary: " + (description == null ? "" : description));
        out.println("------------------------------------------------------------------------------");
        out.println("Forward mapping: ");
        for (String typeName : this.keySet()) {
            out.println("  [" + typeName + "]\t--> [" + this.get(typeName) + "]");
        }
        out.println("Reverse mapping: ");
        if (this.reverseMapOutOfDate) {
            this.rebuildReverseMap();
            this.reverseMapOutOfDate = false;
        }
        for (Type type : this.reverseMap.keySet()) {
            Set names = this.get(type);
            out.println("  [" + type + "]\t--> " + names + "");
        }
        out.println("------------------------------------------------------------------------------");
    }
}

