/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram.types;

import com.sun.gluegen.cgram.types.MachineDescription;

public abstract class SizeThunk {
    public static final SizeThunk CHAR = new SizeThunk(){

        @Override
        public long compute(MachineDescription machDesc) {
            return machDesc.charSizeInBytes();
        }
    };
    public static final SizeThunk SHORT = new SizeThunk(){

        @Override
        public long compute(MachineDescription machDesc) {
            return machDesc.shortSizeInBytes();
        }
    };
    public static final SizeThunk INT = new SizeThunk(){

        @Override
        public long compute(MachineDescription machDesc) {
            return machDesc.intSizeInBytes();
        }
    };
    public static final SizeThunk LONG = new SizeThunk(){

        @Override
        public long compute(MachineDescription machDesc) {
            return machDesc.longSizeInBytes();
        }
    };
    public static final SizeThunk INT64 = new SizeThunk(){

        @Override
        public long compute(MachineDescription machDesc) {
            return machDesc.int64SizeInBytes();
        }
    };
    public static final SizeThunk FLOAT = new SizeThunk(){

        @Override
        public long compute(MachineDescription machDesc) {
            return machDesc.floatSizeInBytes();
        }
    };
    public static final SizeThunk DOUBLE = new SizeThunk(){

        @Override
        public long compute(MachineDescription machDesc) {
            return machDesc.doubleSizeInBytes();
        }
    };
    public static final SizeThunk POINTER = new SizeThunk(){

        @Override
        public long compute(MachineDescription machDesc) {
            return machDesc.pointerSizeInBytes();
        }
    };

    private SizeThunk() {
    }

    public abstract long compute(MachineDescription var1);

    public static SizeThunk add(final SizeThunk thunk1, final SizeThunk thunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machDesc) {
                return thunk1.compute(machDesc) + thunk2.compute(machDesc);
            }
        };
    }

    public static SizeThunk sub(final SizeThunk thunk1, final SizeThunk thunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machDesc) {
                return thunk1.compute(machDesc) - thunk2.compute(machDesc);
            }
        };
    }

    public static SizeThunk mul(final SizeThunk thunk1, final SizeThunk thunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machDesc) {
                return thunk1.compute(machDesc) * thunk2.compute(machDesc);
            }
        };
    }

    public static SizeThunk mod(final SizeThunk thunk1, final SizeThunk thunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machDesc) {
                return thunk1.compute(machDesc) % thunk2.compute(machDesc);
            }
        };
    }

    public static SizeThunk roundUp(final SizeThunk thunk1, final SizeThunk thunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machDesc) {
                long sz2;
                long sz1 = thunk1.compute(machDesc);
                long rem = sz1 % (sz2 = thunk2.compute(machDesc));
                if (rem == 0L) {
                    return sz1;
                }
                return sz1 + (sz2 - rem);
            }
        };
    }

    public static SizeThunk max(final SizeThunk thunk1, final SizeThunk thunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machDesc) {
                return Math.max(thunk1.compute(machDesc), thunk2.compute(machDesc));
            }
        };
    }

    public static SizeThunk constant(final int constant) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machDesc) {
                return constant;
            }
        };
    }
}

