/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram.types;

import com.sun.gluegen.cgram.types.IntType;
import com.sun.gluegen.cgram.types.SizeThunk;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class EnumType
extends IntType {
    private IntType underlyingType;
    private List enums;

    public EnumType(String name) {
        super(name, SizeThunk.LONG, false, 1);
        this.underlyingType = new IntType(name, SizeThunk.LONG, false, 1);
    }

    public EnumType(String name, SizeThunk enumSizeInBytes) {
        super(name, enumSizeInBytes, false, 1);
        this.underlyingType = new IntType(name, enumSizeInBytes, false, 1);
    }

    protected EnumType(String name, IntType underlyingType, int cvAttributes) {
        super(name, underlyingType.getSize(), underlyingType.isUnsigned(), cvAttributes);
        this.underlyingType = underlyingType;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof EnumType)) {
            return false;
        }
        EnumType t = (EnumType)arg;
        return super.equals(arg) && this.underlyingType.equals(t.underlyingType) && EnumType.listsEqual(this.enums, t.enums);
    }

    @Override
    public EnumType asEnum() {
        return this;
    }

    public void addEnum(String name, long val) {
        if (this.enums == null) {
            this.enums = new ArrayList();
        }
        this.enums.add(new Enum(name, val));
    }

    public int getNumEnumerates() {
        return this.enums.size();
    }

    public String getEnumName(int i) {
        return ((Enum)this.enums.get(i)).getName();
    }

    public long getEnumValue(int i) {
        return ((Enum)this.enums.get(i)).getValue();
    }

    public long getEnumValue(String name) {
        for (int i = 0; i < this.enums.size(); ++i) {
            Enum n = (Enum)this.enums.get(i);
            if (!n.getName().equals(name)) continue;
            return n.getValue();
        }
        throw new NoSuchElementException("No enumerate named \"" + name + "\" in EnumType \"" + this.getName() + "\"");
    }

    public boolean containsEnumerate(String name) {
        for (int i = 0; i < this.enums.size(); ++i) {
            if (!((Enum)this.enums.get(i)).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean removeEnumerate(String name) {
        for (int i = 0; i < this.enums.size(); ++i) {
            Enum e = (Enum)this.enums.get(i);
            if (!e.getName().equals(name)) continue;
            this.enums.remove(e);
            return true;
        }
        return false;
    }

    @Override
    public void visit(TypeVisitor arg) {
        super.visit(arg);
        this.underlyingType.visit(arg);
    }

    @Override
    Type newCVVariant(int cvAttributes) {
        EnumType t = new EnumType(this.getName(), this.underlyingType, cvAttributes);
        t.enums = this.enums;
        return t;
    }

    private static class Enum {
        String name;
        long value;

        Enum(String name, long value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        long getValue() {
            return this.value;
        }
    }
}

