/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.cgram.types;

import com.sun.gluegen.cgram.types.CompoundTypeKind;
import com.sun.gluegen.cgram.types.Field;
import com.sun.gluegen.cgram.types.SizeThunk;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;

public class CompoundType
extends Type {
    private CompoundTypeKind kind;
    private String structName;
    private ArrayList fields;
    private boolean visiting;
    private boolean bodyParsed;
    private boolean computedHashcode;
    private int hashcode;

    public CompoundType(String name, SizeThunk size, CompoundTypeKind kind, int cvAttributes) {
        this(name, size, kind, cvAttributes, null);
    }

    private CompoundType(String name, SizeThunk size, CompoundTypeKind kind, int cvAttributes, String structName) {
        super(name, size, cvAttributes);
        assert (kind != null);
        this.kind = kind;
        this.structName = structName;
    }

    @Override
    public int hashCode() {
        if (this.computedHashcode) {
            return this.hashcode;
        }
        this.hashcode = this.structName != null ? this.structName.hashCode() : (this.getName() != null ? this.getName().hashCode() : 0);
        this.computedHashcode = true;
        return this.hashcode;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof CompoundType)) {
            return false;
        }
        CompoundType t = (CompoundType)arg;
        return super.equals(arg) && (this.structName == t.structName || this.structName != null && this.structName.equals(t.structName)) && this.kind == t.kind && CompoundType.listsEqual(this.fields, t.fields);
    }

    public String getStructName() {
        return this.structName;
    }

    public void setStructName(String structName) {
        this.structName = structName;
    }

    @Override
    public void setSize(SizeThunk size) {
        super.setSize(size);
    }

    @Override
    public CompoundType asCompound() {
        return this;
    }

    public int getNumFields() {
        return this.fields == null ? 0 : this.fields.size();
    }

    public Field getField(int i) {
        return (Field)this.fields.get(i);
    }

    public void addField(Field f) {
        if (this.bodyParsed) {
            throw new RuntimeException("Body of this CompoundType has already been parsed; should not be adding more fields");
        }
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(f);
    }

    public void setBodyParsed() {
        this.bodyParsed = true;
    }

    public boolean isStruct() {
        return this.kind == CompoundTypeKind.STRUCT;
    }

    public boolean isUnion() {
        return this.kind == CompoundTypeKind.UNION;
    }

    @Override
    public String toString() {
        String cvAttributesString = this.getCVAttributesString();
        if (this.getName() != null) {
            return cvAttributesString + this.getName();
        }
        if (this.getStructName() != null) {
            return cvAttributesString + "struct " + this.getStructName();
        }
        return cvAttributesString + this.getStructString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(TypeVisitor arg) {
        if (this.visiting) {
            return;
        }
        try {
            this.visiting = true;
            super.visit(arg);
            int n = this.getNumFields();
            for (int i = 0; i < n; ++i) {
                Field f = this.getField(i);
                f.getType().visit(arg);
            }
        }
        finally {
            this.visiting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStructString() {
        if (this.visiting) {
            if (this.getName() != null) {
                return this.getName();
            }
            return "struct {/*Recursive type reference*/}";
        }
        try {
            this.visiting = true;
            String kind = this.isStruct() ? "struct {" : "union {";
            StringBuffer res = new StringBuffer();
            res.append(kind);
            int n = this.getNumFields();
            for (int i = 0; i < n; ++i) {
                res.append(" ");
                res.append(this.getField(i));
            }
            res.append(" }");
            String string = res.toString();
            return string;
        }
        finally {
            this.visiting = false;
        }
    }

    @Override
    Type newCVVariant(int cvAttributes) {
        CompoundType t = new CompoundType(this.getName(), this.getSize(), this.kind, cvAttributes, this.structName);
        t.fields = this.fields;
        return t;
    }
}

