(ns hara.code.block
  (:require [hara.module :as module]
            [hara.code.block.base :as base]
            [hara.code.block.construct :as construct]
            [hara.code.block.grid :as grid]
            [hara.code.block.parse :as parse]
            [hara.code.query :as query]
            [hara.code.block.type :as type]
            [hara.core.zip :as zip])
  (:refer-clojure :exclude [type next replace string newline comment]))

(module/include
 
 (hara.code.block.base block?
                       expression?
                       (type       < block-type)
                       (tag        < block-tag) 
                       (string     < block-string)
                       (length     < block-length)
                       (width      < block-width)
                       (height     < block-height)
                       (prefixed   < block-prefixed)
                       (suffixed   < block-suffixed)
                       (verify     < block-verify)
                       (value      < block-value)
                       (value-string < block-value-string)
                       (children   < block-children)
                       (info       < block-info))
 
 (hara.code.block.construct block
                            void
                            space
                            spaces
                            newline
                            newlines
                            tab
                            tabs
                            comment
                            uneval
                            cursor
                            contents
                            container
                            root)
 
 (hara.code.block.parse parse-string
                        parse-root)
 
 (hara.code.block.type (void?      < void-block?)
                       (space?     < space-block?)
                       (linebreak? < linebreak-block?)
                       (linespace? < linespace-block?)
                       (eof?       < eof-block?)
                       (comment?   < comment-block?)
                       (token?     < token-block?)
                       (container? < container-block?)
                       (modifier?  < modifier-block?)))
