/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Counted;
import clojure.lang.IFn;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentStack;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Indexed;
import clojure.lang.RT;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ROVec
implements IPersistentList,
IReduce,
Counted,
Indexed,
ISeq {
    public static final byte[] empty_arr = new byte[0];
    public static final ROVec EMPTY = new ROVec(empty_arr);
    public final byte[] arr;
    public final int start;
    public final int end;
    public final int length;

    public ROVec(byte[] byArray) {
        this(byArray, 0);
    }

    public ROVec(byte[] byArray, int n) {
        this(byArray, n, byArray.length);
    }

    public ROVec(byte[] byArray, int n, int n2) {
        this.arr = byArray;
        this.start = n;
        this.end = n2;
        this.length = n2 - n;
        if (n < 0 || n > byArray.length || n2 > byArray.length || n > n2) {
            throw new IndexOutOfBoundsException(this.toString());
        }
    }

    public ROVec(ROVec rOVec, int n) {
        this(rOVec, n, rOVec.length);
    }

    public ROVec(ROVec rOVec, int n, int n2) {
        this.arr = rOVec.arr;
        this.start = rOVec.start + n;
        this.end = rOVec.start + n2;
        this.length = n2 - n;
        if (n < 0 || n > rOVec.length || n2 > rOVec.length || n > n2) {
            throw new IndexOutOfBoundsException(this.toString());
        }
    }

    public Object nth(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException(this.toString());
        }
        return this.arr[this.start + n];
    }

    public Object nth(int n, Object object) {
        if (n < 0 || n >= this.length) {
            return object;
        }
        return this.arr[this.start + n];
    }

    public int count() {
        return this.length;
    }

    public Object first() {
        return this.nth(0, null);
    }

    public ISeq next() {
        if (this.length <= 1) {
            return null;
        }
        return new ROVec(this, 1);
    }

    public ISeq more() {
        return this.next();
    }

    public ISeq cons(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object peek() {
        return this.nth(0);
    }

    public IPersistentStack pop() {
        return new ROVec(this, 1);
    }

    public ISeq empty() {
        return EMPTY;
    }

    static boolean doEquiv(ROVec rOVec, Object object) {
        if (object instanceof ROVec) {
            ROVec rOVec2 = (ROVec)object;
            if (rOVec2.count() != rOVec.count()) {
                return false;
            }
            for (int i = 0; i < rOVec.count(); ++i) {
                if (Util.equiv((Object)rOVec.nth(i), (Object)rOVec2.nth(i))) continue;
                return false;
            }
            return true;
        }
        if (object instanceof List) {
            Collection collection = (Collection)object;
            if (collection.size() != rOVec.count()) {
                return false;
            }
            Iterator iterator = ((List)((Object)rOVec)).iterator();
            Iterator iterator2 = collection.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (Util.equiv(iterator.next(), iterator2.next()));
            return false;
        }
        if (!(object instanceof Sequential)) {
            return false;
        }
        ISeq iSeq = RT.seq((Object)object);
        int n = 0;
        while (n < rOVec.count()) {
            if (iSeq == null || !Util.equiv((Object)rOVec.nth(n), (Object)iSeq.first())) {
                return false;
            }
            ++n;
            iSeq = iSeq.next();
        }
        return iSeq == null;
    }

    public boolean equiv(Object object) {
        return object == this ? true : ROVec.doEquiv(this, object);
    }

    public ISeq seq() {
        if (this.length == 0) {
            return null;
        }
        return this;
    }

    public String toString() {
        return String.format("clojure.lang.ROVec([B(%d), %d, %d)", this.arr.length, this.start, this.end);
    }

    public Object reduce(IFn iFn) {
        Object object = this.nth(0);
        for (int i = 1; i < this.length; ++i) {
            object = iFn.invoke(object, this.nth(i));
        }
        return object;
    }

    public Object reduce(IFn iFn, Object object) {
        Object object2 = object;
        for (int i = 0; i < this.length; ++i) {
            object2 = iFn.invoke(object2, this.nth(i));
        }
        return object2;
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[]{};
        ROVec rOVec = new ROVec(byArray);
    }
}

