/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.tools.internal;

import clojure.lang.IFn;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class LineProcessingWriter
extends FilterWriter {
    private final IFn processor;
    private StringBuilder builder;
    private int position;

    public LineProcessingWriter(Writer out, IFn processor) {
        super(out);
        this.processor = processor;
        this.builder = new StringBuilder(1024);
        this.position = 0;
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        this.builder.append(c);
        this.process(false);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(cbuf, off, len);
        this.builder.append(cbuf, off, len);
        this.process(false);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        this.builder.append(str, off, len);
        this.process(false);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.process(true);
    }

    private void process(boolean endOfInput) throws IOException {
        int lineEnding = this.builder.indexOf("\n", this.position);
        while (lineEnding >= 0) {
            this.processor.invoke((Object)this.builder.substring(0, lineEnding));
            this.builder.delete(0, lineEnding + System.lineSeparator().length());
            this.position = this.builder.length();
            lineEnding = this.builder.indexOf(System.lineSeparator(), this.position);
            this.flush();
        }
        if (endOfInput && this.builder.length() > 0) {
            this.processor.invoke((Object)this.builder.toString());
            this.builder.setLength(0);
            this.flush();
        }
        this.position = this.builder.length();
    }
}

