/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.ClojureBuild;
import dev.clojurephant.plugin.clojure.tasks.ClojureCompileOptions;
import dev.clojurephant.plugin.clojurescript.ClojureScriptBuild;
import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import dev.clojurephant.plugin.clojurescript.tasks.FigwheelOptions;
import dev.clojurephant.plugin.clojurescript.tasks.ForeignLib;
import dev.clojurephant.plugin.clojurescript.tasks.Module;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import us.bpsm.edn.Keyword;
import us.bpsm.edn.Symbol;
import us.bpsm.edn.parser.Parseable;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;
import us.bpsm.edn.printer.Printer;
import us.bpsm.edn.printer.Printers;
import us.bpsm.edn.protocols.Protocol;

public class Edn {
    private static final Printer.Fn<Enum<?>> ENUM_PRINTER = (self, printer) -> printer.printValue((Object)Keyword.newKeyword((String)self.name()));
    private static final Printer.Fn<File> FILE_PRINTER = (self, printer) -> printer.printValue((Object)self.getAbsolutePath());
    private static final Printer.Fn<RegularFile> REGULAR_FILE_PRINTER = (self, printer) -> printer.printValue((Object)self.getAsFile());
    private static final Printer.Fn<Directory> DIRECTORY_PRINTER = (self, printer) -> printer.printValue((Object)self.getAsFile());
    private static final Printer.Fn<FileCollection> FILE_COLLECTION_PRINTER = (self, printer) -> {
        List list = self.getFiles().stream().filter(File::exists).collect(Collectors.toList());
        printer.printValue(list);
    };
    private static final Printer.Fn<NamedDomainObjectCollection<?>> NAMED_DOMAIN_PRINTER = (self, printer) -> printer.printValue(self.isEmpty() ? null : Edn.keywordize(self.getAsMap()));
    private static final Printer.Fn<Provider<?>> PROVIDER_PRINTER = (self, printer) -> printer.printValue(self.getOrNull());
    private static final Printer.Fn<ClojureCompileOptions> CLOJURE_COMPILE_OPTIONS_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> root = new LinkedHashMap<Keyword, Object>();
        root.put(Keyword.newKeyword((String)"disable-locals-clearing"), self.getDisableLocalsClearing().get());
        root.put(Keyword.newKeyword((String)"direct-linking"), self.getDirectLinking().get());
        root.put(Keyword.newKeyword((String)"elide-metadata"), ((List)self.getElideMeta().get()).stream().map(Keyword::newKeyword).collect(Collectors.toList()));
        printer.printValue(root);
    };
    private static final Printer.Fn<ClojureBuild> CLOJURE_BUILD_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> root = new LinkedHashMap<Keyword, Object>();
        root.put(Keyword.newKeyword((String)"name"), self.getName());
        root.put(Keyword.newKeyword((String)"compiler"), self.getCompiler());
        printer.printValue(root);
    };
    private static final Printer.Fn<ClojureScriptBuild> CLOJURESCRIPT_BUILD_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> root = new LinkedHashMap<Keyword, Object>();
        root.put(Keyword.newKeyword((String)"name"), self.getName());
        root.put(Keyword.newKeyword((String)"source-paths"), self.getSourceRoots());
        root.put(Keyword.newKeyword((String)"output-dir"), self.getOutputDir().map(Directory::getAsFile).getOrNull());
        root.put(Keyword.newKeyword((String)"compiler"), self.getCompiler());
        root.put(Keyword.newKeyword((String)"figwheel"), self.getFigwheel());
        printer.printValue(root);
    };
    private static final Printer.Fn<ClojureScriptCompileOptions> CLOJURESCRIPT_COMPILE_OPTIONS_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"output-to"), self.getBaseOutputDirectory().file(self.getOutputTo()).map(RegularFile::getAsFile).getOrNull());
        map.put(Keyword.newKeyword((String)"output-dir"), self.getBaseOutputDirectory().dir(self.getOutputDir()).map(Directory::getAsFile).getOrNull());
        map.put(Keyword.newKeyword((String)"optimizations"), self.getOptimizations().map(Keyword::newKeyword));
        map.put(Keyword.newKeyword((String)"main"), self.getMain().getOrNull());
        map.put(Keyword.newKeyword((String)"asset-path"), self.getAssetPath().getOrNull());
        map.put(Keyword.newKeyword((String)"source-map"), self.getSourceMap().map(sourceMap -> {
            if (sourceMap instanceof String) {
                return ((RegularFile)self.getBaseOutputDirectory().file((String)sourceMap).get()).getAsFile();
            }
            return sourceMap;
        }));
        map.put(Keyword.newKeyword((String)"verbose"), self.getVerbose().getOrNull());
        map.put(Keyword.newKeyword((String)"pretty-print"), self.getPrettyPrint().getOrNull());
        map.put(Keyword.newKeyword((String)"target"), self.getTarget().map(Keyword::newKeyword));
        map.put(Keyword.newKeyword((String)"foreign-libs"), self.getForeignLibs().getAsMap().values());
        map.put(Keyword.newKeyword((String)"externs"), self.getExterns().getOrNull());
        map.put(Keyword.newKeyword((String)"modules"), Edn.parseModules(self.getModules().getAsMap()));
        map.put(Keyword.newKeyword((String)"preloads"), Edn.parsePreloads((Collection)self.getPreloads().getOrNull()));
        map.put(Keyword.newKeyword((String)"npm-deps"), self.getNpmDeps().getOrNull());
        map.put(Keyword.newKeyword((String)"install-deps"), self.getInstallDeps().getOrNull());
        map.put(Keyword.newKeyword((String)"checked-arrays"), self.getCheckedArrays().map(Keyword::newKeyword));
        Edn.removeEmptyAndNulls(map);
        printer.printValue(map);
    };
    private static final Printer.Fn<ForeignLib> FOREIGN_LIB_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"file"), self.getFile());
        map.put(Keyword.newKeyword((String)"file-min"), self.getFileMin());
        map.put(Keyword.newKeyword((String)"provides"), self.getProvides().getOrNull());
        map.put(Keyword.newKeyword((String)"requires"), self.getRequires().getOrNull());
        map.put(Keyword.newKeyword((String)"module-type"), self.getModuleType().map(Keyword::newKeyword));
        map.put(Keyword.newKeyword((String)"preprocess"), Edn.parsePreprocess((String)self.getPreprocess().getOrNull()));
        map.put(Keyword.newKeyword((String)"global-exports"), Edn.parseGlobalExports((Map)self.getGlobalExports().getOrNull()));
        Edn.removeEmptyAndNulls(map);
        printer.printValue(map);
    };
    private static final Printer.Fn<Module> MODULE_PRINTER = (module, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"output-to"), module.getBaseOutputDirectory().file(module.getOutputTo()).map(RegularFile::getAsFile).getOrNull());
        map.put(Keyword.newKeyword((String)"entries"), module.getEntries().getOrNull());
        map.put(Keyword.newKeyword((String)"dependsOn"), module.getDependsOn().getOrNull());
        Edn.removeEmptyAndNulls(map);
        printer.printValue(map);
    };
    private static final Printer.Fn<FigwheelOptions> FIGWHEEL_PRINTER = (figwheel, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"target-dir"), figwheel.getTargetDir());
        map.put(Keyword.newKeyword((String)"watch-dirs"), figwheel.getWatchDirs());
        map.put(Keyword.newKeyword((String)"css-dirs"), figwheel.getCssDirs());
        map.put(Keyword.newKeyword((String)"ring-handler"), figwheel.getRingHandler());
        map.put(Keyword.newKeyword((String)"ring-server-options"), figwheel.getRingServerOptions());
        map.put(Keyword.newKeyword((String)"rebel-readline"), figwheel.getRebelReadline());
        map.put(Keyword.newKeyword((String)"pprint-config"), figwheel.getPprintConfig());
        map.put(Keyword.newKeyword((String)"open-file-command"), figwheel.getOpenFileCommand());
        map.put(Keyword.newKeyword((String)"figwheel-core"), figwheel.getFigwheelCore());
        map.put(Keyword.newKeyword((String)"hot-reload-cljs"), figwheel.getHotReloadCljs());
        map.put(Keyword.newKeyword((String)"connect-url"), figwheel.getConnectUrl());
        map.put(Keyword.newKeyword((String)"open-url"), figwheel.getOpenUrl());
        map.put(Keyword.newKeyword((String)"reload-clj-files"), figwheel.getReloadCljFiles());
        map.put(Keyword.newKeyword((String)"log-file"), figwheel.getLogFile());
        map.put(Keyword.newKeyword((String)"log-level"), figwheel.getLogLevel());
        map.put(Keyword.newKeyword((String)"client-log-level"), figwheel.getClientLogLevel());
        map.put(Keyword.newKeyword((String)"log-syntax-error-style"), figwheel.getLogSyntaxErrorStyle());
        map.put(Keyword.newKeyword((String)"load-warninged-code"), figwheel.getLoadWarningedCode());
        map.put(Keyword.newKeyword((String)"ansi-color-output"), figwheel.getAnsiColorOutput());
        map.put(Keyword.newKeyword((String)"validate-config"), figwheel.getValidateConfig());
        map.put(Keyword.newKeyword((String)"validate-cli"), figwheel.getValidateCli());
        map.put(Keyword.newKeyword((String)"launch-node"), figwheel.getLaunchNode());
        map.put(Keyword.newKeyword((String)"inspect-node"), figwheel.getInspectNode());
        map.put(Keyword.newKeyword((String)"node-command"), figwheel.getNodeCommand());
        map.put(Keyword.newKeyword((String)"launch-js"), figwheel.getLaunchJs());
        map.put(Keyword.newKeyword((String)"cljs-devtools"), figwheel.getCljsDevtools());
        map.put(Keyword.newKeyword((String)"helpful-classpaths"), figwheel.getHelpfulClasspaths());
        Edn.removeEmptyAndNulls(map);
        printer.printValue(map);
    };
    private static final Protocol<Printer.Fn<?>> PROTOCOL = Printers.prettyProtocolBuilder().put(Enum.class, ENUM_PRINTER).put(File.class, FILE_PRINTER).put(RegularFile.class, REGULAR_FILE_PRINTER).put(Directory.class, DIRECTORY_PRINTER).put(FileCollection.class, FILE_COLLECTION_PRINTER).put(NamedDomainObjectCollection.class, NAMED_DOMAIN_PRINTER).put(Provider.class, PROVIDER_PRINTER).put(ClojureCompileOptions.class, CLOJURE_COMPILE_OPTIONS_PRINTER).put(ClojureBuild.class, CLOJURE_BUILD_PRINTER).put(ClojureScriptBuild.class, CLOJURESCRIPT_BUILD_PRINTER).put(ClojureScriptCompileOptions.class, CLOJURESCRIPT_COMPILE_OPTIONS_PRINTER).put(ForeignLib.class, FOREIGN_LIB_PRINTER).put(Module.class, MODULE_PRINTER).put(FigwheelOptions.class, FIGWHEEL_PRINTER).build();

    private static Map<Keyword, Module> parseModules(Map<String, Module> modules) {
        return modules.entrySet().stream().collect(Collectors.toMap(e -> Keyword.newKeyword((String)((String)e.getKey())), Map.Entry::getValue));
    }

    private static List<?> parsePreloads(Collection<String> preloads) {
        if (preloads == null) {
            return null;
        }
        return preloads.stream().map(Symbol::newSymbol).collect(Collectors.toList());
    }

    private static Object parsePreprocess(String value) {
        if (value == null) {
            return null;
        }
        Parseable parseable = Parsers.newParseable((CharSequence)value);
        Parser parser = Parsers.newParser((Parser.Config)Parsers.defaultConfiguration());
        return parser.nextValue(parseable);
    }

    private static Map<Symbol, Symbol> parseGlobalExports(Map<String, String> globalExports) {
        return globalExports.entrySet().stream().collect(Collectors.toMap(e -> Symbol.newSymbol((String)((String)e.getKey())), e -> Symbol.newSymbol((String)((String)e.getValue()))));
    }

    public static String print(Object value) {
        return Printers.printString(PROTOCOL, (Object)value);
    }

    public static <V> Map<Keyword, V> keywordize(Map<String, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> Keyword.newKeyword((String)((String)e.getKey())), e -> e.getValue()));
    }

    private static <K, V> void removeEmptyAndNulls(Map<K, V> map) {
        map.values().removeIf(Objects::isNull);
        map.values().removeIf(obj -> obj instanceof Provider && !((Provider)obj).isPresent());
        map.values().removeIf(obj -> obj instanceof Collection && ((Collection)obj).isEmpty());
        map.values().removeIf(obj -> obj instanceof Map && ((Map)obj).isEmpty());
        map.values().removeIf(obj -> obj instanceof FileCollection && ((FileCollection)obj).isEmpty());
    }

    public static List<Object> list(Object ... elements) {
        return Arrays.stream(elements).collect(Collectors.toCollection(LinkedList::new));
    }

    public static List<Object> vector(Object ... elements) {
        return Arrays.stream(elements).collect(Collectors.toCollection(ArrayList::new));
    }
}

