/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RelativePath;
import org.gradle.api.provider.Provider;

public final class Namespaces {
    public static final Set<String> CLOJURE_PATTERNS = Collections.unmodifiableSet(Stream.of("**/*.clj", "**/*.cljc").collect(Collectors.toSet()));
    public static final Set<String> CLOJURESCRIPT_PATTERNS = Collections.unmodifiableSet(Stream.of("**/*.cljs", "**/*.cljc", "**/*.clj").collect(Collectors.toSet()));
    private static final Map<Character, String> CHAR_MAP = new HashMap<Character, String>();
    private static final Map<String, Character> DEMUNGE_MAP;
    private static final Pattern DEMUNGE_PATTERN;

    private Namespaces() {
    }

    public static Provider<Set<String>> findNamespaces(FileTree source) {
        return source.getElements().map(files -> {
            HashSet namespaces = new HashSet();
            source.visit(details -> {
                if (details.isDirectory()) {
                    return;
                }
                RelativePath relPath = details.getRelativePath();
                String fileBaseName = relPath.getLastName().substring(0, relPath.getLastName().lastIndexOf(46));
                if (fileBaseName.equals("data_readers")) {
                    return;
                }
                RelativePath relPathNoExt = relPath.replaceLastName(fileBaseName);
                String namespace = Arrays.stream(relPathNoExt.getSegments()).map(Namespaces::demunge).collect(Collectors.joining("."));
                namespaces.add(namespace);
            });
            return namespaces;
        });
    }

    private static String demunge(String mungedName) {
        StringBuilder sb = new StringBuilder();
        Matcher m = DEMUNGE_PATTERN.matcher(mungedName);
        int lastMatchEnd = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            sb.append(mungedName.substring(lastMatchEnd, start));
            lastMatchEnd = end;
            char origCh = DEMUNGE_MAP.get(m.group()).charValue();
            sb.append(origCh);
        }
        sb.append(mungedName.substring(lastMatchEnd));
        return sb.toString();
    }

    static {
        CHAR_MAP.put(Character.valueOf('-'), "_");
        CHAR_MAP.put(Character.valueOf(':'), "_COLON_");
        CHAR_MAP.put(Character.valueOf('+'), "_PLUS_");
        CHAR_MAP.put(Character.valueOf('>'), "_GT_");
        CHAR_MAP.put(Character.valueOf('<'), "_LT_");
        CHAR_MAP.put(Character.valueOf('='), "_EQ_");
        CHAR_MAP.put(Character.valueOf('~'), "_TILDE_");
        CHAR_MAP.put(Character.valueOf('!'), "_BANG_");
        CHAR_MAP.put(Character.valueOf('@'), "_CIRCA_");
        CHAR_MAP.put(Character.valueOf('#'), "_SHARP_");
        CHAR_MAP.put(Character.valueOf('\''), "_SINGLEQUOTE_");
        CHAR_MAP.put(Character.valueOf('\"'), "_DOUBLEQUOTE_");
        CHAR_MAP.put(Character.valueOf('%'), "_PERCENT_");
        CHAR_MAP.put(Character.valueOf('^'), "_CARET_");
        CHAR_MAP.put(Character.valueOf('&'), "_AMPERSAND_");
        CHAR_MAP.put(Character.valueOf('*'), "_STAR_");
        CHAR_MAP.put(Character.valueOf('|'), "_BAR_");
        CHAR_MAP.put(Character.valueOf('{'), "_LBRACE_");
        CHAR_MAP.put(Character.valueOf('}'), "_RBRACE_");
        CHAR_MAP.put(Character.valueOf('['), "_LBRACK_");
        CHAR_MAP.put(Character.valueOf(']'), "_RBRACK_");
        CHAR_MAP.put(Character.valueOf('/'), "_SLASH_");
        CHAR_MAP.put(Character.valueOf('\\'), "_BSLASH_");
        CHAR_MAP.put(Character.valueOf('?'), "_QMARK_");
        DEMUNGE_MAP = CHAR_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        DEMUNGE_PATTERN = Pattern.compile(DEMUNGE_MAP.keySet().stream().sorted(Comparator.comparingInt(String::length).reversed()).map(it -> "\\Q" + it + "\\E").collect(Collectors.joining("|")));
    }
}

