/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.tasks.ClojureNRepl;
import dev.clojurephant.plugin.common.internal.ClojureCommonBasePlugin;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ComponentModuleMetadataDetails;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;

public class ClojureCommonPlugin
implements Plugin<Project> {
    public static final String DEV_SOURCE_SET_NAME = "dev";
    public static final String NREPL_CONFIGURATION_NAME = "nrepl";
    public static final String NREPL_TASK_NAME = "clojureRepl";

    public void apply(Project project) {
        project.getPlugins().apply(ClojureCommonBasePlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        this.configureDev(project, sourceSets);
        this.configureDependencyConstraints(project.getDependencies());
    }

    private void configureDev(Project project, SourceSetContainer sourceSets) {
        SourceSet main = (SourceSet)sourceSets.getByName("main");
        SourceSet test = (SourceSet)sourceSets.getByName("test");
        SourceSet dev = (SourceSet)sourceSets.create(DEV_SOURCE_SET_NAME);
        Configuration nrepl = project.getConfigurations().getByName(NREPL_CONFIGURATION_NAME);
        project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{nrepl});
        project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{nrepl});
        Function<SourceSet, FileCollection> clojureSources = sourceSet -> {
            SourceDirectorySet clojureScript;
            ConfigurableFileCollection result = project.files(new Object[0]);
            SourceDirectorySet clojure = (SourceDirectorySet)sourceSet.getExtensions().findByName("clojure");
            if (clojure != null) {
                result.from(new Object[]{clojure.getSourceDirectories()});
            }
            if ((clojureScript = (SourceDirectorySet)sourceSet.getExtensions().findByName("clojurescript")) != null) {
                result.from(new Object[]{clojureScript.getSourceDirectories()});
            }
            result.from(new Object[]{sourceSet.getResources().getSourceDirectories()});
            return result;
        };
        dev.setCompileClasspath((FileCollection)project.files(new Object[]{clojureSources.apply(test), clojureSources.apply(main), main.getJava().getClassesDirectory(), project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName())}));
        dev.setRuntimeClasspath((FileCollection)project.files(new Object[]{clojureSources.apply(dev), clojureSources.apply(test), clojureSources.apply(main), main.getJava().getClassesDirectory(), project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName())}));
        Consumer<Function> devExtendsTest = getConfName -> {
            Configuration devConf = project.getConfigurations().getByName((String)getConfName.apply(dev));
            Configuration testConf = project.getConfigurations().getByName((String)getConfName.apply(test));
            devConf.extendsFrom(new Configuration[]{testConf});
        };
        devExtendsTest.accept(SourceSet::getImplementationConfigurationName);
        devExtendsTest.accept(SourceSet::getRuntimeOnlyConfigurationName);
        TaskProvider repl = project.getTasks().register(NREPL_TASK_NAME, ClojureNRepl.class, task -> {
            task.setGroup("run");
            task.setDescription("Starts an nREPL server.");
            task.getClasspath().from(new Object[]{dev.getRuntimeClasspath()});
        });
    }

    private void configureDependencyConstraints(DependencyHandler dependencies) {
        dependencies.getModules().module((Object)"org.clojure:tools.nrepl", module -> {
            ComponentModuleMetadataDetails details = module;
            details.replacedBy((Object)"nrepl:nrepl", "nREPL was moved out of Clojure Contrib to its own project.");
        });
        if (JavaVersion.current().isJava9Compatible()) {
            dependencies.constraints(constraints -> {
                constraints.add("devImplementation", (Object)"org.clojure:java.classpath:0.3.0", constraint -> constraint.because("Java 9 has a different classloader architecture. 0.3.0 adds support for this."));
                constraints.add("devRuntimeOnly", (Object)"org.clojure:java.classpath:0.3.0", constraint -> constraint.because("Java 9 has a different classloader architecture. 0.3.0 adds support for this."));
            });
        }
    }
}

