/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojurescript.tasks;

import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import dev.clojurephant.plugin.common.internal.ClojureException;
import dev.clojurephant.plugin.common.internal.Edn;
import dev.clojurephant.plugin.common.internal.Prepl;
import dev.clojurephant.plugin.common.internal.PreplClient;
import dev.clojurephant.plugin.common.internal.PreplSpec;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaForkOptions;
import us.bpsm.edn.Symbol;

public abstract class ClojureScriptCompile
extends DefaultTask {
    private final Prepl prepl;

    @Inject
    public ClojureScriptCompile(ExecOperations execOperations) {
        this.prepl = new Prepl(execOperations);
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    public abstract FileTree getSource();

    public abstract void setSource(FileTree var1);

    @OutputDirectory
    public abstract DirectoryProperty getDestinationDir();

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Nested
    public abstract Property<ClojureScriptCompileOptions> getOptions();

    @Nested
    public abstract ForkOptions getForkOptions();

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @TaskAction
    public void compile() {
        File outputDir = ((Directory)this.getDestinationDir().get()).getAsFile();
        this.getFileSystemOperations().delete(spec -> spec.delete(new Object[]{outputDir}));
        if (!outputDir.mkdirs()) {
            throw new GradleException("Cannot create destination directory: " + outputDir.getAbsolutePath());
        }
        PreplClient preplClient = this.prepl.start((Action<PreplSpec>)((Action)spec -> {
            spec.setClasspath((FileCollection)this.getClasspath());
            spec.setPort(0);
            spec.forkOptions((Action<JavaForkOptions>)((Action)fork -> {
                fork.setJvmArgs(this.getForkOptions().getJvmArgs());
                fork.setMinHeapSize(this.getForkOptions().getMemoryInitialSize());
                fork.setMaxHeapSize(this.getForkOptions().getMemoryMaximumSize());
                fork.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
            }));
        }));
        boolean failures = false;
        try (PreplClient p = preplClient;){
            preplClient.evalEdn("(require '[cljs.build.api :as api])");
            List<Object> form = Edn.list(Symbol.newSymbol((String)"api", (String)"build"), Edn.list(Symbol.newSymbol((String)"apply"), Symbol.newSymbol((String)"api", (String)"inputs"), this.getSource()), this.getOptions());
            preplClient.evalData(form);
            preplClient.evalEdn("(.flush *err*)");
        }
        catch (ClojureException e) {
            System.err.println(e.getMessage());
            failures = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        preplClient.pollOutput().forEach(System.out::println);
        if (failures) {
            throw new GradleException("Compilation failed. See output above.");
        }
    }
}

