/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure;

import dev.clojurephant.plugin.clojure.tasks.ClojureCompileOptions;
import dev.clojurephant.plugin.common.internal.Namespaces;
import java.util.Set;
import org.apache.commons.text.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.classpath.Instrumented;

public abstract class ClojureBuild
implements Named {
    public abstract DirectoryProperty getOutputDir();

    public abstract ConfigurableFileCollection getClasspath();

    public abstract ConfigurableFileCollection getSourceRoots();

    public FileTree getSourceTree() {
        return this.getSourceRoots().getAsFileTree();
    }

    Provider<Set<String>> getAllNamespaces() {
        Instrumented.fileCollectionObserved((FileCollection)this.getSourceTree(), (String)"Clojurephant");
        return Namespaces.findNamespaces(this.getSourceTree());
    }

    public abstract SetProperty<String> getCheckNamespaces();

    public void checkAll() {
        this.getCheckNamespaces().set(this.getAllNamespaces());
    }

    public abstract Property<String> getReflection();

    boolean isCompilerConfigured() {
        return (Boolean)this.getAotNamespaces().map(set -> !set.isEmpty()).getOrElse((Object)false);
    }

    public abstract SetProperty<String> getAotNamespaces();

    public void aotAll() {
        this.getAotNamespaces().set(this.getAllNamespaces());
    }

    @Nested
    public abstract ClojureCompileOptions getCompiler();

    public void compiler(Action<? super ClojureCompileOptions> configureAction) {
        configureAction.execute((Object)this.getCompiler());
    }

    String getTaskName(String task) {
        if ("main".equals(this.getName())) {
            return String.format("%sClojure", task);
        }
        return String.format("%s%sClojure", task, WordUtils.capitalize((String)this.getName()));
    }
}

