/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.tasks.ClojureCheck;
import dev.clojurephant.plugin.clojure.tasks.ClojureCompile;
import dev.clojurephant.plugin.clojure.tasks.ClojureNRepl;
import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompile;
import dev.clojurephant.plugin.common.internal.ClojureCommonBasePlugin;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ComponentModuleMetadataDetails;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.jvm.tasks.ProcessResources;

public class ClojureCommonPlugin
implements Plugin<Project> {
    public static final String DEV_SOURCE_SET_NAME = "dev";
    public static final String NREPL_CONFIGURATION_NAME = "nrepl";
    public static final String NREPL_TASK_NAME = "clojureRepl";

    public void apply(Project project) {
        project.getPlugins().apply(ClojureCommonBasePlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        this.configureDev(project, sourceSets);
        this.configureDependencyConstraints(project.getDependencies());
        ClojureCommonPlugin.configureDevSource(sourceSets, SourceSet::getResources);
    }

    private void configureDev(Project project, SourceSetContainer sourceSets) {
        SourceSet main = (SourceSet)sourceSets.getByName("main");
        SourceSet test = (SourceSet)sourceSets.getByName("test");
        SourceSet dev = (SourceSet)sourceSets.create(DEV_SOURCE_SET_NAME);
        Configuration nrepl = (Configuration)project.getConfigurations().create(NREPL_CONFIGURATION_NAME);
        project.getDependencies().add(NREPL_CONFIGURATION_NAME, (Object)"nrepl:nrepl:0.9.0");
        project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{nrepl});
        project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{nrepl});
        BiFunction<SourceSet, Boolean, FileCollection> nonClojureOutput = (sourceSet, includeCljs) -> {
            SourceSetOutput allOutput = sourceSet.getOutput();
            return allOutput.filter(file -> project.getTasks().stream().filter(task -> task instanceof ClojureCompile || task instanceof ClojureScriptCompile && includeCljs == false || task instanceof ProcessResources).noneMatch(task -> task.getOutputs().getFiles().contains(file)));
        };
        dev.setCompileClasspath((FileCollection)project.files(new Object[]{test.getOutput(), main.getOutput(), project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName())}));
        dev.setRuntimeClasspath((FileCollection)project.files(new Object[]{dev.getAllSource().getSourceDirectories(), nonClojureOutput.apply(dev, true), nonClojureOutput.apply(test, false), nonClojureOutput.apply(main, false), project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName())}));
        Consumer<Function> devExtendsTest = getConfName -> {
            Configuration devConf = project.getConfigurations().getByName((String)getConfName.apply(dev));
            Configuration testConf = project.getConfigurations().getByName((String)getConfName.apply(test));
            devConf.extendsFrom(new Configuration[]{testConf});
        };
        devExtendsTest.accept(SourceSet::getImplementationConfigurationName);
        devExtendsTest.accept(SourceSet::getRuntimeOnlyConfigurationName);
        TaskProvider repl = project.getTasks().register(NREPL_TASK_NAME, ClojureNRepl.class, task -> {
            task.setGroup("run");
            task.setDescription("Starts an nREPL server.");
            task.getClasspath().from(new Object[]{dev.getRuntimeClasspath()});
        });
        project.getGradle().getTaskGraph().whenReady(graph -> {
            if (!graph.hasTask(project.getPath() + NREPL_TASK_NAME)) {
                return;
            }
            HashSet selectedTasks = new HashSet(graph.getAllTasks());
            LinkedList<Object> toProcess = new LinkedList<Object>();
            toProcess.add(repl.get());
            HashSet<Task> toDisable = new HashSet<Task>();
            while (!toProcess.isEmpty()) {
                Task next = (Task)toProcess.remove();
                selectedTasks.remove(next);
                if (next instanceof ClojureCompile || next instanceof ClojureScriptCompile) {
                    toDisable.add(next);
                } else if (next instanceof ClojureCheck && !"checkDevClojure".equals(next.getName())) {
                    toDisable.add(next);
                }
                toProcess.addAll(graph.getDependencies(next));
            }
            if (selectedTasks.isEmpty()) {
                toDisable.forEach(task -> task.setEnabled(false));
            }
        });
    }

    private void configureDependencyConstraints(DependencyHandler dependencies) {
        dependencies.getModules().module((Object)"org.clojure:tools.nrepl", module -> {
            ComponentModuleMetadataDetails details = module;
            details.replacedBy((Object)"nrepl:nrepl", "nREPL was moved out of Clojure Contrib to its own project.");
        });
        if (JavaVersion.current().isJava9Compatible()) {
            dependencies.constraints(constraints -> {
                constraints.add("devImplementation", (Object)"org.clojure:java.classpath:0.3.0", constraint -> constraint.because("Java 9 has a different classloader architecture. 0.3.0 adds support for this."));
                constraints.add("devRuntimeOnly", (Object)"org.clojure:java.classpath:0.3.0", constraint -> constraint.because("Java 9 has a different classloader architecture. 0.3.0 adds support for this."));
            });
        }
    }

    public static void configureDevSource(SourceSetContainer sourceSets, Function<SourceSet, SourceDirectorySet> languageMapper) {
        SourceSet main = (SourceSet)sourceSets.getByName("main");
        SourceSet test = (SourceSet)sourceSets.getByName("test");
        SourceSet dev = (SourceSet)sourceSets.getByName(DEV_SOURCE_SET_NAME);
        languageMapper.apply(dev).source(languageMapper.apply(test));
        languageMapper.apply(dev).source(languageMapper.apply(main));
    }
}

