/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojurescript;

import dev.clojurephant.plugin.clojurescript.ClojureScriptBuild;
import dev.clojurephant.plugin.clojurescript.ClojureScriptExtension;
import dev.clojurephant.plugin.clojurescript.internal.DefaultClojureScriptSourceSet;
import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompile;
import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptSourceSet;
import dev.clojurephant.plugin.common.internal.ClojureCommonBasePlugin;
import dev.clojurephant.plugin.common.internal.Namespaces;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSetContainer;

public class ClojureScriptBasePlugin
implements Plugin<Project> {
    private final ObjectFactory objects;

    @Inject
    public ClojureScriptBasePlugin(ObjectFactory objects) {
        this.objects = objects;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ClojureCommonBasePlugin.class);
        ClojureScriptExtension extension = (ClojureScriptExtension)project.getExtensions().create("clojurescript", ClojureScriptExtension.class, new Object[0]);
        this.configureSourceSetDefaults(project, extension);
        this.configureBuildDefaults(project, extension);
    }

    private void configureSourceSetDefaults(Project project, ClojureScriptExtension extension) {
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> {
            DefaultClojureScriptSourceSet clojurescriptSourceSet = new DefaultClojureScriptSourceSet("clojurescript", this.objects);
            new DslObject(sourceSet).getConvention().getPlugins().put("clojurescript", clojurescriptSourceSet);
            clojurescriptSourceSet.getClojureScript().srcDir((Object)String.format("src/%s/clojurescript", sourceSet.getName()));
            clojurescriptSourceSet.getClojureScript().getFilter().include(Namespaces.CLOJURESCRIPT_PATTERNS);
            sourceSet.getResources().getFilter().exclude(element -> clojurescriptSourceSet.getClojureScript().contains(element.getFile()));
            sourceSet.getAllSource().source(clojurescriptSourceSet.getClojureScript());
            ClojureScriptBuild build = (ClojureScriptBuild)extension.getBuilds().create(sourceSet.getName());
            ClojureScriptSourceSet clojurescript = (ClojureScriptSourceSet)new DslObject(sourceSet).getConvention().getPlugins().get("clojurescript");
            build.getSourceRoots().from(new Object[]{clojurescript.getClojureScript().getSourceDirectories()});
            build.getClasspath().from(new Object[]{build.getSourceRoots()}).from(new Object[]{project.provider(() -> sourceSet.getCompileClasspath())});
            project.getTasks().named(sourceSet.getClassesTaskName(), task -> task.dependsOn(new Object[]{build.getTaskName("compile")}));
            Provider output = project.provider(() -> {
                if (build.isCompilerConfigured()) {
                    return project.files(new Object[]{build.getOutputDir()});
                }
                return clojurescriptSourceSet.getClojureScript().getSourceDirectories();
            });
            ((DefaultSourceSetOutput)sourceSet.getOutput()).getClassesDirs().from(new Object[]{output});
            project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{build.getTaskName("compile")});
        });
    }

    private void configureBuildDefaults(Project project, ClojureScriptExtension extension) {
        extension.getRootOutputDir().set(project.getLayout().getBuildDirectory().dir("clojurescript"));
        extension.getBuilds().configureEach(build -> {
            build.getOutputDir().set(extension.getRootOutputDir().dir(build.getName()));
            build.getCompiler().getBaseOutputDirectory().set((Provider)build.getOutputDir());
            build.getCompiler().getModules().configureEach(module -> module.getBaseOutputDirectory().set((Provider)build.getCompiler().getBaseOutputDirectory()));
            String compileTaskName = build.getTaskName("compile");
            project.getTasks().register(compileTaskName, ClojureScriptCompile.class, task -> {
                task.setDescription(String.format("Compiles the ClojureScript source for the %s build.", build.getName()));
                task.getDestinationDir().set((Provider)build.getOutputDir());
                task.setSource(build.getSourceTree());
                task.getClasspath().from(new Object[]{build.getClasspath()});
                task.getOptions().set((Object)build.getCompiler());
            });
        });
    }
}

