/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojurescript;

import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptSourceSet;
import org.apache.commons.text.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.SourceSet;

public abstract class ClojureScriptBuild
implements Named {
    public abstract DirectoryProperty getOutputDir();

    public abstract Property<SourceSet> getSourceSet();

    Provider<FileCollection> getSourceRoots() {
        return this.getSourceSet().map(sourceSet -> {
            ClojureScriptSourceSet clojure = (ClojureScriptSourceSet)new DslObject(sourceSet).getConvention().getPlugins().get("clojurescript");
            return clojure.getClojureScript().getSourceDirectories();
        });
    }

    boolean isCompilerConfigured() {
        return this.getCompiler().getOutputTo().isPresent() || this.getCompiler().getModules().stream().anyMatch(module -> module.getOutputTo().isPresent());
    }

    @Nested
    public abstract ClojureScriptCompileOptions getCompiler();

    public void compiler(Action<? super ClojureScriptCompileOptions> configureAction) {
        configureAction.execute((Object)this.getCompiler());
    }

    String getTaskName(String task) {
        if ("main".equals(this.getName())) {
            return String.format("%sClojureScript", task);
        }
        return String.format("%s%sClojureScript", task, WordUtils.capitalize((String)this.getName()));
    }
}

