/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure.tasks;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.JavaExecSpec;

public abstract class ClojureNRepl
extends DefaultTask {
    private final ForkOptions forkOptions = new ForkOptions();

    @Inject
    public ClojureNRepl() {
        this.getOutputs().upToDateWhen(t -> false);
    }

    @TaskAction
    public void run() {
        if (!this.getProject().delete(new Object[]{this.getTemporaryDir()})) {
            throw new GradleException("Cannot clean temporary directory: " + this.getTemporaryDir().getAbsolutePath());
        }
        ConfigurableFileCollection cp = this.getProject().files(new Object[]{this.getTemporaryDir(), this.getClasspath()});
        List middleware = Stream.of((List)this.getDefaultMiddleware().getOrElse(Collections.emptyList()), (List)this.getMiddleware().getOrElse(Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.getProject().javaexec(arg_0 -> this.lambda$run$1((FileCollection)cp, middleware, arg_0)).assertNormalExitValue();
        System.out.println("nREPL server stopped");
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    @Optional
    @Option(option="bind", description="Bind address")
    public abstract Property<String> getBind();

    @Input
    @Optional
    public abstract Property<Integer> getPort();

    @Option(option="port", description="Port the nREPL server should listen on.")
    protected void setPortFromCli(String port) {
        this.getPort().set((Object)Integer.parseInt(port));
    }

    @Input
    @Optional
    public abstract Property<Integer> getAckPort();

    @Option(option="ackPort", description="Acknowledge the port of this server to another nREPL server.")
    protected void setAckPortFromCli(String ackPort) {
        this.getAckPort().set((Object)Integer.parseInt(ackPort));
    }

    @Input
    @Optional
    @Option(option="handler", description="Qualified name of nREPL handler function.")
    public abstract Property<String> getHandler();

    @Input
    @Optional
    public abstract ListProperty<String> getMiddleware();

    @Option(option="middleware", description="Qualified names of nREPL middleware functions.")
    protected void setMiddlewareFromCli(List<String> middleware) {
        this.getMiddleware().set(middleware);
    }

    @Input
    @Optional
    public abstract ListProperty<String> getDefaultMiddleware();

    private /* synthetic */ void lambda$run$1(FileCollection cp, List middleware, JavaExecSpec spec) {
        spec.setClasspath(cp);
        spec.getMainClass().set((Object)"clojure.main");
        spec.args(new Object[]{"-m", "nrepl.cmdline"});
        if (this.getBind().isPresent()) {
            spec.args(new Object[]{"--bind", this.getBind().get()});
        }
        if (this.getPort().isPresent()) {
            spec.args(new Object[]{"--port", this.getPort().get()});
        }
        if (this.getAckPort().isPresent()) {
            spec.args(new Object[]{"--ack", this.getAckPort().get()});
        }
        if (this.getHandler().isPresent()) {
            spec.args(new Object[]{"--handler", this.getHandler().get()});
        }
        if (!middleware.isEmpty()) {
            spec.args(new Object[]{"--middleware", "[" + String.join((CharSequence)" ", middleware) + "]"});
        }
        spec.setJvmArgs(this.getForkOptions().getJvmArgs());
        spec.setMinHeapSize(this.getForkOptions().getMemoryInitialSize());
        spec.setMaxHeapSize(this.getForkOptions().getMemoryMaximumSize());
        spec.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
    }
}

