/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.common.internal.ClojureException;
import dev.clojurephant.plugin.common.internal.Edn;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import us.bpsm.edn.Keyword;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;
import us.bpsm.edn.printer.Printer;
import us.bpsm.edn.printer.Printers;

public class PreplClient
implements AutoCloseable {
    private static final Keyword TAG = Keyword.newKeyword((String)"tag");
    private static final Keyword RET = Keyword.newKeyword((String)"ret");
    private static final Keyword OUT = Keyword.newKeyword((String)"out");
    private static final Keyword ERR = Keyword.newKeyword((String)"err");
    private static final Keyword TAP = Keyword.newKeyword((String)"tap");
    private static final Keyword VAL = Keyword.newKeyword((String)"val");
    private static final Keyword NS = Keyword.newKeyword((String)"ns");
    private static final Keyword MS = Keyword.newKeyword((String)"ms");
    private static final Keyword FORM = Keyword.newKeyword((String)"form");
    private static final Keyword EXCEPTION = Keyword.newKeyword((String)"exception");
    private final BufferedReader reader;
    private final PrintWriter writer;
    private final Parser parser;
    private final Printer printer;
    private boolean closed = false;
    private final BlockingQueue<Map<Object, Object>> results = new LinkedBlockingQueue<Map<Object, Object>>();
    private final BlockingQueue<Map<Object, Object>> output = new LinkedBlockingQueue<Map<Object, Object>>();
    private final BlockingQueue<Map<Object, Object>> taps = new LinkedBlockingQueue<Map<Object, Object>>();
    private final Thread inputThread;

    private PreplClient(BufferedReader reader, PrintWriter writer) {
        this.reader = reader;
        this.writer = writer;
        this.parser = Parsers.newParser((Parser.Config)Parsers.defaultConfiguration());
        this.printer = Printers.newPrinter((Appendable)writer);
        this.inputThread = new Thread(this::inputLoop);
    }

    void start() {
        this.inputThread.start();
        try {
            for (int i = 0; i < 10; ++i) {
                if (i != 0) {
                    Thread.sleep(100 * (i + 1));
                }
                try {
                    this.evalEdn("(do (require 'dev.clojurephant.prepl) (deliver dev.clojurephant.prepl/connected true))");
                    break;
                }
                catch (ClojureException clojureException) {
                    continue;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.inputThread.interrupt();
        this.writer.close();
    }

    public Object evalData(Object form) throws InterruptedException {
        String ednForm = Edn.print(form);
        return this.evalEdn(ednForm);
    }

    public Object evalEdn(String form) throws InterruptedException {
        this.writer.println(form);
        Map<Object, Object> result = this.results.take();
        if (result.get(EXCEPTION) == null) {
            return result.get(VAL);
        }
        this.writer.println("(-> *e Throwable->map clojure.main/ex-triage clojure.main/ex-str)");
        String triageResultEdn = (String)this.results.take().get(VAL);
        String triageResult = (String)this.parser.nextValue(Parsers.newParseable((CharSequence)triageResultEdn));
        throw new ClojureException(triageResult);
    }

    public List<String> pollOutput() {
        ArrayList<String> result = new ArrayList<String>();
        while (!this.output.isEmpty()) {
            result.add((String)((Map)this.output.poll()).get(VAL));
        }
        return result;
    }

    public List<String> pollTaps() {
        ArrayList<String> result = new ArrayList<String>();
        while (!this.taps.isEmpty()) {
            result.add((String)((Map)this.taps.poll()).get(VAL));
        }
        return result;
    }

    public void inputLoop() {
        try {
            while (!this.closed) {
                String line = this.reader.readLine();
                Object obj = this.parser.nextValue(Parsers.newParseable((CharSequence)line));
                if (!(obj instanceof Map)) continue;
                Map data = (Map)obj;
                Object tag = data.get(TAG);
                if (RET.equals(tag)) {
                    this.results.put(data);
                    continue;
                }
                if (TAP.equals(tag)) {
                    this.taps.put(data);
                    continue;
                }
                if (OUT.equals(tag)) {
                    this.output.put(data);
                    continue;
                }
                if (!ERR.equals(tag)) continue;
                this.output.put(data);
            }
        }
        catch (ClosedByInterruptException line) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public static PreplClient socketConnect(InetAddress address, int port) {
        SocketChannel socket = null;
        try {
            for (int i = 0; i < 10; ++i) {
                if (i != 0) {
                    Thread.sleep(100 * (i + 1));
                }
                try {
                    InetSocketAddress addr = new InetSocketAddress(address, port);
                    socket = SocketChannel.open(addr);
                    break;
                }
                catch (ConnectException addr) {
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (socket == null) {
            throw new IllegalStateException(String.format("Unable to connect to prepl at %s:%s", address, port));
        }
        BufferedReader reader = new BufferedReader(Channels.newReader(socket, StandardCharsets.UTF_8.name()));
        PrintWriter writer = new PrintWriter(Channels.newWriter((WritableByteChannel)socket, StandardCharsets.UTF_8.name()), true);
        PreplClient client = new PreplClient(reader, writer);
        client.start();
        return client;
    }
}

