/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.ClojureBasePlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;

public class ClojureCommonBasePlugin
implements Plugin<Project> {
    public static final String TOOLS_CONFIGURATION_NAME = "clojureTools";

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        this.configureSourceSets(project, javaConvention);
        this.configureToolsConfigurations(project);
    }

    private void configureSourceSets(Project project, JavaPluginConvention javaConvention) {
        javaConvention.getSourceSets().all(sourceSet -> sourceSet.getResources().exclude(new String[]{"**/.keep"}));
    }

    private void configureToolsConfigurations(Project project) {
        Configuration tools = (Configuration)project.getConfigurations().create(TOOLS_CONFIGURATION_NAME);
        tools.defaultDependencies(deps -> deps.add((Object)project.getDependencies().create((Object)("dev.clojurephant:clojurephant-tools:" + this.getVersion()))));
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> {
            project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{tools});
            project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{tools});
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion() {
        try (InputStream stream = ClojureBasePlugin.class.getResourceAsStream("/clojurephant.properties");){
            Properties props = new Properties();
            props.load(stream);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

