/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure;

import dev.clojurephant.plugin.clojure.tasks.ClojureCompileOptions;
import dev.clojurephant.plugin.clojure.tasks.ClojureReflection;
import dev.clojurephant.plugin.clojure.tasks.ClojureSourceSet;
import dev.clojurephant.plugin.common.internal.Namespaces;
import groovy.lang.Closure;
import java.util.Set;
import org.apache.commons.text.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.SourceSet;

public class ClojureBuild
implements Named {
    private final String name;
    private final DirectoryProperty outputDir;
    private final Property<SourceSet> sourceSet;
    private final SetProperty<String> checkNamespaces;
    private Property<ClojureReflection> reflection;
    private final SetProperty<String> aotNamespaces;
    private final ClojureCompileOptions compiler;

    public ClojureBuild(Project project, String name) {
        this.name = name;
        this.outputDir = project.getObjects().directoryProperty();
        this.sourceSet = project.getObjects().property(SourceSet.class);
        this.checkNamespaces = project.getObjects().setProperty(String.class);
        this.reflection = project.getObjects().property(ClojureReflection.class);
        this.aotNamespaces = project.getObjects().setProperty(String.class);
        this.compiler = new ClojureCompileOptions();
        this.reflection.set((Object)ClojureReflection.silent);
    }

    public String getName() {
        return this.name;
    }

    public DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public Property<SourceSet> getSourceSet() {
        return this.sourceSet;
    }

    Provider<FileCollection> getSourceRoots() {
        return this.getSourceSet().map(sourceSet -> {
            ClojureSourceSet clojure = (ClojureSourceSet)new DslObject(sourceSet).getConvention().getPlugins().get("clojure");
            return clojure.getClojure().getSourceDirectories();
        });
    }

    Provider<Set<String>> getAllNamespaces() {
        return this.getSourceRoots().map(roots -> Namespaces.findNamespaces(roots, Namespaces.CLOJURE_EXTENSIONS));
    }

    public SetProperty<String> getCheckNamespaces() {
        return this.checkNamespaces;
    }

    public void checkAll() {
        this.checkNamespaces.set(this.getAllNamespaces());
    }

    public Property<ClojureReflection> getReflection() {
        return this.reflection;
    }

    public void setReflection(String reflection) {
        this.reflection.set((Object)ClojureReflection.valueOf(reflection));
    }

    public boolean isCompilerConfigured() {
        return (Boolean)this.getAotNamespaces().map(set -> !set.isEmpty()).getOrElse((Object)false);
    }

    public SetProperty<String> getAotNamespaces() {
        return this.aotNamespaces;
    }

    public void aotAll() {
        this.aotNamespaces.set(this.getAllNamespaces());
    }

    public ClojureCompileOptions getCompiler() {
        return this.compiler;
    }

    public void compiler(Action<? super ClojureCompileOptions> configureAction) {
        configureAction.execute((Object)this.compiler);
    }

    public void compiler(Closure<?> configureAction) {
        configureAction.setResolveStrategy(1);
        configureAction.setDelegate((Object)this.compiler);
        configureAction.call((Object)this.compiler);
    }

    String getTaskName(String task) {
        if ("main".equals(this.name)) {
            return String.format("%sClojure", task);
        }
        return String.format("%s%sClojure", task, WordUtils.capitalize((String)this.name));
    }
}

