/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure;

import dev.clojurephant.plugin.clojure.ClojureBuild;
import dev.clojurephant.plugin.clojure.ClojureExtension;
import dev.clojurephant.plugin.clojure.internal.DefaultClojureSourceSet;
import dev.clojurephant.plugin.clojure.tasks.ClojureCheck;
import dev.clojurephant.plugin.clojure.tasks.ClojureCompile;
import dev.clojurephant.plugin.common.internal.ClojureCommonBasePlugin;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public class ClojureBasePlugin
implements Plugin<Project> {
    private final ObjectFactory objects;

    @Inject
    public ClojureBasePlugin(ObjectFactory objects) {
        this.objects = objects;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ClojureCommonBasePlugin.class);
        ClojureExtension extension = (ClojureExtension)project.getExtensions().create("clojure", ClojureExtension.class, new Object[]{project});
        this.configureSourceSetDefaults(project, extension);
        this.configureBuildDefaults(project, extension);
    }

    private void configureSourceSetDefaults(Project project, ClojureExtension extension) {
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> {
            DefaultClojureSourceSet clojureSourceSet = new DefaultClojureSourceSet("clojure", this.objects);
            new DslObject(sourceSet).getConvention().getPlugins().put("clojure", clojureSourceSet);
            clojureSourceSet.getClojure().srcDir((Object)String.format("src/%s/clojure", sourceSet.getName()));
            sourceSet.getResources().getFilter().exclude(element -> clojureSourceSet.getClojure().contains(element.getFile()));
            sourceSet.getAllSource().source(clojureSourceSet.getClojure());
            ClojureBuild build = (ClojureBuild)extension.getBuilds().create(sourceSet.getName());
            build.getSourceSet().set(sourceSet);
            ((DefaultSourceSetOutput)sourceSet.getOutput()).addClassesDir(() -> ((Directory)build.getOutputDir().get()).getAsFile());
            project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{build.getTaskName("compile")});
            project.getTasks().getByName(sourceSet.getClassesTaskName()).dependsOn(new Object[]{build.getTaskName("check")});
            sourceSet.getOutput().dir((Object)project.provider(() -> {
                if (build.isCompilerConfigured()) {
                    return build.getOutputDir();
                }
                return clojureSourceSet.getClojure().getSourceDirectories();
            }));
        });
    }

    private void configureBuildDefaults(Project project, ClojureExtension extension) {
        extension.getRootOutputDir().set(project.getLayout().getBuildDirectory().dir("clojure"));
        extension.getBuilds().all(build -> {
            Provider classpath = build.getSourceSet().map(sourceSet -> sourceSet.getCompileClasspath().plus((FileCollection)project.files(new Object[]{sourceSet.getJava().getOutputDir()})).plus((FileCollection)project.files(new Object[]{sourceSet.getOutput().getResourcesDir()})));
            String checkTaskName = build.getTaskName("check");
            ClojureCheck check = (ClojureCheck)project.getTasks().create(checkTaskName, ClojureCheck.class);
            check.setDescription(String.format("Checks the Clojure source for the %s build.", build.getName()));
            check.getSourceRoots().from(new Object[]{build.getSourceRoots()});
            check.getClasspath().from(new Object[]{classpath});
            check.getReflection().set(build.getReflection());
            check.getNamespaces().set(build.getCheckNamespaces());
            check.dependsOn(new Object[]{build.getSourceSet().map(SourceSet::getCompileJavaTaskName)});
            check.dependsOn(new Object[]{build.getSourceSet().map(SourceSet::getProcessResourcesTaskName)});
            String compileTaskName = build.getTaskName("compile");
            ClojureCompile compile = (ClojureCompile)project.getTasks().create(compileTaskName, ClojureCompile.class);
            compile.setDescription(String.format("Compiles the Clojure source for the %s build.", build.getName()));
            compile.getDestinationDir().set((Provider)build.getOutputDir());
            compile.getSourceRoots().from(new Object[]{build.getSourceRoots()});
            compile.getClasspath().from(new Object[]{classpath});
            compile.setOptions(build.getCompiler());
            compile.getNamespaces().set(build.getAotNamespaces());
            compile.dependsOn(new Object[]{build.getSourceSet().map(SourceSet::getCompileJavaTaskName)});
            compile.dependsOn(new Object[]{build.getSourceSet().map(SourceSet::getProcessResourcesTaskName)});
        });
    }
}

