/*
 * Decompiled with CFR 0.152.
 */
package de.paymill.service;

import de.paymill.Paymill;
import de.paymill.PaymillException;
import de.paymill.net.Filter;
import de.paymill.net.HttpClient;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractService<T> {
    protected String resource;
    protected Class<T> modelClass;
    protected ListType listType;
    protected HttpClient client;

    public AbstractService(String resource, Class<T> modelClass) {
        this(resource, modelClass, Paymill.getClient());
    }

    public AbstractService(String resource, Class<T> modelClass, HttpClient client) {
        this.modelClass = modelClass;
        this.listType = new ListType(modelClass);
        this.resource = resource;
        this.client = client;
    }

    public List<T> list() {
        return this.client.getList(this.resource, null, this.listType);
    }

    public List<T> list(Filter filter) {
        return this.client.getList(this.resource, filter.toMap(), this.listType);
    }

    public List<T> list(int offset, int limit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("count", Integer.toString(limit));
        params.put("offset", Integer.toString(offset));
        return this.client.getList(this.resource, params, this.listType);
    }

    public List<T> list(int offset, int limit, Filter filter) {
        Map<String, Object> params = filter.toMap();
        params.put("count", Integer.toString(limit));
        params.put("offset", Integer.toString(offset));
        return this.client.getList(this.resource, params, this.listType);
    }

    public T get(String id) {
        return this.client.get(this.resource, id, this.modelClass);
    }

    public T create(T obj) {
        return this.client.post(this.resource, obj, this.modelClass);
    }

    public T update(T obj) {
        return this.client.put(this.resource, this.getModelId(obj), obj, this.modelClass);
    }

    public void delete(T obj) {
        this.client.delete(this.resource, this.getModelId(obj));
    }

    public void delete(String id) {
        this.client.delete(this.resource, id);
    }

    protected String getModelId(T obj) {
        try {
            Method method = obj.getClass().getMethod("getId", new Class[0]);
            Object result = method.invoke(obj, new Object[0]);
            if (result != null) {
                return result.toString();
            }
            throw new PaymillException("Id getter returned null at " + obj, new Object[0]);
        }
        catch (Exception ex) {
            throw new PaymillException("Error reading id property from " + obj, (Throwable)ex, new Object[0]);
        }
    }

    private class ListType
    implements ParameterizedType {
        private Type[] typeArguments;

        public ListType(Class<T> modelClass) {
            this.typeArguments = new Type[]{modelClass};
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return List.class;
        }
    }
}

