/*
 * Decompiled with CFR 0.152.
 */
package de.paymill.net;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.paymill.PaymillException;
import de.paymill.net.ApiException;
import de.paymill.net.GsonAdapter;
import de.paymill.net.IDecoder;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;

public class JsonDecoder
extends GsonAdapter
implements IDecoder {
    protected Gson gson = this.createGson();
    protected JsonParser parser = new JsonParser();
    protected String charset = "UTF-8";

    @Override
    public <T> T decode(String data, Type type) {
        try {
            JsonObject root = this.parser.parse(data).getAsJsonObject();
            JsonElement dataElement = root.get("data");
            return (T)this.gson.fromJson(dataElement, type);
        }
        catch (JsonSyntaxException e) {
            throw new PaymillException("Error decoding string.", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public ApiException decodeError(String data) {
        String errorMessage = null;
        String errorCode = null;
        String errorField = null;
        JsonElement element = this.parser.parse(data);
        JsonObject object = element.getAsJsonObject();
        JsonElement errorRoot = object.get("error");
        if (errorRoot.isJsonObject()) {
            JsonObject errorSub = errorRoot.getAsJsonObject();
            JsonObject messages = errorSub.get("messages").getAsJsonObject();
            errorField = errorSub.get("field").getAsString();
            Iterator i$ = messages.entrySet().iterator();
            if (i$.hasNext()) {
                Map.Entry entry = (Map.Entry)i$.next();
                errorMessage = ((JsonElement)entry.getValue()).getAsString();
                errorCode = (String)entry.getKey();
                errorMessage = errorMessage + " (" + errorField + ")";
            }
        } else {
            errorMessage = errorRoot.getAsString();
            errorCode = object.get("exception").getAsString();
            errorMessage = errorMessage + " (" + errorCode + ")";
        }
        ApiException ex = new ApiException(errorMessage);
        ex.setCode(errorCode);
        ex.setField(errorField);
        return ex;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }
}

