/*
 * Decompiled with CFR 0.152.
 */
package de.paymill;

import de.paymill.PaymillException;
import de.paymill.net.HttpClient;
import de.paymill.service.AbstractService;
import java.lang.reflect.Constructor;

public class Paymill {
    private static String apiKey;

    public static void setApiKey(String apiKey) {
        Paymill.apiKey = apiKey;
    }

    public static String getApiKey() {
        if (apiKey == null) {
            apiKey = System.getProperty("apiKey");
        }
        return apiKey;
    }

    public static String getApiUrl() {
        return System.getProperty("apiUrl", "https://api.paymill.de/v2");
    }

    public static HttpClient getClient() {
        String apiKey = Paymill.getApiKey();
        if (apiKey == null) {
            throw new PaymillException("You need to set an api key before instantiating an HttpClient", new Object[0]);
        }
        return new HttpClient(Paymill.getApiUrl(), apiKey);
    }

    public static <T extends AbstractService<?>> T getService(Class<T> serviceClass) {
        try {
            Constructor<T> c = serviceClass.getConstructor(HttpClient.class);
            return (T)((AbstractService)c.newInstance(Paymill.getClient()));
        }
        catch (Exception ex) {
            throw new PaymillException("Error creating a new instance of service " + serviceClass, (Throwable)ex, new Object[0]);
        }
    }
}

