/*
 * Decompiled with CFR 0.152.
 */
package com.collections;

import com.domain.Adapter;
import com.domain.ObjectWithId;
import com.domain.TimeRange;
import com.domain.Tuple;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.utils.PreConditions;
import fj.data.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.sonatype.inject.Nullable;

public class CollectionUtils {
    public static final Transformer<Object, String> OBJECT_STRING_TRANSFORMER = new Transformer<Object, String>(){

        @Override
        public String transform(Object t) {
            return String.valueOf(t);
        }
    };
    public static final Transformer<Object, Long> OBJECT_LONG_TRANSFORMER = new Transformer<Object, Long>(){

        @Override
        public Long transform(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof Long) {
                return (Long)t;
            }
            return Long.valueOf(t.toString());
        }
    };
    public static final Transformer<Object, Float> OBJECT_FLOAT_TRANSFORMER = new Transformer<Object, Float>(){

        @Override
        public Float transform(Object t) {
            if (t == null) {
                return null;
            }
            if (t instanceof Float) {
                return (Float)t;
            }
            return Float.valueOf(t.toString());
        }
    };
    private static Transformer<String, String> STRING_VALUE_TO_TRIMMED_LOWER_CASE = new Transformer<String, String>(){

        @Override
        public String transform(String tag) {
            if (StringUtils.isNotBlank((String)tag)) {
                tag = tag.trim().toLowerCase();
            }
            return tag;
        }
    };
    private static Transformer<String, String> STRING_VALUE_TO_TRIMMED_UPPER_CASE = new Transformer<String, String>(){

        @Override
        public String transform(String tag) {
            if (StringUtils.isNotBlank((String)tag)) {
                tag = tag.trim().toUpperCase();
            }
            return tag;
        }
    };
    public static final Transformer<ObjectWithId, String> OBJECT_TO_ID = new Transformer<ObjectWithId, String>(){

        @Override
        public String transform(ObjectWithId object) {
            return object.getId();
        }
    };
    public static final Transformer<Object, String> OBJECT_TO_STR_TRANSFORMER = new Transformer<Object, String>(){

        @Override
        public String transform(Object id) {
            if (id != null) {
                return String.valueOf(id);
            }
            return null;
        }
    };
    public static final Transformer<Object, Integer> OBJECT_TO_INT_TRANSFORMER = new Transformer<Object, Integer>(){

        @Override
        public Integer transform(Object id) {
            if (id != null) {
                return Integer.valueOf(String.valueOf(id));
            }
            return null;
        }
    };
    public static final Transformer<String, String> LOWER_CASE_TRANSFORMER = new Transformer<String, String>(){

        @Override
        public String transform(String t) {
            return StringUtils.isBlank((String)t) ? null : t.trim().toLowerCase();
        }
    };
    public static final Transformer<String, ObjectId> STRING_TO_OBJECT_ID_TRANSFORMER = new Transformer<String, ObjectId>(){

        @Override
        public ObjectId transform(String t) {
            return new ObjectId(t);
        }
    };
    public static final Transformer<String, String> STR_TO_STR_TRANSFORMER = new Transformer<String, String>(){

        @Override
        public String transform(String id) {
            return id;
        }
    };
    public static final Transformer<String, Object> STR_TO_OBJECT_TRANSFORMER = new Transformer<String, Object>(){

        @Override
        public Object transform(String id) {
            return id;
        }
    };
    public static final Transformer<Long, Object> LONG_TO_OBJECT_TRANSFORMER = new Transformer<Long, Object>(){

        @Override
        public Object transform(Long t) {
            return t;
        }
    };
    public static final Transformer<Integer, Object> INTEGER_TO_OBJECT_TRANSFORMER = new Transformer<Integer, Object>(){

        @Override
        public Object transform(Integer t) {
            return t;
        }
    };
    public static final Transformer<Object, Long> OBJECT_TO_LONG_TRANSFORMER = new Transformer<Object, Long>(){

        @Override
        public Long transform(Object t) {
            return Long.valueOf(String.valueOf(t));
        }
    };
    public static final Transformer<Long, String> LONG_TO_STR_TRANSFORMER = new Transformer<Long, String>(){

        @Override
        public String transform(Long id) {
            if (id != null) {
                return String.valueOf(id);
            }
            return null;
        }
    };
    public static final Transformer<Double, Long> DOUBLE_TO_LONG_TRANSFORMER = new Transformer<Double, Long>(){

        @Override
        public Long transform(Double t) {
            if (t != null) {
                return t.longValue();
            }
            return null;
        }
    };
    public static final Transformer<Double, Float> DOUBLE_TO_FLOAT_TRANSFORMER = new Transformer<Double, Float>(){

        @Override
        public Float transform(Double t) {
            if (t != null) {
                return Float.valueOf(t.floatValue());
            }
            return null;
        }
    };
    public static final Transformer<String, Long> STR_TO_LONG_TRANSFORMER = new Transformer<String, Long>(){

        @Override
        public Long transform(String id) {
            if (StringUtils.isNotEmpty((String)id) && !"null".equals(id)) {
                return Long.valueOf(id);
            }
            return null;
        }
    };
    public static final Transformer<String, Integer> STR_TO_INTEGER_TRANSFORMER = new Transformer<String, Integer>(){

        @Override
        public Integer transform(String id) {
            if (StringUtils.isNotEmpty((String)id)) {
                return Integer.valueOf(id);
            }
            return null;
        }
    };
    public static final Transformer<String, String> STRING_TO_TRIMMED_LOWERCASE_STRING = new Transformer<String, String>(){

        @Override
        public String transform(String t) {
            return t.trim().toLowerCase();
        }
    };
    public static final Transformer<String, String> STRING_TO_TRIMMED_STRING = new Transformer<String, String>(){

        @Override
        public String transform(String t) {
            return t.trim();
        }
    };
    public static final Transformer<String, Integer> STR_TO_INTEGER_SAFE_TRANSFORMER = new Transformer<String, Integer>(){

        @Override
        public Integer transform(String t) {
            if (StringUtils.isNotEmpty((String)t)) {
                try {
                    return Integer.valueOf(t);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
    };
    public static final Transformer<Long, String> LONG_TO_STRING_TRANSFORMER = new Transformer<Long, String>(){

        @Override
        public String transform(Long aLong) {
            return String.valueOf(aLong);
        }
    };

    public static <S> Transformer<S, S> identity() {
        return new Transformer<S, S>(){

            @Override
            public S transform(S t) {
                return t;
            }
        };
    }

    public static <FROM, TO> Transformer<FROM, TO> transformer(final Adapter<FROM, TO> adapter) {
        return new Transformer<FROM, TO>(){

            @Override
            public TO transform(FROM t) {
                return adapter.adapt(t);
            }
        };
    }

    public static <E> Predicate<E> not(Predicate<E> predicate) {
        return predicate.negate();
    }

    public static String[] toArray(Collection<String> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return new String[0];
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static <E> List<List<E>> partition(List<E> list, int size) {
        ArrayList partitionedList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return partitionedList;
        }
        ArrayList currentList = null;
        int currentSize = 0;
        for (E e : list) {
            if (currentList == null || currentSize >= size) {
                currentSize = 0;
                currentList = Lists.newArrayList();
                partitionedList.add(currentList);
            }
            currentList.add(e);
            ++currentSize;
        }
        return partitionedList;
    }

    public static <E> List<List<E>> partition(Collection<E> list, int size) {
        ArrayList partitionedList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return partitionedList;
        }
        ArrayList currentList = null;
        int currentSize = 0;
        for (E e : list) {
            if (currentList == null || currentSize >= size) {
                currentSize = 0;
                currentList = Lists.newArrayList();
                partitionedList.add(currentList);
            }
            currentList.add(e);
            ++currentSize;
        }
        return partitionedList;
    }

    public static <K1, K2, V> Map<K2, V> transformMap(Map<K1, V> map, Transformer<K1, K2> keyTransformer) {
        if (CollectionUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashMap rv = Maps.newHashMap();
        for (Map.Entry<K1, V> entry : map.entrySet()) {
            K2 newKey = keyTransformer.transform(entry.getKey());
            if (newKey == null) continue;
            rv.put(newKey, entry.getValue());
        }
        return rv;
    }

    public static <K, K1, V, V1> Map<K1, V1> transformMap(Map<K, V> map, Transformer<K, K1> keyTransformer, Transformer<V, V1> valueTransformer) {
        if (CollectionUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashMap rv = Maps.newHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K1 newKey = keyTransformer.transform(entry.getKey());
            if (newKey == null) continue;
            V1 newValue = valueTransformer.transform(entry.getValue());
            rv.put(newKey, newValue);
        }
        return rv;
    }

    public static <K, V, V1> Map<K, V1> transformMapValues(Map<K, V> map, Transformer<V, V1> valueTransformer) {
        if (CollectionUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashMap rv = Maps.newHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V1 newValue = valueTransformer.transform(entry.getValue());
            rv.put(entry.getKey(), newValue);
        }
        return rv;
    }

    public static <K, K1, V> Map<K1, V> transformToMapWithFilter(Collection<K> kCollection, Transformer<K, K1> keyTransformer, Transformer<K, V> valueTransformer, com.google.common.base.Predicate<K> predicate) {
        if (CollectionUtils.isEmpty(kCollection)) {
            return Collections.emptyMap();
        }
        HashMap rv = Maps.newHashMap();
        for (K k : kCollection) {
            K1 newKey;
            if (!predicate.apply(k) || (newKey = keyTransformer.transform(k)) == null) continue;
            V newValue = valueTransformer.transform(k);
            rv.put(newKey, newValue);
        }
        return rv;
    }

    public static <K, V, E> Map<K, Collection<V>> transformToMap(Collection<E> collection, Function<E, Tuple<K, V>> function) {
        if (CollectionUtils.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        HashMap kvMap = Maps.newHashMap();
        for (E e : collection) {
            Tuple tuple = (Tuple)function.apply(e);
            if (tuple == null) continue;
            Collection vCollection = (Collection)kvMap.get(tuple.v1());
            if (vCollection == null) {
                vCollection = Lists.newArrayList();
                kvMap.put(tuple.v1(), vCollection);
            }
            vCollection.add(tuple.v2());
        }
        return kvMap;
    }

    public static <T> List<List<T>> transpose(List<List<T>> table) {
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int N = table.get(0).size();
        for (int index = 0; index < N; ++index) {
            ArrayList<T> col = new ArrayList<T>();
            for (List<T> row : table) {
                if (row.size() != N) {
                    return table;
                }
                col.add(row.get(index));
            }
            ret.add(col);
        }
        return ret;
    }

    public static <T> Collection<T> addAll(Collection<T> existingData, Collection<T> dataToAdd) {
        if (CollectionUtils.isNotEmpty(dataToAdd)) {
            if (CollectionUtils.isEmpty(existingData)) {
                existingData = new HashSet<T>();
            }
            existingData.addAll(CollectionUtils.nullAndEmptySafeValueCollection(dataToAdd));
        }
        return existingData;
    }

    public static <S, T> Map<S, T> put(Map<S, T> existingData, S key, T value) {
        if (key != null) {
            if (MapUtils.isEmpty(existingData)) {
                existingData = new HashMap<S, T>();
            }
            if (value != null) {
                existingData.put(key, value);
            }
        }
        return existingData;
    }

    public static <T> Collection<List<T>> createBatches(Collection<T> data, int batchSize) {
        return CollectionUtils.createBatches(CollectionUtils.toList(data), batchSize);
    }

    public static <T> Collection<List<T>> createBatches(List<T> data, int batchSize) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        int noBatches = data.size() / batchSize + (data.size() % batchSize > 0 ? 1 : 0);
        for (int i = 0; i < noBatches; ++i) {
            int startIndex = i * batchSize;
            int endIndex = startIndex + batchSize > data.size() ? data.size() : startIndex + batchSize;
            batches.add(new ArrayList<T>(data.subList(startIndex, endIndex)));
        }
        return batches;
    }

    public static <T> Collection<Set<T>> createBatches(Set<T> data, int batchSize) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        Collection<List<T>> batches = CollectionUtils.createBatches(new ArrayList<T>(data), batchSize);
        ArrayList<Set<T>> batchesAsSet = new ArrayList<Set<T>>();
        for (List<T> batchedItems : CollectionUtils.nullSafeValueList(batches)) {
            batchesAsSet.add(new TreeSet<T>(batchedItems));
        }
        return batchesAsSet;
    }

    public static <T> Collection<Set<T>> createBatchesWithHashSet(Set<T> data, int batchSize) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        Collection<List<T>> batches = CollectionUtils.createBatches(new ArrayList<T>(data), batchSize);
        ArrayList<Set<T>> batchesAsSet = new ArrayList<Set<T>>();
        for (List<T> batchedItems : batches) {
            batchesAsSet.add(new HashSet<T>(batchedItems));
        }
        return batchesAsSet;
    }

    public static <T> Collection<List<T>> createMaxBatches(T[] data, int numOfBatches) {
        return CollectionUtils.createMaxBatches(Lists.newArrayList((Object[])data), numOfBatches);
    }

    public static <T> Collection<List<T>> createMaxBatches(List<T> data, int numOfBatches) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        if (data.size() < numOfBatches) {
            return CollectionUtils.createBatches(data, 1);
        }
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        int batchSize = data.size() / numOfBatches;
        int remainder = data.size() % numOfBatches;
        int startIndex = 0;
        for (int i = 0; i < numOfBatches; ++i) {
            int endIndex;
            int n = endIndex = startIndex + batchSize > data.size() ? data.size() : startIndex + batchSize;
            if (endIndex < data.size() && remainder > 0) {
                ++endIndex;
                --remainder;
            }
            batches.add(Lists.newArrayList(data.subList(startIndex, endIndex)));
            startIndex = endIndex;
        }
        return batches;
    }

    public static <T> Map<String, T> putAll(Map<String, T> existingData, Map<String, T> dataToAdd) {
        if (MapUtils.isNotEmpty(dataToAdd)) {
            if (MapUtils.isEmpty(existingData)) {
                existingData = new HashMap<String, T>();
            }
            existingData.putAll(dataToAdd);
        }
        return existingData;
    }

    public static <T> Map<GroupKey, Collection<T>> group(Collection<T> tCollection, GroupByStrategy<T> groupByStrategy) {
        if (CollectionUtils.isEmpty(tCollection) || groupByStrategy == null) {
            return Collections.emptyMap();
        }
        HashMap<GroupKey, Collection<T>> result = new HashMap<GroupKey, Collection<T>>();
        for (T t : tCollection) {
            GroupKey groupKey = groupByStrategy.group(t);
            if (groupKey == null) continue;
            ArrayList<T> groupedTs = (ArrayList<T>)result.get(groupKey);
            if (CollectionUtils.isEmpty(groupedTs)) {
                groupedTs = new ArrayList<T>();
                result.put(groupKey, groupedTs);
            }
            groupedTs.add(t);
        }
        return result;
    }

    public static <T> List<T> toList(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        if (collection == null) {
            return Lists.newArrayList();
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> toMutalbleList(Collection<T> collection) {
        return new ArrayList<T>(CollectionUtils.nullSafeValueCollection(collection));
    }

    public static <T> Set<T> toMutalbleSet(Collection<T> collection) {
        return new HashSet<T>(CollectionUtils.nullSafeValueCollection(collection));
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        if (collection == null) {
            return Sets.newHashSet();
        }
        return new HashSet<T>(collection);
    }

    public static <T extends Comparable> TreeSet<T> toTreeSet(Collection<T> collection) {
        if (collection instanceof TreeSet) {
            return (TreeSet)collection;
        }
        if (collection == null) {
            return Sets.newTreeSet();
        }
        return new TreeSet<T>(collection);
    }

    public static <T> Set<T> nullSafeSet(Set<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptySet();
        }
        return data;
    }

    public static <T> Set<T> nullSafeNonEmptySet(Set<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Sets.newHashSet();
        }
        return data;
    }

    public static <T> Collection<T> nullSafeCollection(Collection<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return data;
    }

    public static <T> List<T> nullSafeList(List<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return data;
    }

    public static <T> List<T> nonEmptyList(List<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Lists.newArrayList();
        }
        return data;
    }

    public static <T> List<T> nullSafeListFromCollection(Collection<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(data);
    }

    public static <T> ArrayList<T> nullSafeMutableList(List<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList();
        }
        return new ArrayList<T>(data);
    }

    public static <T> Set<T> nullSafeMutableSet(Set<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(data);
    }

    public static <T> Set<T> getMutableSetIfNullOrEmpty(Set<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            data = Sets.newHashSet();
        }
        return data;
    }

    public static <T> List<String> transformToListWithPrefix(Collection<T> data, final Object prefix, final String separator) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return CollectionUtils.transformToList(data, new Transformer<T, String>(){

            @Override
            public String transform(T t) {
                return prefix + separator + t;
            }
        });
    }

    public static <T> List<String> transformToListWithSuffix(Collection<T> data, final Object suffix, final String separator) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        return CollectionUtils.transformToList(data, new Transformer<T, String>(){

            @Override
            public String transform(T t) {
                return t + separator + suffix;
            }
        });
    }

    public static <P, Q, R> Map<P, R> transformValuesInMap(Map<P, Q> params, Transformer<Q, R> transformer) {
        if (MapUtils.isEmpty(params)) {
            return Collections.emptyMap();
        }
        HashMap transformedMap = Maps.newHashMap();
        for (Map.Entry<P, Q> entry : params.entrySet()) {
            transformedMap.put(entry.getKey(), transformer.transform(entry.getValue()));
        }
        return transformedMap;
    }

    public static <K, V, T> Map<T, V> transformKeysInMap(Map<K, V> originalMap, Transformer<K, T> transformer) {
        if (MapUtils.isEmpty(originalMap)) {
            return Collections.emptyMap();
        }
        HashMap transformedMap = Maps.newHashMap();
        for (Map.Entry<K, V> entry : originalMap.entrySet()) {
            transformedMap.put(transformer.transform(entry.getKey()), entry.getValue());
        }
        return transformedMap;
    }

    public static <T> Collection<T> nullSafeValueCollection(Collection<T> objs) {
        if (CollectionUtils.isEmpty(objs)) {
            return Collections.emptyList();
        }
        return Collections2.filter(objs, (com.google.common.base.Predicate)new com.google.common.base.Predicate<T>(){

            public boolean apply(@Nullable T t) {
                return t != null;
            }
        });
    }

    public static <S, T> Map<S, T> nullSafeValueMap(Map<S, T> map) {
        if (MapUtils.isEmpty(map)) {
            return Maps.newHashMap();
        }
        HashMap<S, T> result = new HashMap<S, T>();
        for (Map.Entry<S, T> entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> List<T> nullAndEmptySafeValueList(Collection<T> objs) {
        if (CollectionUtils.isEmpty(objs)) {
            return Collections.emptyList();
        }
        return CollectionUtils.toList(Collections2.filter(objs, (com.google.common.base.Predicate)new com.google.common.base.Predicate<T>(){

            public boolean apply(@Nullable T t) {
                if (t == null) {
                    return false;
                }
                if (t instanceof String) {
                    return StringUtils.isNotBlank((String)((String)t));
                }
                return true;
            }
        }));
    }

    public static <T> Set<T> nonEmptySet(Set<T> values) {
        if (CollectionUtils.isEmpty(values)) {
            return new HashSet();
        }
        return values;
    }

    public static <T> Set<T> nullAndEmptySafeValueSet(Collection<T> objs) {
        if (CollectionUtils.isEmpty(objs)) {
            return Collections.emptySet();
        }
        return CollectionUtils.toSet(Collections2.filter(objs, (com.google.common.base.Predicate)new com.google.common.base.Predicate<T>(){

            public boolean apply(@Nullable T t) {
                if (t == null) {
                    return false;
                }
                if (t instanceof String) {
                    return StringUtils.isNotEmpty((String)((String)t));
                }
                return true;
            }
        }));
    }

    public static <T> Collection<T> nullAndEmptySafeValueCollection(Collection<T> objs) {
        if (CollectionUtils.isEmpty(objs)) {
            return Collections.emptyList();
        }
        return Collections2.filter(objs, (com.google.common.base.Predicate)new com.google.common.base.Predicate<T>(){

            public boolean apply(@Nullable T t) {
                if (t == null) {
                    return false;
                }
                if (t instanceof String) {
                    return StringUtils.isNotEmpty((String)((String)t));
                }
                return true;
            }
        });
    }

    public static <T, S> Map<T, S> nullSafeMap(Map<T, S> data) {
        if (data != null) {
            return data;
        }
        return Collections.emptyMap();
    }

    public static <T, S> Map<T, S> nullSafeMutableMap(Map<T, S> data) {
        if (data != null) {
            return Maps.newHashMap(data);
        }
        return Maps.newHashMap();
    }

    public static <T> List<T> nullSafeValueList(Collection<T> values) {
        Collection<T> nullSafeCollection = CollectionUtils.nullSafeValueCollection(values);
        return CollectionUtils.toList(nullSafeCollection);
    }

    public static <T> Set<T> nullSafeValueSet(Collection<T> values) {
        Collection<T> nullSafeCollection = CollectionUtils.nullSafeValueCollection(values);
        return CollectionUtils.toSet(nullSafeCollection);
    }

    public static <T> Set<T> getUnmodifiableSet(Set<T> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(data);
    }

    public static Map<String, List<String>> mergeMapValuesWithNoDuplicates(Map<String, List<String>> oldValues, Map<String, List<String>> newValues) {
        HashMap mergedValues = Maps.newHashMap();
        if (MapUtils.isEmpty(oldValues) && MapUtils.isEmpty(newValues)) {
            return mergedValues;
        }
        if (MapUtils.isEmpty(oldValues)) {
            mergedValues.putAll(newValues);
            return mergedValues;
        }
        if (MapUtils.isEmpty(newValues)) {
            mergedValues.putAll(oldValues);
            return mergedValues;
        }
        HashMap copyOfNewValues = Maps.newHashMap(newValues);
        for (Map.Entry<String, List<String>> oldValuesEntry : oldValues.entrySet()) {
            String key = oldValuesEntry.getKey();
            List<String> oldValue = oldValuesEntry.getValue();
            List newValue = (List)copyOfNewValues.remove(key);
            mergedValues.put(key, CollectionUtils.mergeListsWithNoDuplicate(oldValue, newValue));
        }
        if (MapUtils.isNotEmpty((Map)copyOfNewValues)) {
            mergedValues.putAll(copyOfNewValues);
        }
        return mergedValues;
    }

    public static <T> List<T> nullAndEmptySafeValueList(T[] values) {
        if (values == null) {
            return Collections.emptyList();
        }
        ArrayList nullSafeValues = Lists.newArrayList();
        for (T value : values) {
            if (value == null) continue;
            nullSafeValues.add(value);
        }
        return nullSafeValues;
    }

    public static <T> boolean containsAny(Collection<T> source, Collection<T> values) {
        boolean isSourceEmpty = CollectionUtils.isEmpty(source);
        boolean isValuesEmpty = CollectionUtils.isEmpty(values);
        if (isSourceEmpty && isValuesEmpty) {
            return true;
        }
        if (isSourceEmpty || isValuesEmpty) {
            return false;
        }
        Set<T> sourceSet = CollectionUtils.toSet(source);
        for (T value : values) {
            if (!sourceSet.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(Collection<T> source, Collection<T> values) {
        boolean isSourceEmpty = CollectionUtils.isEmpty(source);
        boolean isValuesEmpty = CollectionUtils.isEmpty(values);
        if (isSourceEmpty && isValuesEmpty) {
            return true;
        }
        if (isSourceEmpty || isValuesEmpty) {
            return false;
        }
        Set<T> sourceSet = CollectionUtils.toSet(source);
        for (T value : values) {
            if (sourceSet.contains(value)) continue;
            return false;
        }
        return true;
    }

    public static Set<String> transformToLowerCaseSet(Collection<String> values) {
        return CollectionUtils.transformToSet(values, STRING_VALUE_TO_TRIMMED_LOWER_CASE);
    }

    public static Set<String> transformToUpperCaseSet(Collection<String> values) {
        return CollectionUtils.transformToSet(values, STRING_VALUE_TO_TRIMMED_UPPER_CASE);
    }

    public static <K, V> Collection<V> getAll(Map<K, V> map, Collection<K> keys) {
        if (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty(keys)) {
            return Collections.emptyList();
        }
        ArrayList<V> values = new ArrayList<V>();
        for (K key : keys) {
            V value = map.get(key);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static <K> Collection<K> getAllAndKeyIfNull(Map<K, K> map, Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(map)) {
            return CollectionUtils.toList(keys);
        }
        ArrayList<K> values = new ArrayList<K>();
        for (K key : keys) {
            K value = map.get(key);
            if (value != null) {
                values.add(value);
                continue;
            }
            values.add(key);
        }
        return values;
    }

    public static <K, V> void removeAll(Map<K, V> map, Collection<K> keys) {
        if (CollectionUtils.isEmpty(map) || CollectionUtils.isEmpty(keys)) {
            return;
        }
        HashMap<K, V> removedMap = new HashMap<K, V>();
        for (K key : keys) {
            V value = map.remove(key);
            removedMap.put(key, value);
        }
    }

    public static <K, V> Map<K, V> filterKeys(Map<K, V> map, com.google.common.base.Predicate<K> predicate) {
        if (CollectionUtils.isEmpty(map) || predicate == null) {
            return Collections.emptyMap();
        }
        HashMap<K, V> filtered = new HashMap<K, V>();
        for (K k : map.keySet()) {
            boolean add = predicate.apply(k);
            if (!add) continue;
            filtered.put(k, map.get(k));
        }
        return filtered;
    }

    public static <K, V> Map<K, V> filterValues(Map<K, V> map, com.google.common.base.Predicate<V> predicate) {
        if (CollectionUtils.isEmpty(map) || predicate == null) {
            return Collections.emptyMap();
        }
        HashMap filtered = new HashMap();
        map.forEach((k, v) -> {
            boolean add = predicate.apply(v);
            if (add) {
                filtered.put(k, map.get(k));
            }
        });
        return filtered;
    }

    public static List<String> nullAndBlankSafeValueList(Collection<String> tags) {
        return CollectionUtils.filterList(tags, new com.google.common.base.Predicate<String>(){

            public boolean apply(@Nullable String s) {
                return StringUtils.isNotBlank((String)s);
            }
        });
    }

    public static Set<String> nullAndBlankSafeValueSet(Collection<String> input) {
        if (CollectionUtils.isEmpty(input)) {
            return Sets.newHashSet();
        }
        HashSet rv = Sets.newHashSet();
        for (String s : input) {
            if (!StringUtils.isNotBlank((String)s)) continue;
            rv.add(s);
        }
        return rv;
    }

    public static Map deepClone(Map map) {
        if (MapUtils.isEmpty((Map)map)) {
            return new HashMap();
        }
        HashMap newMap = new HashMap();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                value = CollectionUtils.deepClone((Map)value);
            } else if (value instanceof List) {
                value = CollectionUtils.deepClone((List)value);
            }
            newMap.put(key, value);
        }
        return newMap;
    }

    public static List deepClone(List list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        ArrayList newList = Lists.newArrayList();
        for (Object value : list) {
            if (value instanceof Map) {
                value = CollectionUtils.deepClone((Map)value);
            } else if (value instanceof List) {
                value = CollectionUtils.deepClone((List)value);
            }
            newList.add(value);
        }
        return newList;
    }

    public static <T, S> Collection<S> transform(Collection<? extends T> tCollection, Transformer<T, S> transformer) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Lists.newArrayList();
        }
        ArrayList<S> sCollection = new ArrayList<S>();
        for (T t : tCollection) {
            S transformedObject = transformer.transform(t);
            if (transformedObject == null) continue;
            sCollection.add(transformedObject);
        }
        return sCollection;
    }

    public static <T> List<T> filterNull(List<? extends T> tCollection) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Lists.newArrayList();
        }
        ArrayList<T> sCollection = new ArrayList<T>();
        for (T t : tCollection) {
            if (t == null) continue;
            sCollection.add(t);
        }
        return sCollection;
    }

    public static <T> Set<T> filterNull(Set<? extends T> tCollection) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Sets.newHashSet();
        }
        HashSet sCollection = Sets.newHashSet();
        for (T t : tCollection) {
            if (t == null) continue;
            sCollection.add(t);
        }
        return sCollection;
    }

    public static <T, S> Collection<S> transformWithFilter(Collection<T> tCollection, Transformer<T, S> transformer, com.google.common.base.Predicate<T> predicate) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Collections.emptyList();
        }
        ArrayList<S> sCollection = new ArrayList<S>();
        for (T t : tCollection) {
            S transformedObject = transformer.transform(t);
            if (transformedObject == null || !predicate.apply(t)) continue;
            sCollection.add(transformedObject);
        }
        return sCollection;
    }

    public static <T, S> List<S> transformToListWithFilter(Collection<T> tCollection, Transformer<T, S> transformer, com.google.common.base.Predicate<T> predicate) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Collections.emptyList();
        }
        ArrayList<S> sList = new ArrayList<S>();
        for (T t : tCollection) {
            S transformedObject = transformer.transform(t);
            if (transformedObject == null || !predicate.apply(t)) continue;
            sList.add(transformedObject);
        }
        return sList;
    }

    public static <T, S, V> V reduce(Collection<T> tCollection, Transformer<T, S> sTransformer, TransformerWithArgs<S, V, V> accumulator) {
        Object ret = null;
        if (CollectionUtils.isNotEmpty(tCollection)) {
            for (T t : tCollection) {
                S transformedObject = sTransformer.transform(t);
                ret = accumulator.transform(transformedObject, ret);
            }
        }
        return (V)ret;
    }

    public static <T> List<T> filterList(Collection<T> tList, com.google.common.base.Predicate<T> predicate) {
        ArrayList filteredList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(tList)) {
            return filteredList;
        }
        for (T t : tList) {
            boolean add = predicate.apply(t);
            if (!add) continue;
            filteredList.add(t);
        }
        return filteredList;
    }

    public static <T, C extends Collection<T>> Tuple<C, C> partitionBy(Collection<T> tList, CollectionProvider<T, C> targetProvider, com.google.common.base.Predicate<T> predicate) {
        C matching = targetProvider.newCollection();
        C notMatching = targetProvider.newCollection();
        Tuple<C, C> rv = Tuple.of(matching, notMatching);
        if (CollectionUtils.isEmpty(tList)) {
            return rv;
        }
        for (T t : tList) {
            boolean match = predicate.apply(t);
            C target = match ? matching : notMatching;
            target.add(t);
        }
        return rv;
    }

    public static <T> Tuple<List<T>, List<T>> listPartitionBy(Collection<T> tList, com.google.common.base.Predicate<T> predicate) {
        return CollectionUtils.partitionBy(tList, CollectionUtils.listProvider(), predicate);
    }

    public static <T> Tuple<Set<T>, Set<T>> setPartitionBy(Collection<T> tList, com.google.common.base.Predicate<T> predicate) {
        return CollectionUtils.partitionBy(tList, CollectionUtils.setProvider(), predicate);
    }

    public static <T> T filterFirstItemInList(Collection<T> tList, com.google.common.base.Predicate<T> predicate) {
        if (CollectionUtils.isEmpty(tList)) {
            return null;
        }
        for (T t : tList) {
            boolean add = predicate.apply(t);
            if (!add) continue;
            return t;
        }
        return null;
    }

    public static <T> Set<T> filterSet(Collection<T> tSet, com.google.common.base.Predicate<T> predicate) {
        HashSet filteredSet = Sets.newHashSet();
        if (CollectionUtils.isEmpty(tSet)) {
            return filteredSet;
        }
        for (T t : tSet) {
            boolean add = predicate.apply(t);
            if (!add) continue;
            filteredSet.add(t);
        }
        return filteredSet;
    }

    public static <T> Predicate<T> distinctByKey(java.util.function.Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static <T, S> Set<S> transformToSet(Collection<? extends T> tCollection, Transformer<T, S> transformer) {
        return CollectionUtils.transformIterableToSet(tCollection, transformer);
    }

    public static <T, S> Set<S> transformIterableToSet(Iterable<? extends T> iterable, Transformer<T, S> transformer) {
        if (iterable == null) {
            return Sets.newHashSet();
        }
        HashSet<S> sCollection = new HashSet<S>();
        for (T t : iterable) {
            S transform = transformer.transform(t);
            if (transform == null) continue;
            sCollection.add(transform);
        }
        return sCollection;
    }

    public static <T, S> Set<S> transformToConcurrentHashSet(Collection<? extends T> tCollection, Transformer<T, S> transformer) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Sets.newConcurrentHashSet();
        }
        Set sCollection = Sets.newConcurrentHashSet();
        for (T t : tCollection) {
            S transform = transformer.transform(t);
            if (transform == null) continue;
            sCollection.add(transform);
        }
        return sCollection;
    }

    public static <T, S> List<S> transformToList(T[] array, Transformer<T, S> transformer) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Collections.emptyList();
        }
        ArrayList sCollection = Lists.newArrayList();
        for (T t : array) {
            S transform = transformer.transform(t);
            if (transform == null) continue;
            sCollection.add(transform);
        }
        return sCollection;
    }

    public static <T, S> List<S> transformAndAddToList(List<T> input, Transformer<T, List<S>> transformer) {
        if (CollectionUtils.isEmpty(input)) {
            return Collections.emptyList();
        }
        ArrayList sCollection = Lists.newArrayList();
        for (T t : input) {
            List<S> transform = transformer.transform(t);
            if (CollectionUtils.isEmpty(transform)) continue;
            sCollection.addAll(transform);
        }
        return sCollection;
    }

    public static <T, S> Set<S> transformToSet(T[] array, Transformer<T, S> transformer) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return Sets.newHashSet();
        }
        HashSet<S> sCollection = new HashSet<S>();
        for (T t : array) {
            S transform = transformer.transform(t);
            if (transform == null) continue;
            sCollection.add(transform);
        }
        return sCollection;
    }

    public static <From, To> List<To> transformToList(Collection<? extends From> tCollection, Transformer<From, To> transformer) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Lists.newArrayList();
        }
        ArrayList<To> sCollection = new ArrayList<To>();
        for (From t : tCollection) {
            To transformedObject = transformer.transform(t);
            if (transformedObject == null) continue;
            sCollection.add(transformedObject);
        }
        return sCollection;
    }

    public static <From, To> List<To> transformAndAppendToList(Collection<? extends From> tCollection, Transformer<From, To> transformer, List<To> existingCollection) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Lists.newArrayList();
        }
        if (existingCollection == null) {
            existingCollection = new ArrayList<To>();
        }
        for (From t : tCollection) {
            To transformedObject = transformer.transform(t);
            if (transformedObject == null) continue;
            existingCollection.add(transformedObject);
        }
        return existingCollection;
    }

    public static <From, To, Arg> List<To> transformToListWithArgs(Collection<? extends From> tCollection, TransformerWithArgs<From, To, Arg> transformer, Arg arg) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Lists.newArrayList();
        }
        ArrayList<To> sCollection = new ArrayList<To>();
        for (From t : tCollection) {
            To transformedObject = transformer.transform(t, arg);
            if (transformedObject == null) continue;
            sCollection.add(transformedObject);
        }
        return sCollection;
    }

    public static <From, To> void transformAndAddToCollection(Collection<? extends From> sourceCollection, Transformer<From, To> transformer, Collection<To> targetCollection) {
        PreConditions.notNull(targetCollection);
        PreConditions.notNull(transformer);
        for (From f : CollectionUtils.nullSafeCollection(sourceCollection)) {
            targetCollection.add(transformer.transform(f));
        }
    }

    public static <From, To, Arg> List<To> transformToListWithListArgs(List<? extends From> tCollection, TransformerWithArgs<From, To, Arg> transformer, List<Arg> argList) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Lists.newArrayList();
        }
        ArrayList<To> sCollection = new ArrayList<To>();
        for (int i = 0; i < tCollection.size(); ++i) {
            Arg arg;
            From t = tCollection.get(i);
            To transformedObject = transformer.transform(t, arg = argList.get(i));
            if (transformedObject == null) continue;
            sCollection.add(transformedObject);
        }
        return sCollection;
    }

    public static <T, S> List<S> transformToFlattenedList(Collection<T> tCollection, Transformer<T, Collection<S>> transformer) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Collections.emptyList();
        }
        ArrayList<S> flattenedList = new ArrayList<S>();
        for (T t : tCollection) {
            Collection<S> transformedCollection = transformer.transform(t);
            if (!CollectionUtils.isNotEmpty(transformedCollection)) continue;
            flattenedList.addAll(transformedCollection);
        }
        return flattenedList;
    }

    public static <From, To, Arg> Map<From, To> transformToMapWithArgs(Collection<? extends From> tCollection, TransformerWithArgs<From, To, Arg> transformer, Arg arg) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Maps.newHashMap();
        }
        HashMap sMap = Maps.newHashMap();
        for (From from : tCollection) {
            To transformedObject = transformer.transform(from, arg);
            if (transformedObject == null) continue;
            sMap.put(from, transformedObject);
        }
        return sMap;
    }

    public static <From, To, Arg> Map<To, From> transformToMapWithArguments(Collection<? extends From> tCollection, TransformerWithArgs<From, To, Arg> transformer, Arg arg) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Maps.newHashMap();
        }
        HashMap sMap = Maps.newHashMap();
        for (From from : tCollection) {
            To transformedObject = transformer.transform(from, arg);
            if (transformedObject == null) continue;
            sMap.put(transformedObject, from);
        }
        return sMap;
    }

    public static <From, To> List<To> transformToListWithNull(Collection<From> tCollection, Transformer<From, To> transformer) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Lists.newArrayList();
        }
        ArrayList<To> sCollection = new ArrayList<To>();
        for (From t : tCollection) {
            if (t == null) {
                sCollection.add(null);
                continue;
            }
            To transformedObject = transformer.transform(t);
            sCollection.add(transformedObject);
        }
        return sCollection;
    }

    public static <ParentT, ChildT extends ParentT, S> Map<S, ChildT> transformToMap(Collection<ChildT> tCollection, Transformer<ParentT, S> transformer) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Maps.newHashMap();
        }
        return CollectionUtils.transformCollectionToMap(tCollection, transformer);
    }

    public static <T, S> LinkedHashMap<S, T> transformToLinkedHashMap(Collection<T> tCollection, Transformer<T, S> transformer) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Maps.newLinkedHashMap();
        }
        return CollectionUtils.transformCollectionToLinkedHashMap(tCollection, transformer);
    }

    public static <K, K1, V> LinkedHashMap<K1, V> transformToLinkedHashMap(Collection<K> kCollection, Transformer<K, K1> keyTransformer, Transformer<K, V> valueTransformer) {
        if (CollectionUtils.isEmpty(kCollection)) {
            return Maps.newLinkedHashMap();
        }
        LinkedHashMap<K1, V> map = new LinkedHashMap<K1, V>();
        for (K k : kCollection) {
            K1 k1 = keyTransformer.transform(k);
            V v = valueTransformer.transform(k);
            if (k1 == null && v == null) continue;
            map.put(k1, v);
        }
        return map;
    }

    public static <T, S> Map<S, Collection<T>> transformToMultiMap(Collection<T> tCollection, Transformer<T, S> transformer) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (T value : tCollection) {
            if (value == null) continue;
            hashMultimap.put(transformer.transform(value), value);
        }
        return hashMultimap.asMap();
    }

    public static <T, S> Map<S, Collection<T>> transformToLinkedMultiMap(Collection<T> tCollection, Transformer<T, S> transformer) {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        for (T value : tCollection) {
            if (value == null) continue;
            linkedHashMultimap.put(transformer.transform(value), value);
        }
        return linkedHashMultimap.asMap();
    }

    public static <K, V, E> Map<K, V> transformToValueMap(Collection<E> eCollection, Transformer<? super E, K> transformer1, Transformer<? super E, V> transformer2) {
        if (CollectionUtils.isEmpty(eCollection)) {
            return Maps.newHashMap();
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (E e : eCollection) {
            K k = transformer1.transform(e);
            V v = transformer2.transform(e);
            if (k == null && v == null) continue;
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> transformToMultiValuedMapList(Collection<V> collection, Transformer<V, K> transformer) {
        HashMap rv = Maps.newHashMap();
        if (CollectionUtils.isEmpty(collection)) {
            return rv;
        }
        for (V e : collection) {
            K key;
            if (e == null || (key = transformer.transform(e)) == null) continue;
            CollectionUtils.addToMultivaluedMapList(rv, key, e);
        }
        return rv;
    }

    public static <K, V, E> Map<K, List<V>> transformToMultiValuedMapList(Collection<E> collection, Transformer<E, K> keyTransformer, Transformer<E, V> valueTransformer) {
        HashMap rv = Maps.newHashMap();
        if (CollectionUtils.isEmpty(collection)) {
            return rv;
        }
        for (E e : collection) {
            V value;
            K key;
            if (e == null || (key = keyTransformer.transform(e)) == null || (value = valueTransformer.transform(e)) == null) continue;
            CollectionUtils.addToMultivaluedMapList(rv, key, value);
        }
        return rv;
    }

    public static <K, V> Map<K, Set<V>> transformToMultiValuedMapSet(Collection<V> collection, Transformer<V, K> transformer) {
        HashMap rv = Maps.newHashMap();
        if (CollectionUtils.isEmpty(collection)) {
            return rv;
        }
        for (V e : collection) {
            K key;
            if (e == null || (key = transformer.transform(e)) == null) continue;
            CollectionUtils.addToMultivaluedMapSet(rv, key, e);
        }
        return rv;
    }

    public static <C, K, V> Map<K, Set<V>> transformToMultiValuedMapSet(Collection<C> collection, Transformer<C, K> keyTransformer, Transformer<C, V> valueTransformer) {
        HashMap rv = Maps.newHashMap();
        for (C e : collection) {
            V value;
            K key;
            if (e == null || (key = keyTransformer.transform(e)) == null || (value = valueTransformer.transform(e)) == null) continue;
            CollectionUtils.addToMultivaluedMapSet(rv, key, value);
        }
        return rv;
    }

    public static <T, S> Map<T, S> transformToMapWithEqualKeysAndValues(Collection<T> tCollection, Collection<S> sCollection) {
        if (CollectionUtils.isEmpty(tCollection) || CollectionUtils.isEmpty(sCollection)) {
            return Maps.newHashMap();
        }
        if (tCollection.size() != sCollection.size()) {
            throw new IllegalArgumentException("Both Collections should contain the same number of elements");
        }
        Iterator<T> tIterator = tCollection.iterator();
        Iterator<S> sIterator = sCollection.iterator();
        LinkedHashMap rv = Maps.newLinkedHashMap();
        while (tIterator.hasNext() && sIterator.hasNext()) {
            rv.put(tIterator.next(), sIterator.next());
        }
        return rv;
    }

    public static <T, S> Map<S, T> transformToMutableMap(Collection<T> tCollection, Transformer<T, S> transformer) {
        if (CollectionUtils.isEmpty(tCollection)) {
            return Maps.newHashMap();
        }
        return CollectionUtils.transformCollectionToMap(tCollection, transformer);
    }

    private static <ParentT, ChildT extends ParentT, S> Map<S, ChildT> transformCollectionToMap(Collection<ChildT> tCollection, Transformer<ParentT, S> transformer) {
        HashMap<S, ChildT> map = new HashMap<S, ChildT>();
        for (ChildT t : tCollection) {
            S transform = transformer.transform(t);
            if (transform == null) continue;
            map.put(transform, t);
        }
        return map;
    }

    private static <T, S> LinkedHashMap<S, T> transformCollectionToLinkedHashMap(Collection<T> tCollection, Transformer<T, S> transformer) {
        LinkedHashMap<S, T> map = new LinkedHashMap<S, T>();
        for (T t : tCollection) {
            S transform = transformer.transform(t);
            if (transform == null) continue;
            map.put(transform, t);
        }
        return map;
    }

    public static <T> T getFirstElementFromCollection(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        return collection.iterator().next();
    }

    public static <T> T getFirstNonNullElementFromCollection(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        for (T next : collection) {
            if (next == null) continue;
            return next;
        }
        return null;
    }

    public static <T> T getFirstNonNullElement(T[] objects) {
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return null;
        }
        for (T next : objects) {
            if (next == null) continue;
            return next;
        }
        return null;
    }

    public static <T> T head(Collection<T> collection) {
        return CollectionUtils.getFirstElementFromCollection(CollectionUtils.nullSafeCollection(collection));
    }

    public static <T> CollectionProvider<T, Set<T>> setProvider() {
        return new CollectionProvider<T, Set<T>>(){

            @Override
            public Set<T> newCollection() {
                return Sets.newHashSet();
            }
        };
    }

    public static <T> CollectionProvider<T, List<T>> listProvider() {
        return new CollectionProvider<T, List<T>>(){

            @Override
            public List<T> newCollection() {
                return Lists.newArrayList();
            }
        };
    }

    public static List<String> parseCommaSeparatedString(String input) {
        return CollectionUtils.parseDelimiterSeparatedString(input, ",");
    }

    public static <T> List<T> parseCommaSeparatedString(String input, Transformer<String, T> transformer) {
        List<String> strList = CollectionUtils.parseCommaSeparatedString(input);
        ArrayList ret = Lists.newArrayList();
        for (String str : strList) {
            T t = transformer.transform(str);
            if (t == null) continue;
            ret.add(t);
        }
        return ret;
    }

    public static Set<String> parseCommaSeparatedStringToSet(String input) {
        return CollectionUtils.parseDelimiterSeparatedStringToSet(input, ",");
    }

    public static List<String> parseDelimiterSeparatedString(String input, String delimiter) {
        return CollectionUtils.parseDelimiterSeparatedString(input, delimiter, true);
    }

    public static Set<String> parseDelimiterSeparatedStringToSet(String input, String delimiter) {
        return CollectionUtils.parseDelimiterSeparatedStringToSet(input, delimiter, true);
    }

    public static List<String> parseDelimiterSeparatedString(String input, String delimiter, boolean trimTokens) {
        if (StringUtils.isBlank((String)input)) {
            return Collections.emptyList();
        }
        input = input.replaceAll("]", "");
        input = input.replaceAll("\\[", "");
        ArrayList<String> inputList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(input, delimiter);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            inputList.add(token);
        }
        return inputList;
    }

    public static Set<String> parseDelimiterSeparatedStringToSet(String input, String delimiter, boolean trimTokens) {
        if (StringUtils.isBlank((String)input)) {
            return Collections.emptySet();
        }
        input = input.replaceAll("]", "");
        input = input.replaceAll("\\[", "");
        HashSet<String> inputSet = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(input, delimiter);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            inputSet.add(token);
        }
        return inputSet;
    }

    public static List<String> parseListWithCommaSeparatedElements(List<String> values) {
        return CollectionUtils.toList(CollectionUtils.parseCollectionWithCommaSeparatedElements(values));
    }

    public static Collection<String> parseCollectionWithCommaSeparatedElements(Collection<String> values) {
        return CollectionUtils.parseCollectionWithDelimiterSeparatedElements(values, ",");
    }

    public static Collection<String> parseCollectionWithDelimiterSeparatedElements(Collection<String> values, String delimiter) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (String value : values) {
            List<String> elements = CollectionUtils.parseDelimiterSeparatedString(value, delimiter);
            result.addAll(elements);
        }
        return result;
    }

    public static List<String> parseCollectionAndDropDups(Collection<String> values, String delimiter) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        HashSet result = Sets.newHashSet();
        for (String value : values) {
            List<String> elements = CollectionUtils.parseDelimiterSeparatedString(value, delimiter);
            result.addAll(elements);
        }
        return Lists.newArrayList((Iterable)result);
    }

    public static <KeyType, EntityType> Map<KeyType, Collection<EntityType>> groupByKey(Collection<EntityType> collectionData, Transformer<EntityType, KeyType> transformer) {
        if (CollectionUtils.isEmpty(collectionData)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (EntityType data : collectionData) {
            KeyType transform = transformer.transform(data);
            if (transform == null) continue;
            Collection values = (Collection)result.get(transform);
            if (values == null) {
                values = Lists.newArrayList();
                result.put(transform, values);
            }
            values.add(data);
        }
        return result;
    }

    public static <KeyType, EntityType, ValueType> Map<KeyType, Collection<ValueType>> groupByKey(Collection<EntityType> collectionData, Transformer<EntityType, KeyType> groupTransformer, Transformer<EntityType, ValueType> valueTransformer) {
        if (CollectionUtils.isEmpty(collectionData)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (EntityType data : collectionData) {
            KeyType transform = groupTransformer.transform(data);
            if (transform == null) continue;
            Collection values = (Collection)result.get(transform);
            if (values == null) {
                values = Lists.newArrayList();
                result.put(transform, values);
            }
            values.add(valueTransformer.transform(data));
        }
        return result;
    }

    public static <KeyType, EntityType, ValueType> Map<KeyType, ValueType> transformToMap(Collection<EntityType> collectionData, Transformer<EntityType, KeyType> groupTransformer, Transformer<EntityType, ValueType> valueTransformer) {
        if (CollectionUtils.isEmpty(collectionData)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (EntityType data : collectionData) {
            ValueType value;
            KeyType key = groupTransformer.transform(data);
            if (key == null || (value = valueTransformer.transform(data)) == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static <KeyType, EntityType> Map<KeyType, List<EntityType>> groupInListByKey(Collection<EntityType> collectionData, Transformer<EntityType, KeyType> transformer) {
        if (CollectionUtils.isEmpty(collectionData)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (EntityType data : collectionData) {
            KeyType transform = transformer.transform(data);
            if (transform == null) continue;
            List values = (List)result.get(transform);
            if (values == null) {
                values = Lists.newArrayList();
                result.put(transform, values);
            }
            values.add(data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K> void addOrUdpdateCount(Map<K, AtomicInteger> map, K key) {
        if (map == null) {
            return;
        }
        AtomicInteger value = map.get(key);
        if (value == null) {
            Map<K, AtomicInteger> map2 = map;
            synchronized (map2) {
                value = map.get(key);
                if (value == null) {
                    value = new AtomicInteger(0);
                    map.put(key, value);
                }
            }
        }
        value.incrementAndGet();
    }

    public static <KeyType, ValueType> Map<KeyType, List<ValueType>> groupByKeyMultiValued(Collection<ValueType> data, Transformer<ValueType, List<KeyType>> transformer) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyMap();
        }
        HashMap rv = Maps.newHashMap();
        for (ValueType valueType : data) {
            List<KeyType> keyTypes = transformer.transform(valueType);
            if (!CollectionUtils.isNotEmpty(keyTypes)) continue;
            for (KeyType transform : keyTypes) {
                if (transform == null) continue;
                CollectionUtils.addToMultivaluedMapList(rv, transform, valueType);
            }
        }
        return rv;
    }

    public static <KeyType, ValueType> Set<KeyType> transformToSetWithMultiValueKeys(Collection<ValueType> data, Transformer<ValueType, List<KeyType>> transformer) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptySet();
        }
        HashSet rv = Sets.newHashSet();
        for (ValueType valueType : data) {
            List<KeyType> keyTypes = transformer.transform(valueType);
            if (!CollectionUtils.isNotEmpty(keyTypes)) continue;
            for (KeyType transform : keyTypes) {
                if (transform == null) continue;
                rv.add(transform);
            }
        }
        return rv;
    }

    public static List<String> trimmedAndLowerCaseList(Collection<String> values) {
        return CollectionUtils.toList(CollectionUtils.trimmedAndLowerCaseCollection(values));
    }

    public static Collection<String> trimmedAndLowerCaseCollection(Collection<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        return CollectionUtils.nullAndEmptySafeValueCollection(CollectionUtils.transformToList(values, new Transformer<String, String>(){

            @Override
            public String transform(String tag) {
                if (StringUtils.isNotBlank((String)tag)) {
                    tag = tag.trim().toLowerCase();
                    return tag;
                }
                return null;
            }
        }));
    }

    public static List<Integer> transformLongToIntegerList(List<Long> longList) {
        Function<Long, Integer> fu = new Function<Long, Integer>(){

            public Integer apply(@Nullable Long theVal) {
                return theVal != null ? theVal.intValue() : 0;
            }
        };
        return Lists.transform(longList, (Function)fu);
    }

    public static void removeDuplicatesPreservingOrder(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        LinkedHashSet<String> valueSet = new LinkedHashSet<String>();
        valueSet.addAll(values);
        if (values.size() == valueSet.size()) {
            return;
        }
        values.clear();
        values.addAll(valueSet);
    }

    public static <T> List<T> removeDuplicates(List<T> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            HashSet uniqueValues = Sets.newHashSet(values);
            ArrayList uniqueValuesList = Lists.newArrayList();
            for (T value : values) {
                if (!uniqueValues.contains(value)) continue;
                uniqueValuesList.add(value);
                uniqueValues.remove(value);
            }
            return uniqueValuesList;
        }
        return values;
    }

    public static List<String> transFormToStringList(Collection<?> ids) {
        return CollectionUtils.transformToList(ids, OBJECT_TO_STR_TRANSFORMER);
    }

    public static List<Long> transFormToLongList(Collection<?> ids) {
        return CollectionUtils.transformToList(ids, OBJECT_LONG_TRANSFORMER);
    }

    public static List<Integer> transFormToIntegerList(Collection<?> ids) {
        return CollectionUtils.transformToList(ids, OBJECT_TO_INT_TRANSFORMER);
    }

    public static Long[] transformObjectToLongArray(Collection<?> ids) {
        List<Long> longValues = CollectionUtils.transFormToLongList(ids);
        return longValues.toArray(new Long[longValues.size()]);
    }

    public static List<Double> convertDoubleArrayToList(double[] values) {
        ArrayList valuesList = Lists.newArrayList();
        for (double value : values) {
            valuesList.add(value);
        }
        return valuesList;
    }

    public static List<Long> convertLongArrayToList(long[] values) {
        ArrayList<Long> valuesList = new ArrayList<Long>();
        for (long value : values) {
            valuesList.add(value);
        }
        return valuesList;
    }

    public static double[] convertDoubleListToArray(List values) {
        if (CollectionUtils.isEmpty(values)) {
            return ArrayUtils.EMPTY_DOUBLE_ARRAY;
        }
        double[] valuesArray = new double[values.size()];
        int index = 0;
        for (Object value : values) {
            valuesArray[index++] = ((Number)value).doubleValue();
        }
        return valuesArray;
    }

    public static List<Long> convertToLongIds(Collection<String> ids) {
        return CollectionUtils.transformToList(ids, STR_TO_LONG_TRANSFORMER);
    }

    public static Set<Integer> convertToIntegerIds(Collection<String> ids) {
        return CollectionUtils.transformToSet(ids, STR_TO_INTEGER_TRANSFORMER);
    }

    public static Set<Long> convertToNullAndEmptySafeLongIdsSet(List<String> ids) {
        return CollectionUtils.transformToSet(CollectionUtils.nullAndEmptySafeValueCollection(ids), STR_TO_LONG_TRANSFORMER);
    }

    public static <T> Array<T> toFunctionalArray(T[] inputColl) {
        return Array.array((Object[])inputColl);
    }

    public static <T> Array<T> toFunctionalArray(Collection<T> inputColl) {
        return Array.array((Object[])CollectionUtils.toTypedArray(inputColl));
    }

    public static <T> T[] toTypedArray(Collection<? extends T> inputColl) {
        return inputColl.toArray();
    }

    public static <K, V> Map<K, V> nullAndEmptySafeMap(Map<K, V> map) {
        Map<K, V> nullSafeMap = CollectionUtils.nullSafeMap(map);
        nullSafeMap = CollectionUtils.copyMap(nullSafeMap);
        Iterator<Map.Entry<K, V>> itr = nullSafeMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<K, V> entry = itr.next();
            V value = entry.getValue();
            if (value == null) {
                itr.remove();
            }
            if (!(value instanceof String) || !StringUtils.isEmpty((String)((String)value))) continue;
            itr.remove();
        }
        return nullSafeMap;
    }

    public static <K, V> Map<K, V> nullAndEmptySafeKeyValueMap(Map<K, V> map) {
        Map<K, V> nullSafeMap = CollectionUtils.nullSafeMutableMap(map);
        Iterator<Map.Entry<K, V>> itr = nullSafeMap.entrySet().iterator();
        while (itr.hasNext()) {
            V value;
            Map.Entry<K, V> entry = itr.next();
            K key = entry.getKey();
            if (key == null) {
                itr.remove();
            }
            if (key instanceof String && StringUtils.isEmpty((String)((String)key))) {
                itr.remove();
            }
            if ((value = entry.getValue()) == null) {
                itr.remove();
            }
            if (!(value instanceof String) || !StringUtils.isEmpty((String)((String)value))) continue;
            itr.remove();
        }
        return nullSafeMap;
    }

    public static <K, V> Map<K, List<V>> nullAndEmptySafeMultiValuedMap(Map<K, List<V>> map) {
        Map<K, List<V>> nullSafeMap = CollectionUtils.nullSafeMap(map);
        nullSafeMap = CollectionUtils.copyMultiValuedMap(nullSafeMap);
        Iterator<Map.Entry<K, List<V>>> itr = nullSafeMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            List values = CollectionUtils.nullSafeValueList((Collection)entry.getValue());
            if (CollectionUtils.isEmpty(values)) {
                itr.remove();
                continue;
            }
            entry.setValue(values);
        }
        return nullSafeMap;
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> nullSafeMap) {
        HashMap<K, V> newMap = new HashMap<K, V>();
        newMap.putAll(nullSafeMap);
        return newMap;
    }

    private static <K, V> Map<K, List<V>> copyMultiValuedMap(Map<K, List<V>> nullSafeMap) {
        HashMap<K, List<V>> newMap = new HashMap<K, List<V>>();
        newMap.putAll(nullSafeMap);
        return newMap;
    }

    public static <K, V> Map<K, List<V>> nullAndEmptySafeMergeMultiValuedMaps(Map<K, List<V>> oldMap, Map<K, List<V>> newMap) {
        oldMap = CollectionUtils.nullAndEmptySafeMultiValuedMap(oldMap);
        newMap = CollectionUtils.nullAndEmptySafeMultiValuedMap(newMap);
        return CollectionUtils.mergeMultiValuedMaps(oldMap, newMap);
    }

    public static <K, V> Map<K, V> nullAndEmptySafeMergeMaps(Map<K, V> oldMap, Map<K, V> newMap) {
        oldMap = CollectionUtils.nullAndEmptySafeMap(oldMap);
        newMap = CollectionUtils.nullAndEmptySafeMap(newMap);
        return CollectionUtils.mergeMaps(oldMap, newMap);
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> oldMap, Map<K, V> newMap) {
        HashMap mergedMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty(oldMap)) {
            mergedMap.putAll(oldMap);
        }
        if (MapUtils.isNotEmpty(newMap)) {
            mergedMap.putAll(newMap);
        }
        return mergedMap;
    }

    public static <K, V> Map<K, List<V>> mergeMultiValuedMaps(Map<K, List<V>> oldMap, Map<K, List<V>> newMap) {
        HashMap mergedMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty(oldMap)) {
            mergedMap.putAll(oldMap);
        }
        if (MapUtils.isNotEmpty(newMap)) {
            for (Map.Entry<K, List<V>> entry : newMap.entrySet()) {
                K key = entry.getKey();
                mergedMap.put(key, CollectionUtils.nullAndEmptySafeMergeLists((List)mergedMap.get(key), entry.getValue()));
            }
        }
        return mergedMap;
    }

    public static <K, V> Map<K, Set<V>> mergeMultiUniqueValuedMaps(Map<K, Set<V>> oldMap, Map<K, Set<V>> newMap) {
        HashMap mergedMap = Maps.newHashMap();
        if (MapUtils.isNotEmpty(oldMap)) {
            mergedMap.putAll(oldMap);
        }
        if (MapUtils.isNotEmpty(newMap)) {
            for (Map.Entry<K, Set<V>> entry : newMap.entrySet()) {
                K key = entry.getKey();
                mergedMap.put(key, CollectionUtils.mergeSetsToSingleSet(oldMap.get(key), entry.getValue()));
            }
        }
        return mergedMap;
    }

    public static <K> Set<K> mergeSetsToSingleSet(Set<K> set1, Set<K> set2) {
        HashSet mergedSet = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(set1)) {
            mergedSet.addAll(set1);
        }
        if (CollectionUtils.isNotEmpty(set2)) {
            mergedSet.addAll(set2);
        }
        return mergedSet;
    }

    public static <T> List<T> mergeCollectionsToList(Collection<T> oldValues, Collection<T> newValues) {
        if (CollectionUtils.isEmpty(oldValues)) {
            return newValues == null ? Lists.newArrayList() : Lists.newArrayList(newValues);
        }
        if (CollectionUtils.isEmpty(newValues)) {
            return oldValues == null ? Lists.newArrayList() : Lists.newArrayList(oldValues);
        }
        HashSet oldValuesSet = Sets.newHashSet(oldValues);
        ArrayList mergedList = Lists.newArrayList(oldValues);
        for (T newValue : newValues) {
            if (oldValuesSet.contains(newValue)) continue;
            mergedList.add(newValue);
        }
        return mergedList;
    }

    public static <T> List<T> mergeLists(List<T> oldValues, List<T> newValues) {
        return CollectionUtils.mergeCollectionsToList(oldValues, newValues);
    }

    public static <T> List<T> nullAndEmptySafeMergeLists(List<T> oldValues, List<T> newValues) {
        List<T> cleanOldValues = CollectionUtils.nullAndEmptySafeValueList(oldValues);
        List<T> cleanNewValues = CollectionUtils.nullAndEmptySafeValueList(newValues);
        if (CollectionUtils.isEmpty(cleanOldValues)) {
            return cleanNewValues;
        }
        if (CollectionUtils.isEmpty(cleanNewValues)) {
            return cleanOldValues;
        }
        ArrayList mergedList = Lists.newArrayList(cleanOldValues);
        for (T newValue : cleanNewValues) {
            if (cleanOldValues.contains(newValue)) continue;
            mergedList.add(newValue);
        }
        return mergedList;
    }

    public static <T> String joinListElements(Collection<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return Joiner.on((String)",").join(CollectionUtils.nullAndEmptySafeValueCollection(list));
    }

    public static <K, V> Cache<K, V> buildCache(int concurrency, int cacheSize) {
        return CacheBuilder.newBuilder().concurrencyLevel(concurrency).maximumSize((long)cacheSize).build();
    }

    public static <K, V> Cache<K, V> buildTimeBasedCache(TimeUnit timeUnit, int expiryDuration, int cacheSize) {
        return CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize((long)cacheSize).expireAfterWrite((long)expiryDuration, timeUnit).build();
    }

    public static <K, V> Cache<K, V> buildTimeBasedCache(int concurrency, TimeUnit timeUnit, int expiryDuration, int cacheSize) {
        return CacheBuilder.newBuilder().concurrencyLevel(concurrency).maximumSize((long)cacheSize).expireAfterWrite((long)expiryDuration, timeUnit).build();
    }

    public static <K, V> Cache<K, V> buildTimeBasedCacheWithListener(TimeUnit timeUnit, int expiryDuration, int cacheSize, RemovalListener removalListener) {
        return CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize((long)cacheSize).expireAfterWrite((long)expiryDuration, timeUnit).removalListener(removalListener).build();
    }

    public static <K> List<K> mergeListsWithNoDuplicate(List<K> list1, List<K> list2) {
        if (CollectionUtils.isEmpty(list1) && CollectionUtils.isEmpty(list2)) {
            return Collections.emptyList();
        }
        ArrayList mergedList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list1)) {
            mergedList.addAll(list2);
        } else if (CollectionUtils.isEmpty(list2)) {
            mergedList.addAll(list1);
        } else {
            HashSet allValues = Sets.newHashSet();
            allValues.addAll(list1);
            allValues.addAll(list2);
            mergedList.addAll(allValues);
        }
        return mergedList;
    }

    public static <K> List<K> mergeCollectionsWithNoDuplicate(Collection<K> collection1, Collection<K> collection2) {
        if (CollectionUtils.isEmpty(collection1) && CollectionUtils.isEmpty(collection2)) {
            return Collections.emptyList();
        }
        ArrayList mergedList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(collection1)) {
            mergedList.addAll(collection2);
        } else if (CollectionUtils.isEmpty(collection2)) {
            mergedList.addAll(collection1);
        } else {
            HashSet allValues = Sets.newHashSet();
            allValues.addAll(collection1);
            allValues.addAll(collection2);
            mergedList.addAll(allValues);
        }
        return mergedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void addToMultivaluedMapList(Map<K, List<V>> map, K key, V value) {
        if (map == null) {
            return;
        }
        if (key == null || value == null) {
            return;
        }
        Map<K, List<LinkedList>> map2 = map;
        synchronized (map2) {
            LinkedList values = map.get(key);
            if (values == null) {
                values = Lists.newLinkedList();
                map.put(key, values);
            }
            values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, T, V> void addToNestedMap(Map<K, Map<T, V>> map, K outerKey, T innerKey, V value) {
        if (map == null || outerKey == null || innerKey == null) {
            return;
        }
        Map<K, Map<T, HashMap>> map2 = map;
        synchronized (map2) {
            HashMap innerMap = map.get(outerKey);
            if (innerMap == null) {
                innerMap = Maps.newHashMap();
                map.put(outerKey, innerMap);
            }
            innerMap.put(innerKey, value);
        }
    }

    public static <K, T, V> V getFromNestedMap(Map<K, Map<T, V>> map, K outerKey, T innerKey) {
        if (map == null || outerKey == null || innerKey == null) {
            return null;
        }
        Map<T, V> innerMap = map.get(outerKey);
        if (innerMap != null) {
            return innerMap.get(innerKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void addToMultivaluedMapCollection(Map<K, Collection<V>> map, K key, V value) {
        if (map == null) {
            return;
        }
        if (key == null || value == null) {
            return;
        }
        Map<K, Collection<LinkedList>> map2 = map;
        synchronized (map2) {
            LinkedList values = map.get(key);
            if (values == null) {
                values = Lists.newLinkedList();
                map.put(key, values);
            }
            values.add(value);
        }
    }

    public static <K, V> void addToMultivaluedMapList(Map<K, List<V>> map, K key, Collection<V> values) {
        CollectionUtils.addAllToMultivaluedMapList(map, key, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void addAllToMultivaluedMapList(Map<K, List<V>> map, K key, Collection<V> values) {
        if (map == null) {
            return;
        }
        if (key == null || CollectionUtils.isEmpty(values)) {
            return;
        }
        Map<K, List<ArrayList>> map2 = map;
        synchronized (map2) {
            ArrayList existing = map.get(key);
            if (existing == null) {
                existing = Lists.newArrayList();
                map.put(key, existing);
            }
            existing.addAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void addToMultivaluedMapSet(Map<K, Set<V>> map, K key, V value) {
        if (map == null) {
            return;
        }
        if (key == null || value == null) {
            return;
        }
        Map<K, Set<LinkedHashSet>> map2 = map;
        synchronized (map2) {
            LinkedHashSet values = map.get(key);
            if (values == null) {
                values = Sets.newLinkedHashSet();
                map.put(key, values);
            }
            values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V extends Comparable> void addToMultivaluedMapTreeSet(Map<K, Set<V>> map, K key, V value) {
        if (map == null) {
            return;
        }
        if (key == null || value == null) {
            return;
        }
        Map<K, Set<TreeSet>> map2 = map;
        synchronized (map2) {
            TreeSet values = map.get(key);
            if (values == null) {
                values = Sets.newTreeSet();
                map.put(key, values);
            }
            values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void addToMultivaluedMapSet(Map<K, Set<V>> map, K key, Collection<V> values) {
        if (map == null) {
            return;
        }
        if (key == null || CollectionUtils.isEmpty(values)) {
            return;
        }
        Map<K, Set<HashSet>> map2 = map;
        synchronized (map2) {
            HashSet existing = map.get(key);
            if (existing == null) {
                existing = Sets.newHashSet();
                map.put(key, existing);
            }
            existing.addAll(values);
        }
    }

    public static <K, V> void putToMapIfNotNull(Map<K, V> map, K key, V value) {
        PreConditions.notNull(map);
        if (key == null || value == null) {
            return;
        }
        map.put(key, value);
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static boolean isEmpty(Object[] array) {
        return ArrayUtils.isEmpty((Object[])array);
    }

    public static boolean isNotEmpty(Object[] array) {
        return !CollectionUtils.isEmpty(array);
    }

    public static String getDelimiterSeparatedMethod(Collection<String> values, String delimiter) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        if (delimiter == null) {
            delimiter = ":";
        }
        String rv = "";
        for (String value : values) {
            rv = rv + value + delimiter;
        }
        rv = rv.substring(0, rv.length() - 1);
        return rv;
    }

    public static <T> String getDelimiterSeparatedCollection(Collection<T> values, String delimiter) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        if (delimiter == null) {
            delimiter = ":";
        }
        String rv = "";
        for (T value : values) {
            rv = rv + value.toString() + delimiter;
        }
        rv = rv.substring(0, rv.length() - delimiter.length());
        return rv;
    }

    public static String getDelimiterSeparatedMethodForPaidExport(Collection<String> values, String delimiter, String appendedString) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        if (delimiter == null) {
            delimiter = ",";
        }
        String rv = "";
        for (String value : values) {
            rv = rv + appendedString + value + delimiter;
        }
        rv = rv.substring(0, rv.length() - 1);
        return rv;
    }

    public static <T> List<T> mergeBatchesToSingleCollection(Collection<List<T>> batches) {
        if (CollectionUtils.isEmpty(batches)) {
            return Collections.emptyList();
        }
        ArrayList rv = Lists.newArrayList();
        for (List<T> batch : batches) {
            if (!CollectionUtils.isNotEmpty(batch)) continue;
            rv.addAll(batch);
        }
        return rv;
    }

    public static <T> Set<T> mergeBatchesToSingleSet(Collection<List<T>> batches) {
        if (CollectionUtils.isEmpty(batches)) {
            return Collections.emptySet();
        }
        HashSet rv = Sets.newHashSet();
        for (List<T> batch : batches) {
            if (!CollectionUtils.isNotEmpty(batch)) continue;
            rv.addAll(batch);
        }
        return rv;
    }

    public static <T> Collection<Set<T>> createBatchesOfSet(Collection<T> data, int batchSize) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        ArrayList<Set<T>> batchesAsSet = new ArrayList<Set<T>>();
        int count = 0;
        HashSet batchedData = Sets.newHashSet();
        for (T t : data) {
            batchedData.add(t);
            if (++count % batchSize != 0) continue;
            batchesAsSet.add(batchedData);
            batchedData = Sets.newHashSet();
        }
        if (CollectionUtils.isNotEmpty(batchedData)) {
            batchesAsSet.add(batchedData);
        }
        return batchesAsSet;
    }

    public static <K, V> Map<V, K> reverseMap(Map<K, V> map) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V> Map<V, List<K>> reverseMapToMultivalued(Map<K, V> map) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            CollectionUtils.addToMultivaluedMapList(result, entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V> Map<V, List<K>> reverseMultivaluedMapList(Map<K, List<V>> map) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            for (V value : CollectionUtils.nullSafeList(entry.getValue())) {
                CollectionUtils.addToMultivaluedMapList(result, value, entry.getKey());
            }
        }
        return result;
    }

    public static <K, V> Map<V, K> reverseMultiValuedMapListToMap(Map<K, List<V>> map) {
        if (CollectionUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        HashMap<V, K> result = new HashMap<V, K>();
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            for (V value : CollectionUtils.nullSafeList(entry.getValue())) {
                if (value == null) continue;
                result.put(value, entry.getKey());
            }
        }
        return result;
    }

    public static <S> List<S> reverseList(List<S> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        ArrayList result = Lists.newArrayList();
        for (int i = list.size() - 1; i >= 0; --i) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <K, V> List<Tuple<K, V>> transformMapToTuples(Map<K, List<V>> map) {
        if (MapUtils.isEmpty(map)) {
            return Collections.emptyList();
        }
        ArrayList rv = Lists.newArrayList();
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            if (!CollectionUtils.isNotEmpty(entry.getValue())) continue;
            for (V v : entry.getValue()) {
                rv.add(Tuple.of(entry.getKey(), v));
            }
        }
        return rv;
    }

    public static <K, V> Map<K, V> transformTuplesToMap(List<Tuple<K, V>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap rv = Maps.newHashMap();
        for (Tuple<K, V> tuple : list) {
            if (tuple == null || tuple.v1() == null) continue;
            rv.put(tuple.v1(), tuple.v2());
        }
        return rv;
    }

    public static <T> Set<T> mergeSetsToSingleSet(Collection<Set<T>> batches) {
        if (CollectionUtils.isEmpty(batches)) {
            return Collections.emptySet();
        }
        HashSet rv = Sets.newHashSet();
        for (Collection collection : batches) {
            if (!CollectionUtils.isNotEmpty(collection)) continue;
            rv.addAll(collection);
        }
        return rv;
    }

    public static List<String> splitCSV(String csv) {
        return Lists.newArrayList(Arrays.asList(csv.split(",")));
    }

    public static <K, V> Map<K, V> subMap(Map<K, V> originalMap, Set<K> keys) {
        if (CollectionUtils.isEmpty(keys) || MapUtils.isEmpty(originalMap)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (K key : keys) {
            V value = originalMap.get(key);
            if (value != null) {
                result.put(key, value);
                continue;
            }
            if (!originalMap.containsKey(key)) continue;
            result.put(key, null);
        }
        return result;
    }

    public static List<ObjectId> transformToMongoObjectId(Collection<String> ids) {
        return CollectionUtils.transformToList(ids, STRING_TO_OBJECT_ID_TRANSFORMER);
    }

    public static <K, V> ConcurrentMap<K, V> transformToMap(Iterable<V> iterable, Transformer<V, K> keyTransformer, boolean throwExceptionOnDuplicateKeys) {
        ConcurrentMap rv = Maps.newConcurrentMap();
        for (V v : iterable) {
            K key;
            if (v == null || (key = keyTransformer.transform(v)) == null) continue;
            V old = rv.putIfAbsent(key, v);
            if (!throwExceptionOnDuplicateKeys || old == null) continue;
            throw new RuntimeException("Duplicate key - '" + key + "', existing: " + old + ",new: " + v);
        }
        return rv;
    }

    public static <T, S> Collection<S> getValuesOfMultipleKeysFromMap(Map<T, S> map, Collection<T> keys) {
        ArrayList<S> values = new ArrayList<S>();
        if (MapUtils.isEmpty(map) || CollectionUtils.isEmpty(keys)) {
            return values;
        }
        for (T key : keys) {
            S value = map.get(key);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static long[] transformToLongArray(Collection<String> batch) {
        if (CollectionUtils.isEmpty(batch)) {
            return new long[0];
        }
        int i = 0;
        long[] rv = new long[batch.size()];
        for (String id : batch) {
            rv[i++] = Long.parseLong(id);
        }
        return rv;
    }

    public static <T> Set<T> diff(Collection<T> before, Collection<T> after) {
        return Sets.difference(CollectionUtils.toSet(before), CollectionUtils.toSet(after));
    }

    public static <T> Set<T> intersection(Collection<T> before, Collection<T> after) {
        return Sets.intersection(CollectionUtils.toSet(before), CollectionUtils.toSet(after));
    }

    public static <K> Set<K> addedRemoved(Collection<K> coll1, Collection<K> coll2) {
        Set<K> set2;
        HashSet rv = Sets.newHashSet();
        Set<K> set1 = CollectionUtils.toSet(coll1);
        Sets.SetView diff = Sets.difference(set1, set2 = CollectionUtils.toSet(coll2));
        if (CollectionUtils.isNotEmpty((Collection)diff)) {
            rv.addAll(diff);
        }
        if (CollectionUtils.isNotEmpty((Collection)(diff = Sets.difference(set2, set1)))) {
            rv.addAll(diff);
        }
        return rv;
    }

    public static String getAnyNonBlankEntry(Collection<String> coll) {
        if (CollectionUtils.isEmpty(coll)) {
            return null;
        }
        for (String entry : coll) {
            if (!StringUtils.isNotBlank((String)entry)) continue;
            return entry;
        }
        return null;
    }

    public static <T> boolean safeDisjoint(Collection<T> c1, Collection<T> c2) {
        return CollectionUtils.isEmpty(c1) || CollectionUtils.isEmpty(c2) || Collections.disjoint(c1, c2);
    }

    public static <T> void traverse(Collection<T> collection, Callback<T> callback) {
        for (T element : collection) {
            callback.onVisit(element);
        }
    }

    public static <K, V> List<Map<K, V>> partitionMaps(Map<K, V> paramMap, int batchSize) {
        if (MapUtils.isEmpty(paramMap)) {
            return Collections.emptyList();
        }
        ArrayList<Map<K, V>> partitionedMaps = new ArrayList<Map<K, V>>();
        HashMap<K, V> currentMap = new HashMap<K, V>();
        partitionedMaps.add(currentMap);
        for (Map.Entry<K, V> entry : paramMap.entrySet()) {
            if (currentMap.size() == batchSize) {
                currentMap = new HashMap();
                partitionedMaps.add(currentMap);
            }
            currentMap.put(entry.getKey(), entry.getValue());
        }
        return partitionedMaps;
    }

    public static <K, V> List<LinkedHashMap<K, V>> partitionLinkedHashMaps(Map<K, V> paramMap, int batchSize) {
        if (MapUtils.isEmpty(paramMap)) {
            return Collections.emptyList();
        }
        ArrayList<LinkedHashMap<K, V>> partitionedMaps = new ArrayList<LinkedHashMap<K, V>>();
        LinkedHashMap<K, V> currentMap = new LinkedHashMap<K, V>();
        partitionedMaps.add(currentMap);
        for (Map.Entry<K, V> entry : paramMap.entrySet()) {
            if (currentMap.size() == batchSize) {
                currentMap = new LinkedHashMap();
                partitionedMaps.add(currentMap);
            }
            currentMap.put(entry.getKey(), entry.getValue());
        }
        return partitionedMaps;
    }

    public static <E> List<Set<E>> partitionSet(Set<E> param, int batchSize) {
        if (CollectionUtils.isEmpty(param)) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        HashSet<E> currentBatch = new HashSet<E>();
        result.add(currentBatch);
        for (E entry : param) {
            if (currentBatch.size() >= batchSize) {
                currentBatch = new HashSet();
                result.add(currentBatch);
            }
            currentBatch.add(entry);
        }
        return result;
    }

    public static <E> boolean listEquals(List<E> first, List<E> second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        Object[] firstArray = first.toArray(new Object[first.size()]);
        Ordering comparator = Ordering.natural().nullsLast();
        Arrays.sort(firstArray, comparator);
        Object[] secondArray = second.toArray(new Object[second.size()]);
        Arrays.sort(secondArray, comparator);
        return Arrays.equals(firstArray, secondArray);
    }

    public static <T> String mkString(Collection<T> list, String sep) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        for (T obj : list) {
            sb.append(obj.toString());
            sb.append(sep);
        }
        int sepLength = sep.length();
        int sbLength = sb.length();
        sb.delete(sbLength - sepLength, sbLength);
        return sb.toString();
    }

    @SafeVarargs
    public static <T> String mkString(String sep, T ... list) {
        return CollectionUtils.mkString(Arrays.asList(list), sep);
    }

    public static <K, V> Map<V, List<Map<K, V>>> groupBy(List<Map<K, V>> records, K groupByKey) {
        LinkedHashMap<V, ArrayList<Map<K, V>>> results = new LinkedHashMap<V, ArrayList<Map<K, V>>>();
        for (Map<K, V> record : records) {
            V groupByValue = record.get(groupByKey);
            ArrayList<Map<K, V>> groupByList = (ArrayList<Map<K, V>>)results.get(groupByValue);
            if (groupByList == null) {
                groupByList = new ArrayList<Map<K, V>>();
                results.put(groupByValue, groupByList);
            }
            groupByList.add(record);
        }
        return results;
    }

    public static boolean checkIfContainsAny(Collection<String> searchIn, Collection<String> searchFor) {
        for (String value : searchFor) {
            if (!searchIn.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAnySubString(Collection<String> searchIn, Collection<String> searchFor) {
        if (CollectionUtils.isEmpty(searchIn) || CollectionUtils.isEmpty(searchFor)) {
            return false;
        }
        for (String valueFor : searchFor) {
            for (String valueIn : searchIn) {
                if (!StringUtils.containsIgnoreCase((String)valueIn, (String)valueFor)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkIfContainsAny(Collection<String> searchIn, String ... searchFor) {
        if (CollectionUtils.isEmpty(searchFor) || CollectionUtils.isEmpty(searchIn)) {
            return false;
        }
        for (String value : searchFor) {
            if (!searchIn.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubStringMatch(Collection<String> searchIn, Collection<String> searchFor) {
        for (String value : searchFor) {
            for (String input : searchIn) {
                if (!input.contains(value)) continue;
                return true;
            }
        }
        return false;
    }

    public static void splitTimeRange(TimeRange timeRange, long timeWindow, TimeUnit windowTimeUnit, Callback<TimeRange> callback) {
        long timeWindowMillis = windowTimeUnit.toMillis(timeWindow);
        long fromTime = (Long)timeRange.getFrom();
        while (fromTime <= (Long)timeRange.getUpto()) {
            long uptoTime = Math.min(fromTime + timeWindowMillis, (Long)timeRange.getUpto());
            callback.onVisit(TimeRange.of(fromTime, uptoTime));
            fromTime = uptoTime + 1L;
        }
    }

    public static <K, V> boolean mapEquals(Map<K, List<V>> map1, Map<K, List<V>> map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<K, List<V>> entry : map1.entrySet()) {
            List<V> list2;
            List<V> list1 = map1.get(entry.getKey());
            if (CollectionUtils.listEquals(list1, list2 = map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static <K, V> V putAndGet(ConcurrentMap<K, V> errorKeyMap, K key, InstanceGeneratorByKey<K, V> generator) {
        Object errorKeys = errorKeyMap.get(key);
        if (errorKeys == null && (errorKeys = errorKeyMap.putIfAbsent(key, generator.getNewInstance(key))) == null) {
            errorKeys = errorKeyMap.get(key);
        }
        return errorKeys;
    }

    public static <K, V> V putAndGet(ConcurrentMap<K, V> errorKeyMap, K key, InstanceGenerator<V> generator) {
        Object errorKeys = errorKeyMap.get(key);
        if (errorKeys == null && (errorKeys = errorKeyMap.putIfAbsent(key, generator.getNewInstance())) == null) {
            errorKeys = errorKeyMap.get(key);
        }
        return errorKeys;
    }

    public static <K, V extends Comparable<V>> TreeMap<K, V> getMapSortedOnValue(Map<K, V> anyMap, boolean isAscending) {
        if (CollectionUtils.isEmpty(anyMap)) {
            return Maps.newTreeMap(new ValueComparator<K, V>(anyMap, isAscending));
        }
        TreeMap mapToReturn = Maps.newTreeMap(new ValueComparator<K, V>(anyMap, isAscending));
        for (Map.Entry<K, V> entry : anyMap.entrySet()) {
            mapToReturn.put(entry.getKey(), entry.getValue());
        }
        return mapToReturn;
    }

    public static <K, V extends Comparable<V>> TreeMap<K, V> getMapSortedOnValue(Map<K, V> anyMap, boolean isAscending, Comparator<V> comparator) {
        if (CollectionUtils.isEmpty(anyMap)) {
            return Maps.newTreeMap(new ValueComparator<K, V>(anyMap, isAscending, comparator));
        }
        TreeMap mapToReturn = Maps.newTreeMap(new ValueComparator<K, V>(anyMap, isAscending, comparator));
        for (Map.Entry<K, V> entry : anyMap.entrySet()) {
            mapToReturn.put(entry.getKey(), entry.getValue());
        }
        return mapToReturn;
    }

    public static <E> List<E> filterProcessed(Set<E> toProcess, Set<E> processed) {
        if (processed.isEmpty()) {
            return Lists.newArrayList(toProcess);
        }
        ArrayList toReturn = Lists.newArrayList();
        for (E entity : toProcess) {
            if (toProcess.contains(entity)) continue;
            toReturn.add(entity);
        }
        return toReturn;
    }

    public static boolean containsOneBlankStringOnly(Collection<String> collection) {
        return collection.size() == 1 && StringUtils.isBlank((String)collection.iterator().next());
    }

    public static boolean listContainsOneBlankStringOnly(List<String> stringList) {
        return stringList.size() == 1 && StringUtils.isBlank((String)stringList.get(0));
    }

    public static <E> boolean addToCollectionIfDoesntExist(Collection<E> collection, E obj) {
        if (collection == null || obj == null) {
            return false;
        }
        boolean exists = false;
        for (E e : collection) {
            if (!e.equals(obj)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            collection.add(obj);
        }
        return exists;
    }

    public static <E> void addIfNotNull(Collection<E> collection, E obj) {
        if (collection == null || obj == null) {
            return;
        }
        collection.add(obj);
    }

    public static <T> List<T> getRandomizedEntriesFromList(List<T> input) {
        if (CollectionUtils.isEmpty(input)) {
            return Collections.emptyList();
        }
        return CollectionUtils.getRandomizedEntriesFromList(input, input.size());
    }

    public static <T> List<T> getRandomizedEntriesFromList(List<T> input, int maxItems) {
        if (CollectionUtils.isEmpty(input)) {
            return Collections.emptyList();
        }
        ArrayList<T> shuffled = new ArrayList<T>(input);
        Collections.shuffle(shuffled);
        if (shuffled.size() <= maxItems) {
            return shuffled;
        }
        ArrayList rv = new ArrayList(maxItems);
        for (int i = 0; i < maxItems; ++i) {
            rv.add(shuffled.get(i));
        }
        return rv;
    }

    public static <E> boolean nullSafeRemove(Collection<E> collection, Collection<E> toRemove) {
        if (CollectionUtils.isEmpty(toRemove)) {
            return false;
        }
        return collection.removeAll(toRemove);
    }

    public static <T> List<T> getIntersection(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        if (CollectionUtils.isEmpty(list1) || CollectionUtils.isEmpty(list2)) {
            return list;
        }
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static Set<Integer> transformToInteger(Collection<Long> input) {
        if (CollectionUtils.isEmpty(input)) {
            return Collections.emptySet();
        }
        HashSet rv = Sets.newHashSet();
        for (Long i : input) {
            if (i == null) continue;
            rv.add(i.intValue());
        }
        return rv;
    }

    public static Set<Long> transformToLong(Collection<String> input) {
        if (CollectionUtils.isEmpty(input)) {
            return Collections.emptySet();
        }
        HashSet rv = Sets.newHashSet();
        for (String in : input) {
            if (!StringUtils.isNotBlank((String)in)) continue;
            rv.add(Long.parseLong(in));
        }
        return rv;
    }

    public static <T> Stream<T> minus(Collection<T> from, Collection<T> with) {
        return from.stream().filter(x -> !with.contains(x));
    }

    public static String joinWithComma(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (enumeration.hasMoreElements()) {
            String element = enumeration.nextElement();
            if (!StringUtils.isNotBlank((String)element)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(element);
        }
        return sb.toString();
    }

    public static String joinWithComma(String[] elements) {
        if (ArrayUtils.isEmpty((Object[])elements)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            if (!StringUtils.isNotBlank((String)element)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(element);
        }
        return sb.toString();
    }

    private static class ValueComparator<K, V extends Comparable<V>>
    implements Comparator<K> {
        private final Map<K, V> base;
        private final boolean isAscending;
        private final Comparator<V> comparator;

        public ValueComparator(Map<K, V> base, boolean isAscending) {
            this.base = base;
            this.isAscending = isAscending;
            this.comparator = null;
        }

        public ValueComparator(Map<K, V> base, boolean isAscending, Comparator<V> comparator) {
            this.base = base;
            this.isAscending = isAscending;
            this.comparator = comparator;
        }

        @Override
        public int compare(K a, K b) {
            Comparable value1 = (Comparable)this.base.get(a);
            Comparable value2 = (Comparable)this.base.get(b);
            if (this.comparator != null) {
                return this.returnByOrder() * this.comparator.compare(value1, value2);
            }
            if (value1 == null) {
                if (value2 != null) {
                    return this.returnByOrder() * -1;
                }
                return this.returnByOrder();
            }
            if (value2 == null) {
                return this.returnByOrder();
            }
            int toReturn = value1.compareTo(value2);
            return toReturn == 0 ? this.returnByOrder() : toReturn * this.returnByOrder();
        }

        private int returnByOrder() {
            return this.isAscending ? 1 : -1;
        }
    }

    public static interface InstanceGenerator<V> {
        public V getNewInstance();
    }

    public static interface InstanceGeneratorByKey<K, V> {
        public V getNewInstance(K var1);
    }

    public static abstract class CallbackWithArgs<T, A> {
        public abstract void onVisit(T var1, A var2);
    }

    public static abstract class Callback<T> {
        public abstract void onVisit(T var1);
    }

    public static interface CollectionProvider<T, C extends Collection<T>> {
        public C newCollection();
    }

    public static interface NamedTransformer<From, To>
    extends Transformer<From, To> {
        public String getTransformerName();
    }

    public static interface TransformerWithArgs<From, To, Arg> {
        public To transform(From var1, Arg var2);
    }

    public static interface Transformer<From, To> {
        public static <T> Transformer<T, T> identity() {
            return t -> t;
        }

        public To transform(From var1);
    }

    public static class GroupKey {
        private Object[] keys;

        public GroupKey(Object ... keys) {
            this.keys = keys;
        }

        public Object[] getKeys() {
            return this.keys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupKey groupKey = (GroupKey)o;
            return Arrays.equals(this.keys, groupKey.keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }
    }

    public static interface GroupByStrategy<T> {
        public GroupKey group(T var1);
    }
}

