/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.util;

import com.lyncode.jtwig.functions.exceptions.FunctionException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public class Requirements {
    private Object[] arguments;

    public static Requirements requires(Object ... arguments) {
        return new Requirements(arguments);
    }

    public Requirements(Object ... arguments) {
        this.arguments = arguments;
    }

    public Requirements withNumberOfArguments(Matcher<Integer> predicate) throws FunctionException {
        StringDescription description = new StringDescription();
        predicate.describeTo((Description)description);
        if (!predicate.matches((Object)this.arguments.length)) {
            throw new FunctionException("Invalid number of arguments, it should be " + description.toString());
        }
        return this;
    }

    public Requirements withArgument(int number, Matcher<Object> predicate) throws FunctionException {
        StringDescription description = new StringDescription();
        predicate.describeTo((Description)description);
        if (!predicate.matches(this.arguments[number])) {
            throw new FunctionException("Invalid argument " + number + " (" + this.arguments[number] + "). It should " + description.toString());
        }
        return this;
    }

    public static Matcher<Object> isArray() {
        return new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                return item.getClass().isArray();
            }

            public void describeTo(Description description) {
                description.appendText("is array");
            }
        };
    }

    public static Matcher<Integer> between(final int start, final int end) {
        return new TypeSafeMatcher<Integer>(){

            protected boolean matchesSafely(Integer item) {
                return item >= start && item <= end;
            }

            public void describeTo(Description description) {
                description.appendText("between ").appendValue((Object)start).appendText(" and ").appendValue((Object)end);
            }
        };
    }
}

