/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlUtils {
    private static final String START_COMMENT = "<!--";
    private static final String END_COMMENT = "-->";

    public static String stripTags(String input, String allowedTags) {
        return HtmlUtils.removeUnknownTags(HtmlUtils.removeHtmlComments(input), allowedTags);
    }

    public static String stripTags(String input) {
        return HtmlUtils.removeUnknownTags(HtmlUtils.removeHtmlComments(input), "");
    }

    private static String removeUnknownTags(String input, String knownTags) {
        List<String> knownTagList = Arrays.asList(knownTags.replaceAll("^<", "").replaceAll(">$", "").split("><"));
        return HtmlUtils.removeTags(input, knownTagList);
    }

    private static String removeTags(String input, List<String> knownTagList) {
        Pattern tag = Pattern.compile("</?([^\\s>]*)\\s*[^>]*>", 2);
        Matcher matches = tag.matcher(input);
        while (matches.find()) {
            if (knownTagList.contains(matches.group(1))) continue;
            input = input.replaceAll(Pattern.quote(matches.group()), "");
        }
        return input;
    }

    private static String removeTags(String input, String startTag, String endTag) {
        while (input.contains(startTag)) {
            int start = input.indexOf(startTag);
            int end = input.substring(start + startTag.length()).indexOf(endTag);
            if (end == -1) {
                input = input.substring(0, start);
                continue;
            }
            input = input.substring(0, start) + input.substring(start + startTag.length() + end + endTag.length());
        }
        return input;
    }

    private static String removeHtmlComments(String input) {
        return HtmlUtils.removeTags(input, START_COMMENT, END_COMMENT);
    }
}

