/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.internal.math;

import com.lyncode.jtwig.functions.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.JtwigFunctionDeclaration;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.Requirements;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;

@JtwigFunctionDeclaration(name="number_format")
public class JNumberFormat
implements JtwigFunction {
    @Override
    public Object execute(Object ... arguments) throws FunctionException {
        String separator;
        Requirements.requires(arguments).withNumberOfArguments(Requirements.between(1, 4)).withArgument(1, (Matcher<Object>)IsInstanceOf.instanceOf(Integer.class));
        DecimalFormat numberFormat = new DecimalFormat();
        DecimalFormatSymbols decimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
        if (arguments.length > 1) {
            numberFormat.setMaximumFractionDigits((Integer)arguments[1]);
            numberFormat.setMinimumFractionDigits((Integer)arguments[1]);
        }
        if (arguments.length > 2) {
            separator = arguments[2].toString();
            if (!separator.isEmpty()) {
                decimalFormatSymbols.setDecimalSeparator(separator.charAt(0));
            } else {
                decimalFormatSymbols.setDecimalSeparator('\u0000');
            }
        }
        if (arguments.length > 3) {
            separator = arguments[3].toString();
            if (!separator.isEmpty()) {
                decimalFormatSymbols.setGroupingSeparator(separator.charAt(0));
            } else {
                decimalFormatSymbols.setGroupingSeparator('\u0000');
            }
        }
        numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return numberFormat.format(arguments[0]);
    }
}

